/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class EventFlag {
    private static DecimalFormat FORMATTER = new DecimalFormat("0.00");
    private static final TimeInterval TWO_MINUTES = new TimeInterval(2.0, UnitImpl.MINUTE);
    private static final TimeInterval TEN_MINUTES = new TimeInterval(10.0, UnitImpl.MINUTE);
    private int titleX;
    private int titleY;
    private int titleWidth;
    private int titleHeight;
    private String eventTitle;
    private PlottableDisplay display;
    private EventAccessOperations eventAccess;
    private Color color = SeismogramDisplay.COLORS[++colorCount % SeismogramDisplay.COLORS.length];
    protected Arrival[] arrivals;
    private static int colorCount = 0;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$display$drawable$EventFlag == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$EventFlag = EventFlag.class$("edu.sc.seis.fissuresUtil.display.drawable.EventFlag")) : class$edu$sc$seis$fissuresUtil$display$drawable$EventFlag));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$EventFlag;

    public EventFlag(PlottableDisplay plottableDisplay, EventAccessOperations eventAccess, Arrival[] arrivals) {
        this.display = plottableDisplay;
        this.eventAccess = eventAccess;
        this.arrivals = arrivals;
    }

    public int getOriginX() {
        return this.getX(this.getOriginXPercent());
    }

    public int getOriginY() {
        return this.getY(this.getOriginRow());
    }

    protected int getY(int row) {
        return row * this.display.getRowOffset() + this.display.titleHeight;
    }

    public int getX(Arrival arrival) {
        return this.getX(this.getXPercent(arrival));
    }

    protected int getX(MicroSecondDate time) {
        return this.getX(this.getXPercent(time));
    }

    private int getX(double xPercentage) {
        return (int)(xPercentage * (double)this.display.getRowWidth()) + 50;
    }

    public int getY(Arrival arrival) {
        return this.getY(this.getRow(arrival));
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(3.0f));
        g2.setPaint(this.color);
        int halfOffset = this.display.getRowOffset() / 2;
        int x = this.getOriginX();
        int y = this.getOriginY();
        this.drawFlagAndPole("Origin", x, y, halfOffset, g2, true);
        for (int i = 0; i < this.arrivals.length; ++i) {
            x = this.getX(this.arrivals[i]);
            y = this.getY(this.arrivals[i]);
            this.drawFlagAndPole(this.arrivals[i].getName(), x, y, halfOffset, g2);
        }
    }

    private void drawFlagAndPole(String title, int x, int y, int halfOffset, Graphics2D g2) {
        this.drawFlagAndPole(title, x, y, halfOffset, g2, false);
    }

    private void drawFlagAndPole(String title, int x, int y, int halfOffset, Graphics2D g2, boolean reverseWindDirection) {
        g2.setColor(this.color);
        g2.drawLine(x, y - halfOffset, x, y + halfOffset);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(title, g2);
        int textY = y - halfOffset;
        if (reverseWindDirection) {
            x = (int)((double)x - stringBounds.getWidth());
        }
        stringBounds.setRect(x, textY, stringBounds.getWidth() + 3.0, stringBounds.getHeight());
        g2.fill(stringBounds);
        g2.setColor(Color.WHITE);
        g2.drawString(title, x, (int)((double)textY + stringBounds.getHeight() - 3.0));
    }

    public boolean isSelected(int[][] rowAndX) {
        int row = this.getOriginRow();
        int x = this.getOriginX();
        if (EventFlag.intersects(rowAndX, x, row)) {
            return true;
        }
        for (int i = 0; i < this.arrivals.length; ++i) {
            row = this.getRow(this.arrivals[i]);
            x = this.getX(this.arrivals[i]);
            if (!EventFlag.intersects(rowAndX, x, row)) continue;
            return true;
        }
        return false;
    }

    private static boolean intersects(int[][] rowAndX, int x, int row) {
        for (int i = 0; i < rowAndX.length; ++i) {
            int[] cur = rowAndX[i];
            if (row != cur[0] || x > cur[2] || x < cur[1]) continue;
            return true;
        }
        return false;
    }

    protected MicroSecondDate getOriginTime() {
        return new MicroSecondDate(EventUtil.extractOrigin((EventAccessOperations)this.eventAccess).origin_time);
    }

    private int getOriginRow() {
        return this.getRow(this.getOriginTime());
    }

    private int getRow(Arrival arrival) {
        return this.getRow(this.getTime(arrival));
    }

    private MicroSecondDate getTime(Arrival arrival) {
        MicroSecondDate eventTime = this.getOriginTime();
        return new MicroSecondDate((long)(arrival.getTime() * 1000000.0) + eventTime.getMicroSecondTime());
    }

    protected int getRow(MicroSecondDate time) {
        MicroSecondDate startTime = new MicroSecondDate(this.display.getDate());
        QuantityImpl intervalInHours = time.subtract(startTime).convertTo(UnitImpl.HOUR);
        return (int)intervalInHours.get_value() / 2;
    }

    private double getOriginXPercent() {
        return this.getXPercent(this.getOriginTime());
    }

    private double getXPercent(Arrival arrival) {
        return this.getXPercent(this.getTime(arrival));
    }

    protected double getXPercent(MicroSecondDate time) {
        MicroSecondDate startTime = new MicroSecondDate(this.display.getDate());
        TimeInterval interval = time.subtract(startTime);
        QuantityImpl intervalInHours = interval.convertTo(UnitImpl.HOUR);
        QuantityImpl intervalInMinutes = interval.convertTo(UnitImpl.MINUTE);
        int hours = (int)intervalInHours.get_value();
        int minutes = (int)((intervalInHours.get_value() - (double)((int)intervalInHours.get_value())) * 60.0);
        int seconds = (int)((intervalInMinutes.get_value() - (double)((int)intervalInMinutes.get_value())) * 60.0);
        double hoursPerRow = 24 / this.display.getRows();
        double leftoverHours = (double)hours % hoursPerRow;
        leftoverHours += (double)minutes / 60.0;
        double xPercent = (leftoverHours += (double)seconds / 60.0 / 60.0) / hoursPerRow;
        return xPercent;
    }

    public void setTitleLoc(int x, int y, int width, int height) {
        this.titleX = x;
        this.titleY = y;
        this.titleWidth = width;
        this.titleHeight = height;
    }

    public Rectangle getTitleLoc() {
        return new Rectangle(this.titleX, this.titleY, this.titleWidth, this.titleHeight);
    }

    public String getTitle() {
        if (this.eventTitle == null) {
            this.eventTitle = this.arrivals.length != 0 ? EventUtil.getEventInfo(this.eventAccess, "LOC | Mag: MAG | Depth: DEPTH DEPTH_UNIT | Distance ") + FORMATTER.format(this.arrivals[0].getDistDeg()) + " Degrees" : EventUtil.getEventInfo(this.eventAccess, "LOC | Mag: MAG | Depth: DEPTH DEPTH_UNIT");
        }
        return this.eventTitle;
    }

    public int[][] getEventCoverage() {
        MicroSecondDate earliestTime = null;
        MicroSecondDate latestTime = null;
        for (int i = 0; i < this.arrivals.length; ++i) {
            MicroSecondDate arrivalTime = this.getTime(this.arrivals[i]);
            if (earliestTime == null || arrivalTime.before((Date)earliestTime)) {
                earliestTime = arrivalTime;
            }
            if (latestTime != null && !arrivalTime.after((Date)latestTime)) continue;
            latestTime = arrivalTime;
        }
        MicroSecondDate twoEarlier = earliestTime.subtract(TWO_MINUTES);
        MicroSecondDate tenLater = latestTime.add(TEN_MINUTES);
        int[][] coverage = new int[][]{{this.getRow(twoEarlier), this.getX(twoEarlier)}, {this.getRow(tenLater), this.getX(tenLater)}};
        return coverage;
    }

    public void setAlpha(int alpha) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha);
    }

    public EventAccessOperations getEvent() {
        return this.eventAccess;
    }

    public Color getColor() {
        return this.color;
    }

    public PlottableDisplay getDisplay() {
        return this.display;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

