/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.display.drawable.NamedDrawable;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Event
implements NamedDrawable {
    private Color color = Color.RED;
    private List flags;
    private boolean visible = true;
    private String name;

    public Event(Arrival[] arrivals, MicroSecondDate originTime, DrawableSeismogram seis) {
        this(arrivals, originTime, seis, null);
    }

    public Event(Arrival[] arrivals, MicroSecondDate originTime, DrawableSeismogram seis, String name) {
        this.flags = new ArrayList(arrivals.length);
        for (int i = 0; i < arrivals.length; ++i) {
            MicroSecondDate time = new MicroSecondDate((long)(arrivals[i].getTime() * 1000000.0) + originTime.getMicroSecondTime());
            this.flags.add(new Flag(time, arrivals[i].getName(), seis));
        }
        this.flags.add(new Flag(originTime, "Origin", seis));
        this.name = name;
    }

    public void setVisibility(boolean b) {
        this.visible = b;
    }

    public void setColor(Color color) {
        Iterator it = this.flags.iterator();
        while (it.hasNext()) {
            ((Flag)it.next()).setColor(color);
        }
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Rectangle2D drawName(Graphics2D canvas, int xPosition, int yPosition) {
        if (this.visible && this.name != null) {
            canvas.drawString(this.name, xPosition, yPosition);
            FontMetrics fm = canvas.getFontMetrics();
            Rectangle2D stringBounds = fm.getStringBounds(this.name, canvas);
            return stringBounds;
        }
        return DisplayUtils.EMPTY_RECTANGLE;
    }

    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        if (this.visible) {
            Iterator it = this.flags.iterator();
            while (it.hasNext()) {
                ((Drawable)it.next()).draw(canvas, size, currentTime, currentAmp);
            }
        }
    }
}

