/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.configuration.AmpConfigConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.BorderConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ColorClassConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ColorConfiguration;
import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.display.configuration.TimeConfigConfiguration;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SeismogramDisplayConfiguration
implements Cloneable {
    private String type = "basic";
    private List borders = new ArrayList();
    private List colorClasses = new ArrayList();
    private TimeConfigConfiguration tcConfig;
    private AmpConfigConfiguration acConfig;
    private boolean swapAxes = false;
    private boolean drawNamesForNamedDrawables = true;
    private boolean makeDefault = true;
    private ColorConfiguration borderBackground;
    private ColorConfiguration borderColor;
    private static ConfigDefinitions defs = new ConfigDefinitions();

    public void configure(Element el) throws NoSuchFieldException {
        this.makeDefault = false;
        this.type = DOMHelper.extractText(el, "type", this.type);
        this.checkForColorClass(el, "flagColors");
        this.checkForColorClass(el, "traceColors");
        if (DOMHelper.hasElement(el, "borderBackground")) {
            this.borderBackground = ColorConfiguration.create(DOMHelper.getElement(el, "borderBackground"));
        }
        if (DOMHelper.hasElement(el, "borderColor")) {
            this.borderColor = ColorConfiguration.create(DOMHelper.getElement(el, "borderColor"));
        }
        NodeList borderNodes = DOMHelper.extractNodes(el, "border");
        for (int i = 0; i < borderNodes.getLength(); ++i) {
            this.borders.add(BorderConfiguration.create((Element)borderNodes.item(i), this.borderColor, this.borderBackground));
        }
        if (DOMHelper.hasElement(el, "dontDrawNamedDrawableNames")) {
            this.drawNamesForNamedDrawables = false;
        }
        if (DOMHelper.hasElement(el, "swapAxes")) {
            this.swapAxes = true;
        }
        if (DOMHelper.hasElement(el, "timeConfig")) {
            Element timeConfigEl = DOMHelper.getElement(el, "timeConfig");
            this.tcConfig = TimeConfigConfiguration.create(timeConfigEl);
        }
        if (DOMHelper.hasElement(el, "ampConfig")) {
            Element ampConfigEl = DOMHelper.getElement(el, "ampConfig");
            this.acConfig = AmpConfigConfiguration.create(ampConfigEl);
        }
    }

    public static SeismogramDisplayConfiguration create(Element el) throws NoSuchFieldException {
        SeismogramDisplayConfiguration c = null;
        if (defs.hasDefinition(el)) {
            SeismogramDisplayConfiguration base = (SeismogramDisplayConfiguration)defs.getDefinition(el);
            c = (SeismogramDisplayConfiguration)base.clone();
        } else {
            c = new SeismogramDisplayConfiguration();
        }
        c.configure(el);
        defs.updateDefinitions(el, c);
        return c;
    }

    private void checkForColorClass(Element el, String tagName) {
        if (DOMHelper.hasElement(el, tagName)) {
            this.colorClasses.add(new ColorClassConfiguration(DOMHelper.getElement(el, tagName)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public SeismogramDisplay createDisplay() {
        void var1_1;
        SeismogramDisplay disp;
        if (this.makeDefault) {
            return new BasicSeismogramDisplay();
        }
        if (this.type.equals("recordSection")) {
            disp = new RecordSectionDisplay(this.swapAxes);
        } else if (this.type.equals("basic")) {
            disp = new BasicSeismogramDisplay();
        } else {
            try {
                Class<?> dispClass = Class.forName(this.type);
                Constructor<?> constructor = dispClass.getConstructor(new Class[0]);
                disp = (SeismogramDisplay)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Problem instantiating " + this.type + ".  It must be in the classpath, take a constructor with no arguments, and extend SeismogramDisplay");
            }
        }
        var1_1.setDrawNamesForNamedDrawables(this.drawNamesForNamedDrawables);
        var1_1.clearBorders();
        Iterator it = this.borders.iterator();
        while (it.hasNext()) {
            BorderConfiguration border = (BorderConfiguration)it.next();
            var1_1.add(border.createBorder((SeismogramDisplay)var1_1), border.getPosition());
        }
        if (this.borderBackground != null) {
            var1_1.setBackground(this.borderBackground.createColor());
        }
        it = this.colorClasses.iterator();
        while (it.hasNext()) {
            ColorClassConfiguration cur = (ColorClassConfiguration)it.next();
            var1_1.setColors(cur.getColorClass(), cur.getColors());
        }
        if (this.acConfig != null) {
            var1_1.setAmpConfig(this.acConfig.createAmpConfig());
        }
        if (this.tcConfig != null) {
            var1_1.setTimeConfig(this.tcConfig.createTimeConfig());
        }
        return var1_1;
    }

    public Object clone() {
        SeismogramDisplayConfiguration clone = new SeismogramDisplayConfiguration();
        clone.type = this.type;
        clone.colorClasses.addAll(this.colorClasses);
        clone.borders.addAll(this.borders);
        clone.swapAxes = this.swapAxes;
        clone.drawNamesForNamedDrawables = this.drawNamesForNamedDrawables;
        clone.borderBackground = this.borderBackground;
        clone.borderColor = this.borderColor;
        clone.acConfig = this.acConfig;
        clone.tcConfig = this.tcConfig;
        return clone;
    }

    public String getType() {
        return this.type;
    }
}

