/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.configuration;

import edu.sc.seis.fissuresUtil.display.configuration.ConfigDefinitions;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.awt.Color;
import org.w3c.dom.Element;

public class ColorConfiguration
implements Cloneable {
    private static ConfigDefinitions defs = new ConfigDefinitions();
    private String r = "255";
    private String g = "255";
    private String b = "255";
    private String a = "255";

    public void configure(Element el) {
        this.r = DOMHelper.extractText(el, "red", this.r);
        this.g = DOMHelper.extractText(el, "green", this.g);
        this.b = DOMHelper.extractText(el, "blue", this.b);
        this.a = DOMHelper.extractText(el, "alpha", this.a);
    }

    public static ColorConfiguration create(Element el) {
        ColorConfiguration c = null;
        if (defs.hasDefinition(el)) {
            try {
                ColorConfiguration base = (ColorConfiguration)defs.getDefinition(el);
                if (base == null) {
                    throw new NullPointerException("Unable to find a base for " + el.getAttribute("base"));
                }
                c = (ColorConfiguration)base.clone();
            }
            catch (CloneNotSupportedException e) {
                GlobalExceptionHandler.handle("But I added clone to this object....");
            }
        } else {
            c = new ColorConfiguration();
        }
        c.configure(el);
        defs.updateDefinitions(el, c);
        return c;
    }

    public Color createColor() {
        return new Color(Integer.parseInt(this.r), Integer.parseInt(this.g), Integer.parseInt(this.b), Integer.parseInt(this.a));
    }

    public String toString() {
        return "ColorConfiguration that produces " + this.createColor();
    }
}

