/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.Selection;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import org.apache.log4j.Logger;

public abstract class VerticalSeismogramDisplay
extends SeismogramDisplay {
    private static final Color EVEN = new Color(0, 0, 0, 0);
    private static final Color ODD = Color.WHITE;
    protected CenterPanel cp;
    protected boolean globalizedAmp = false;
    protected TimeConfig tc = new BasicTimeConfig();
    protected AmpConfig ac = new RMeanAmpConfig();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$display$VerticalSeismogramDisplay == null ? (class$edu$sc$seis$fissuresUtil$display$VerticalSeismogramDisplay = VerticalSeismogramDisplay.class$("edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay")) : class$edu$sc$seis$fissuresUtil$display$VerticalSeismogramDisplay));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$VerticalSeismogramDisplay;

    public SeismogramDisplayProvider createCenter() {
        if (this.cp == null) {
            this.cp = new CenterPanel();
        }
        return this.cp;
    }

    public abstract void add(DataSetSeismogram[] var1);

    public void remove(DataSetSeismogram[] dss) {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((BasicSeismogramDisplay)this.cp.getComponent(i)).remove(dss);
        }
    }

    public boolean contains(DataSetSeismogram seismo) {
        return this.get(seismo) != null;
    }

    public SeismogramDisplay get(DataSetSeismogram seismo) {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            if (!((SeismogramDisplay)this.cp.getComponent(i)).contains(seismo)) continue;
            return (SeismogramDisplay)this.cp.getComponent(i);
        }
        return null;
    }

    public void add(Drawable drawable) {
    }

    public void remove(Drawable drawable) {
    }

    public DrawableIterator getDrawables(MouseEvent e) {
        return null;
    }

    public LinkedList getDisplays() {
        LinkedList<Component> disps = new LinkedList<Component>();
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            disps.add(this.cp.getComponent(i));
        }
        return disps;
    }

    public DataSetSeismogram[] getSeismograms() {
        ArrayList<DataSetSeismogram> grams = new ArrayList<DataSetSeismogram>();
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            DataSetSeismogram[] seismos = ((SeismogramDisplay)this.cp.getComponent(i)).getSeismograms();
            for (int j = 0; j < seismos.length; ++j) {
                grams.add(seismos[j]);
            }
        }
        return grams.toArray(new DataSetSeismogram[grams.size()]);
    }

    public void remove(Selection selection) {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((SeismogramDisplay)this.cp.getComponent(i)).remove(selection);
        }
    }

    public DrawableIterator iterator(Class drawableClass) {
        ArrayList<Component> basicDisplays = new ArrayList<Component>();
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            basicDisplays.add(this.cp.getComponent(i));
        }
        return new DrawableIterator(drawableClass, VerticalSeismogramDisplay.getAllDrawables(drawableClass, basicDisplays));
    }

    private static List getAllDrawables(Class drawableClass, List displays) {
        LinkedList<Object> allDrawables = new LinkedList<Object>();
        Iterator it = displays.iterator();
        while (it.hasNext()) {
            SeismogramDisplay cur = (SeismogramDisplay)it.next();
            DrawableIterator drawIt = cur.iterator(drawableClass);
            while (drawIt.hasNext()) {
                allDrawables.add(drawIt.next());
            }
        }
        return allDrawables;
    }

    protected void setBorders() {
        this.cp.setBorders();
    }

    public void clearSelections() {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((BasicSeismogramDisplay)this.cp.getComponent(i)).clearSelections();
        }
    }

    public void clear() {
        this.cp.removeAll();
        this.tc.reset();
        this.ac.reset();
        this.repaint();
    }

    public void print() {
    }

    public void removeAll() {
        this.clear();
    }

    public boolean removeDisplay(BasicSeismogramDisplay display) {
        if (this.cp.contains(display)) {
            if (this.cp.getComponentCount() == 1) {
                this.clear();
            }
            this.cp.remove(display);
            this.setBorders();
            this.revalidate();
            return true;
        }
        return false;
    }

    public void setAmpConfig(AmpConfig ac) {
        this.ac = ac;
    }

    public void setGlobalizedAmpConfig(AmpConfig ac) {
        this.setAmpConfig(ac);
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((SeismogramDisplay)this.cp.getComponent(i)).setAmpConfig(ac);
        }
        this.globalizedAmp = true;
        this.tc.addListener(ac);
    }

    public void setIndividualizedAmpConfig(AmpConfig ac) {
        Class<?> configClass = ac.getClass();
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            SeismogramDisplay cur = (SeismogramDisplay)this.cp.getComponent(i);
            try {
                cur.setAmpConfig((AmpConfig)configClass.newInstance());
                continue;
            }
            catch (IllegalAccessException e) {
                GlobalExceptionHandler.handle("Problem creating ampConfig from class", e);
                continue;
            }
            catch (InstantiationException e) {
                GlobalExceptionHandler.handle("Problem creating ampConfig from class", e);
            }
        }
        this.tc.removeListener(ac);
        this.globalizedAmp = false;
    }

    public AmpConfig getAmpConfig() {
        return this.ac;
    }

    public void setTimeConfig(TimeConfig config) {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            SeismogramDisplay cur = (SeismogramDisplay)this.cp.getComponent(i);
            if (!cur.getTimeConfig().equals(this.tc)) continue;
            cur.setTimeConfig(config);
        }
        if (this.globalizedAmp) {
            config.addListener(this.ac);
        }
        this.tc = config;
    }

    public TimeConfig getTimeConfig() {
        return this.tc;
    }

    public void reset() {
        this.tc.reset();
        this.ac.reset();
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((SeismogramDisplay)this.cp.getComponent(i)).reset();
        }
    }

    public void reset(DataSetSeismogram[] seismos) {
        for (int i = 0; i < this.cp.getComponentCount(); ++i) {
            ((SeismogramDisplay)this.cp.getComponent(i)).reset(seismos);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CenterPanel
    extends SeismogramDisplayProvider {
        public CenterPanel() {
            BoxLayout layout = new BoxLayout(this, 1);
            this.setLayout(layout);
        }

        public SeismogramDisplay provide() {
            return VerticalSeismogramDisplay.this;
        }

        public boolean contains(SeismogramDisplay sd) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                if (this.getComponent(i) != sd) continue;
                return true;
            }
            return false;
        }

        public void setBorders() {
            if (this.getComponentCount() >= 1) {
                if (!this.get(0).isFilled(1)) {
                    this.get(0).add(new TimeBorder(this.get(0)), 1);
                }
                if (this.getComponentCount() > 1) {
                    this.get(0).clear(7);
                    this.getLast().clear(1);
                }
                for (int i = 1; i < this.getComponentCount() - 1; ++i) {
                    this.get(i).clear(1);
                    this.get(i).clear(7);
                }
                if (!this.getLast().isFilled(7)) {
                    this.getLast().add(new TimeBorder(this.getLast(), 3), 7);
                }
            }
            this.validate();
        }

        private SeismogramDisplay get(int pos) {
            return (SeismogramDisplay)super.getComponent(pos);
        }

        private SeismogramDisplay getLast() {
            return this.get(this.getComponentCount() - 1);
        }
    }
}

