/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import java.awt.Dimension;
import java.util.Date;
import org.apache.log4j.Category;

public class SimplePlotUtil {
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    public static final int SPIKE_SAMPLES_PER_SECOND = 20;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$SimplePlotUtil == null ? (class$edu$sc$seis$fissuresUtil$display$SimplePlotUtil = SimplePlotUtil.class$("edu.sc.seis.fissuresUtil.display.SimplePlotUtil")) : class$edu$sc$seis$fissuresUtil$display$SimplePlotUtil).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$SimplePlotUtil;

    public static Plottable makePlottable(LocalSeismogramImpl seis, MicroSecondTimeRange tr, int pixelsPerDay) throws CodecException {
        if (tr.getEndTime().before((Date)seis.getBeginTime()) || tr.getBeginTime().after((Date)seis.getEndTime())) {
            if (tr.getEndTime().before((Date)seis.getEndTime())) {
                logger.debug((Object)"tr.getEndTime().before(seis.getEndTime())");
            } else {
                logger.debug((Object)"tr.getBeginTime().after(seis.getEndTime())");
            }
            int[] empty = new int[]{};
            return new Plottable(empty, empty);
        }
        double pixelPeriod = 1.0 / (double)pixelsPerDay;
        TimeInterval trInt = (TimeInterval)tr.getInterval().convertTo(UnitImpl.DAY);
        double exactNumPixels = trInt.divideBy(pixelPeriod).getValue();
        int numPixels = (int)Math.ceil(exactNumPixels);
        TimeInterval pointPeriod = (TimeInterval)seis.getSampling().getPeriod().convertTo(UnitImpl.DAY);
        double pointsPerPixel = pixelPeriod / pointPeriod.getValue();
        int startPoint = SimplePlotUtil.getPoint(seis, tr.getBeginTime());
        int endPoint = startPoint + (int)(pointsPerPixel * (double)numPixels);
        int startPixel = 0;
        if (startPoint < 0) {
            startPixel = (int)Math.floor((double)(startPoint * -1) / pointsPerPixel);
            numPixels -= startPixel;
        }
        if (endPoint > seis.getNumPoints()) {
            int pointShift = endPoint - seis.getNumPoints();
            numPixels -= (int)Math.floor((double)pointShift / pointsPerPixel);
            endPoint = seis.getNumPoints();
        }
        int[][] pixels = new int[2][numPixels * 2];
        int pixelPoint = startPoint < 0 ? 0 : startPoint;
        for (int i = 0; i < numPixels; ++i) {
            int pos = 2 * i;
            int nextPos = pos + 1;
            pixels[0][pos] = startPixel + i;
            pixels[0][nextPos] = pixels[0][pos];
            int nextPixelPoint = startPoint + (int)((double)(pixels[0][pos] + 1) * pointsPerPixel);
            if (i == numPixels - 1) {
                nextPixelPoint = endPoint;
            }
            QuantityImpl min = seis.getMinValue(pixelPoint, nextPixelPoint);
            pixels[1][pos] = (int)min.getValue();
            QuantityImpl max = seis.getMaxValue(pixelPoint, nextPixelPoint);
            pixels[1][nextPos] = (int)max.getValue();
            pixelPoint = nextPixelPoint;
        }
        return new Plottable(pixels[0], pixels[1]);
    }

    public static int[][] compressXvalues(LocalSeismogram seismogram, MicroSecondTimeRange timeRange, Dimension size) throws CodecException {
        LocalSeismogramImpl seis = (LocalSeismogramImpl)seismogram;
        int width = size.width;
        int[][] out = new int[2][];
        if (seis.getEndTime().before((Date)timeRange.getBeginTime()) || seis.getBeginTime().after((Date)timeRange.getEndTime())) {
            out[0] = new int[0];
            out[1] = new int[0];
            logger.info((Object)"The end time is before the beginTime in simple seismogram");
            return out;
        }
        MicroSecondDate tMin = timeRange.getBeginTime();
        MicroSecondDate tMax = timeRange.getEndTime();
        int seisStartIndex = SimplePlotUtil.getPoint(seis, tMin);
        int seisEndIndex = SimplePlotUtil.getPoint(seis, tMax);
        if (seisStartIndex < 0) {
            seisStartIndex = 0;
        }
        if (seisEndIndex >= seis.getNumPoints()) {
            seisEndIndex = seis.getNumPoints() - 1;
        }
        MicroSecondDate tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisStartIndex);
        int pixelStartIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        tempdate = SimplePlotUtil.getValue(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), seisEndIndex);
        int pixelEndIndex = SimplePlotUtil.getPixel(width, timeRange, tempdate);
        int pixels = seisEndIndex - seisStartIndex + 1;
        out[0] = new int[2 * pixels];
        out[1] = new int[out[0].length];
        int[] tempYvalues = new int[out[0].length];
        int seisIndex = seisStartIndex;
        int numAdded = 0;
        int xvalue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
        int tempValue = 0;
        ++seisIndex;
        int j = 0;
        while (seisIndex <= seisEndIndex) {
            tempValue = Math.round((float)SimplePlotUtil.linearInterp(seisStartIndex, pixelStartIndex, seisEndIndex, pixelEndIndex, seisIndex));
            tempYvalues[j++] = (int)seis.getValueAt(seisIndex).getValue();
            if (tempValue != xvalue) {
                out[0][numAdded] = xvalue;
                out[0][numAdded + 1] = xvalue;
                out[1][numAdded] = SimplePlotUtil.getMinValue(tempYvalues, 0, j - 1);
                out[1][numAdded + 1] = SimplePlotUtil.getMaxValue(tempYvalues, 0, j - 1);
                j = 0;
                xvalue = tempValue;
                numAdded += 2;
            }
            ++seisIndex;
        }
        int[][] temp = new int[2][numAdded];
        System.arraycopy(out[0], 0, temp[0], 0, numAdded);
        System.arraycopy(out[1], 0, temp[1], 0, numAdded);
        return temp;
    }

    private static int getMinValue(int[] yValues, int startIndex, int endIndex) {
        int minValue = Integer.MAX_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] >= minValue) continue;
            minValue = yValues[i];
        }
        return minValue;
    }

    private static int getMaxValue(int[] yValues, int startIndex, int endIndex) {
        int maxValue = Integer.MIN_VALUE;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (yValues[i] <= maxValue) continue;
            maxValue = yValues[i];
        }
        return maxValue;
    }

    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        if (x == xa) {
            return ya;
        }
        if (x == xb) {
            return yb;
        }
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    public static final int getPixel(int totalPixels, MicroSecondTimeRange tr, MicroSecondDate value) {
        return SimplePlotUtil.getPixel(totalPixels, tr.getBeginTime(), tr.getEndTime(), value);
    }

    public static final int getPoint(LocalSeismogramImpl seis, MicroSecondDate time) {
        return SimplePlotUtil.getPixel(seis.getNumPoints(), seis.getBeginTime(), seis.getEndTime(), time);
    }

    public static final int getPixel(int totalPixels, MicroSecondDate begin, MicroSecondDate end, MicroSecondDate value) {
        return (int)Math.round(SimplePlotUtil.linearInterp(begin.getMicroSecondTime(), 0.0, end.getMicroSecondTime(), totalPixels, value.getMicroSecondTime()));
    }

    public static final MicroSecondDate getValue(int totalPixels, MicroSecondDate begin, MicroSecondDate end, int pixel) {
        double value = SimplePlotUtil.linearInterp(0.0, 0.0, totalPixels, end.getMicroSecondTime() - begin.getMicroSecondTime(), pixel);
        return new MicroSecondDate(begin.getMicroSecondTime() + Math.round(value));
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, QuantityImpl value) {
        QuantityImpl converted = value.convertTo(range.getUnit());
        return SimplePlotUtil.getPixel(totalPixels, range, converted.getValue());
    }

    public static final int getPixel(int totalPixels, UnitRangeImpl range, double value) {
        return (int)Math.round(SimplePlotUtil.linearInterp(range.getMinValue(), 0.0, range.getMaxValue(), totalPixels, value));
    }

    public static final QuantityImpl getValue(int totalPixels, UnitRangeImpl range, int pixel) {
        double value = SimplePlotUtil.linearInterp(0.0, range.getMinValue(), totalPixels, range.getMaxValue(), pixel);
        return new QuantityImpl(value, (Unit)range.getUnit());
    }

    public static final MicroSecondDate getTimeForIndex(int index, MicroSecondDate beginTime, SamplingImpl sampling) {
        TimeInterval width = sampling.getPeriod();
        width = (TimeInterval)width.multiplyBy((double)index);
        return beginTime.add(width);
    }

    public static LocalSeismogramImpl createTestData() {
        return SimplePlotUtil.createTestData("Fake Data");
    }

    public static LocalSeismogramImpl createTestData(String name) {
        int[] dataBits = new int[100];
        for (int i = 0; i < dataBits.length; ++i) {
            double tmpDouble = Math.random() * 2.0 - 1.0;
            tmpDouble = tmpDouble * tmpDouble * tmpDouble * tmpDouble * tmpDouble;
            dataBits[i] = (int)Math.round(tmpDouble * 2000.0);
        }
        return SimplePlotUtil.createTestData(name, dataBits);
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits) {
        String id = "Nowhere: " + name;
        Time time = new Time("19991231T235959.000Z", -1);
        TimeInterval timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl sampling = new SamplingImpl(20, timeInterval);
        ChannelId channelID = new ChannelId(new NetworkId("XX", time), "FAKE", "00", "BHZ", time);
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.int_values(dataBits);
        Property[] props = new Property[]{new Property("Name", name)};
        TimeInterval[] time_corr = new TimeInterval[]{new TimeInterval(0.123, UnitImpl.SECOND)};
        LocalSeismogramImpl seis = new LocalSeismogramImpl(id, props, time, dataBits.length, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelID, new ParameterRef[0], (Quantity[])time_corr, (Sampling[])new SamplingImpl[0], bits);
        return seis;
    }

    public static ChannelId makeChanId(Time time) {
        return new ChannelId(new NetworkId("XX", time), "FAKE", "00", "BHZ", time);
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits, Time time) {
        return SimplePlotUtil.createTestData(name, dataBits, time, SimplePlotUtil.makeChanId(time));
    }

    public static LocalSeismogramImpl createTestData(String name, int[] dataBits, Time time, ChannelId channelID) {
        String id = "Nowhere: " + name;
        TimeInterval timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
        SamplingImpl sampling = new SamplingImpl(20, timeInterval);
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.int_values(dataBits);
        Property[] props = new Property[]{new Property("Name", name)};
        TimeInterval[] time_corr = new TimeInterval[]{new TimeInterval(0.123, UnitImpl.SECOND)};
        LocalSeismogramImpl seis = new LocalSeismogramImpl(id, props, time, dataBits.length, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelID, new ParameterRef[0], (Quantity[])time_corr, (Sampling[])new SamplingImpl[0], bits);
        return seis;
    }

    public static LocalSeismogramImpl createCustomSineWave() {
        int[] dataBits = new int[1200];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(0.0 + (double)i * Math.PI * 1.0 / 20.0) * 1000.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave", dataBits, new Time("19911015T163000.000Z", -1));
    }

    public static LocalSeismogramImpl createSineWave() {
        return SimplePlotUtil.createSineWave(0.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase) {
        return SimplePlotUtil.createSineWave(phase, 1.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz) {
        return SimplePlotUtil.createSineWave(phase, hertz, 1200);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz, int numPoints) {
        return SimplePlotUtil.createSineWave(phase, hertz, numPoints, 1000.0);
    }

    public static LocalSeismogramImpl createSineWave(double phase, double hertz, int numPoints, double amp) {
        int[] dataBits = new int[numPoints];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * amp);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createHighSineWave(double phase, double hertz) {
        int[] dataBits = new int[120];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * 1000.0 + 500.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createLowSineWave(double phase, double hertz) {
        int[] dataBits = new int[120];
        for (int i = 0; i < dataBits.length; ++i) {
            dataBits[i] = (int)Math.round(Math.sin(phase + (double)i * Math.PI * hertz / 20.0) * 1000.0 - 500.0);
        }
        return SimplePlotUtil.createTestData("Sine Wave, phase " + phase + " hertz " + hertz, dataBits);
    }

    public static LocalSeismogramImpl createDelta() {
        MicroSecondDate now = ClockUtil.now();
        TimeInterval traceLength = new TimeInterval(50.0, UnitImpl.SECOND);
        double traceSecs = traceLength.getValue(UnitImpl.SECOND);
        int[] dataBits = new int[(int)(20.0 * traceSecs)];
        dataBits[0] = 1;
        return SimplePlotUtil.createTestData("kronecker delta at 0", dataBits, now.getFissuresTime(), SimplePlotUtil.makeChanId(now.getFissuresTime()));
    }

    public static LocalSeismogramImpl createSpike() {
        return SimplePlotUtil.createSpike(ClockUtil.now());
    }

    public static LocalSeismogramImpl createSpike(MicroSecondDate spikeTime) {
        return SimplePlotUtil.createSpike(spikeTime, new TimeInterval(50.0, UnitImpl.SECOND), 20, SimplePlotUtil.makeChanId(spikeTime.getFissuresTime()));
    }

    public static LocalSeismogramImpl createSpike(MicroSecondDate time, TimeInterval traceLength, int samplesPerSpike, ChannelId id) {
        return SimplePlotUtil.createRaggedSpike(time, traceLength, samplesPerSpike, 0, id);
    }

    public static LocalSeismogramImpl createRaggedSpike(MicroSecondDate time, TimeInterval traceLength, int samplesPerSpike, int missingSamples, ChannelId id) {
        double secondShift = (double)missingSamples / 20.0;
        TimeInterval shiftInt = new TimeInterval(secondShift, UnitImpl.SECOND);
        time = time.add(shiftInt);
        traceLength = traceLength.subtract(shiftInt);
        String name = "spike at " + time.toString();
        double traceSecs = traceLength.convertTo(UnitImpl.SECOND).getValue();
        int[] dataBits = new int[(int)(20.0 * traceSecs)];
        for (int i = 0; i < dataBits.length; ++i) {
            if ((i + missingSamples) % samplesPerSpike != 0) continue;
            dataBits[i] = 100;
        }
        return SimplePlotUtil.createTestData(name, dataBits, time.getFissuresTime(), id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

