/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.ResponsePrint;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Statistics;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.TextInfoDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TimeZone;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SeismogramInfoDisplay
extends TextInfoDisplay {
    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.S z");
    protected LinkedList format;
    DecimalFormat twoDecimal = new DecimalFormat("0.00");

    public SeismogramInfoDisplay(LinkedList format) {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.format = format;
    }

    public void addSeismogram(DataSetSeismogram dss) {
        HashMap values = new HashMap();
        Document doc = this.getDocument();
        try {
            Object respObj;
            this.appendLine(doc, "");
            this.appendHeader(doc, dss.toString());
            RequestFilter rf = dss.getRequestFilter();
            MicroSecondTimeRange rfRange = new MicroSecondTimeRange(rf);
            this.appendLabelValue(doc, "Channel ID", ChannelIdUtil.toString((ChannelId)rf.channel_id));
            this.appendLabelValue(doc, "Begin Time", "" + rfRange.getBeginTime());
            this.appendLabelValue(doc, "End Time", "" + rfRange.getEndTime());
            Channel chan = dss.getDataSet().getChannel(rf.channel_id);
            if (chan != null) {
                this.appendHeader(doc, "Channel");
                this.appendLabelValue(doc, "Name", chan.name);
                this.appendLabelValue(doc, "Orientation", chan.an_orientation.azimuth + "/" + chan.an_orientation.dip);
                this.appendLabelValue(doc, "Effective Time", chan.effective_time.start_time.date_time + " to " + chan.effective_time.end_time.date_time);
                this.appendLabelValue(doc, "Id", ChannelIdUtil.toString((ChannelId)chan.get_id()));
                this.appendLabelValue(doc, "Sampling", chan.sampling_info.numPoints + " in " + chan.sampling_info.interval);
                this.appendHeader(doc, "Site");
                Site site = chan.my_site;
                this.appendLabelValue(doc, "Id", SiteIdUtil.toString((SiteId)site.get_id()));
                this.appendLabelValue(doc, "Effective Time", site.effective_time.start_time.date_time + " to " + site.effective_time.end_time.date_time);
                this.appendLabelValue(doc, "Comment", site.comment);
                this.appendLabelValue(doc, "Location", site.my_location.latitude + "/" + site.my_location.longitude + " elev=" + site.my_location.elevation + " depth=" + site.my_location.depth);
                this.appendHeader(doc, "Station");
                Station sta = site.my_station;
                this.appendLabelValue(doc, "Id", StationIdUtil.toString((StationId)sta.get_id()));
                this.appendLabelValue(doc, "Effective Time", sta.effective_time.start_time.date_time + " to " + sta.effective_time.end_time.date_time);
                this.appendLabelValue(doc, "Name", sta.name);
                this.appendLabelValue(doc, "Description", sta.description);
                this.appendLabelValue(doc, "Operator", sta.operator);
                this.appendLabelValue(doc, "Comment", sta.comment);
                this.appendLabelValue(doc, "Location", sta.my_location.latitude + "/" + sta.my_location.longitude + " elev=" + sta.my_location.elevation + " depth=" + sta.my_location.depth);
                this.appendHeader(doc, "Network");
                NetworkAttr net = sta.my_network;
                this.appendLabelValue(doc, "Id", NetworkIdUtil.toString((NetworkId)net.get_id()));
                this.appendLabelValue(doc, "Effective Time", net.effective_time.start_time.date_time + " to " + net.effective_time.end_time.date_time);
                this.appendLabelValue(doc, "Name", sta.name);
                this.appendLabelValue(doc, "Description", sta.description);
                this.appendLabelValue(doc, "Owner", sta.operator);
            }
            if ((respObj = dss.getAuxillaryData(StdAuxillaryDataNames.RESPONSE)) != null && respObj instanceof Response) {
                Response resp = (Response)respObj;
                this.appendHeader(doc, "Response");
                this.appendLabelValue(doc, "Sensitivity", resp.the_sensitivity.sensitivity_factor + " at " + resp.the_sensitivity.frequency + " Hz");
                this.appendLabelValue(doc, "Number of Stages", "" + resp.stages.length);
                TimeRange effTime = chan != null ? chan.effective_time : new TimeRange(rf.start_time, rf.end_time);
                this.appendLine(doc, ResponsePrint.printResponse((ChannelId)rf.channel_id, (Response)resp, (TimeRange)effTime));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSeismogram(LocalSeismogramImpl seis) throws FissuresException {
        try {
            Document doc = this.getDocument();
            this.appendLine(doc, "");
            this.appendHeader(doc, seis.toString());
            this.appendLabelValue(doc, "ID", seis.get_id());
            this.appendLabelValue(doc, "Name", seis.getName());
            this.appendLabelValue(doc, "Channel", ChannelIdUtil.toStringNoDates((ChannelId)seis.channel_id));
            this.appendLabelValue(doc, "Num Points", "" + seis.num_points);
            this.appendLabelValue(doc, "Begin Time", "" + seis.getBeginTime());
            this.appendLabelValue(doc, "End Time", "" + seis.getEndTime());
            this.appendLabelValue(doc, "Sampling", "" + seis.sampling_info);
            this.appendLabelValue(doc, "Unit", "" + seis.y_unit);
            Statistics stat = new Statistics(seis);
            this.appendLabelValue(doc, "Min", stat.min() + "");
            this.appendLabelValue(doc, "Max", stat.max() + "");
            this.appendLabelValue(doc, "Mean", stat.mean() + "");
        }
        catch (BadLocationException e) {
            GlobalExceptionHandler.handle("Can't append seismogram info to display", e);
        }
    }

    public void drop(DropTargetDropEvent e) {
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

