/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import org.apache.log4j.Category;

public class ParticleMotionDisplayThread {
    private boolean completion = false;
    private DataSetSeismogram dataSetSeismogram;
    private DataSetSeismogram[] dssArray;
    private TimeConfig tc;
    private boolean advancedOption = false;
    private ParticleMotionDisplay particleMotionDisplay;
    private Color displayColor;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$ParticleMotionDisplayThread == null ? (class$edu$sc$seis$fissuresUtil$display$ParticleMotionDisplayThread = ParticleMotionDisplayThread.class$("edu.sc.seis.fissuresUtil.display.ParticleMotionDisplayThread")) : class$edu$sc$seis$fissuresUtil$display$ParticleMotionDisplayThread).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$ParticleMotionDisplayThread;

    public ParticleMotionDisplayThread(DataSetSeismogram dataSetSeismogram, TimeConfig tc, ParticleMotionDisplay particleMotionDisplay, Color displayColor) {
        this.dataSetSeismogram = dataSetSeismogram;
        this.tc = tc;
        this.particleMotionDisplay = particleMotionDisplay;
        this.displayColor = displayColor;
    }

    public void execute() {
        int counter;
        this.dssArray = DisplayUtils.getComponents(this.dataSetSeismogram);
        if (this.dssArray.length < 2) {
            this.completion = false;
            return;
        }
        ChannelId[] channelGroup = new ChannelId[this.dssArray.length];
        for (counter = 0; counter < this.dssArray.length; ++counter) {
            channelGroup[counter] = this.dssArray[counter].getRequestFilter().channel_id;
        }
        for (counter = 0; counter < this.dssArray.length; ++counter) {
            String counterOrientation = DisplayUtils.getOrientationName(channelGroup[counter].channel_code);
            for (int subcounter = counter + 1; subcounter < this.dssArray.length; ++subcounter) {
                String orientationString;
                DataSetSeismogram hSeis;
                DataSetSeismogram vSeis;
                boolean horizPlane = this.isHorizontalPlane(this.dssArray[counter].getRequestFilter().channel_id, this.dssArray[subcounter].getRequestFilter().channel_id, this.dssArray[counter].getDataSet());
                String subCounterOrientation = DisplayUtils.getOrientationName(channelGroup[subcounter].channel_code);
                if (counterOrientation.equals("Up")) {
                    vSeis = this.dssArray[counter];
                    hSeis = this.dssArray[subcounter];
                    orientationString = counterOrientation + "-" + subCounterOrientation;
                } else if (counterOrientation.equals("East")) {
                    vSeis = this.dssArray[subcounter];
                    hSeis = this.dssArray[counter];
                    orientationString = subCounterOrientation + "-" + counterOrientation;
                } else if (subCounterOrientation.equals("East")) {
                    vSeis = this.dssArray[counter];
                    hSeis = this.dssArray[subcounter];
                    orientationString = counterOrientation + "-" + subCounterOrientation;
                } else {
                    vSeis = this.dssArray[subcounter];
                    hSeis = this.dssArray[counter];
                    orientationString = subCounterOrientation + "-" + counterOrientation;
                }
                this.particleMotionDisplay.getView().add(hSeis, vSeis, this.tc, this.displayColor, orientationString, horizPlane);
            }
        }
        this.completion = true;
    }

    public boolean isHorizontalPlane(ChannelId channelIdone, ChannelId channelIdtwo, DataSet dataset) {
        return dataset.getChannel((ChannelId)channelIdone).an_orientation.dip == 0.0f && dataset.getChannel((ChannelId)channelIdtwo).an_orientation.dip == 0.0f;
    }

    public boolean getCompletion() {
        return this.completion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

