/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import java.util.Date;

public class MicroSecondTimeRange {
    private final MicroSecondDate beginTime;
    private final MicroSecondDate endTime;
    private final TimeInterval interval;

    public MicroSecondTimeRange(LocalSeismogramImpl ls) {
        this(ls.getBeginTime(), ls.getEndTime());
    }

    public MicroSecondTimeRange(RequestFilter rf) {
        this(rf.start_time, rf.end_time);
    }

    public MicroSecondTimeRange(TimeRange timeRange) {
        this(timeRange.start_time, timeRange.end_time);
    }

    public MicroSecondTimeRange(Time time, Time anotherTime) {
        this(new MicroSecondDate(time), new MicroSecondDate(anotherTime));
    }

    public MicroSecondTimeRange(MicroSecondDate time, MicroSecondDate anotherTime) {
        if (time.before((Date)anotherTime)) {
            this.beginTime = time;
            this.endTime = anotherTime;
        } else {
            this.beginTime = anotherTime;
            this.endTime = time;
        }
        this.interval = new TimeInterval(this.beginTime, this.endTime);
    }

    public MicroSecondTimeRange(MicroSecondDate beginTime, TimeInterval interval) {
        this(beginTime, beginTime.add(interval));
    }

    public MicroSecondTimeRange(MicroSecondTimeRange timeRange, MicroSecondTimeRange timeRange2) {
        this(timeRange.getBeginTime().before((Date)timeRange2.getBeginTime()) ? timeRange.getBeginTime() : timeRange2.getBeginTime(), timeRange.getEndTime().after((Date)timeRange2.getEndTime()) ? timeRange.getEndTime() : timeRange2.getEndTime());
    }

    public boolean intersects(MicroSecondDate newTime) {
        return !(!this.beginTime.before((Date)newTime) && !this.beginTime.equals((Object)newTime) || !this.endTime.after((Date)newTime) && !this.endTime.equals((Object)newTime));
    }

    public boolean intersects(MicroSecondTimeRange time) {
        return this.endTime.after((Date)time.getBeginTime()) && this.beginTime.before((Date)time.getEndTime());
    }

    public MicroSecondTimeRange shale(double shift, double scale) {
        if (shift == 0.0 && scale == 1.0) {
            return this;
        }
        TimeInterval timeShift = (TimeInterval)this.interval.multiplyBy(Math.abs(shift));
        MicroSecondDate newBeginTime = shift < 0.0 ? this.beginTime.subtract(timeShift) : this.beginTime.add(timeShift);
        return new MicroSecondTimeRange(newBeginTime, (TimeInterval)this.interval.multiplyBy(scale));
    }

    public MicroSecondTimeRange shift(TimeInterval shift) {
        return new MicroSecondTimeRange(this.beginTime.add(shift), this.endTime.add(shift));
    }

    public MicroSecondTimeRange shift(double percentage) {
        if (percentage == 0.0) {
            return this;
        }
        TimeInterval shift = (TimeInterval)this.interval.multiplyBy(Math.abs(percentage));
        if (percentage < 0.0) {
            return new MicroSecondTimeRange(this.beginTime.subtract(shift), this.endTime.subtract(shift));
        }
        return new MicroSecondTimeRange(this.beginTime.add(shift), this.endTime.add(shift));
    }

    public MicroSecondDate getBeginTime() {
        return this.beginTime;
    }

    public MicroSecondDate getEndTime() {
        return this.endTime;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    public TimeRange getFissuresTimeRange() {
        return new TimeRange(this.getBeginTime().getFissuresTime(), this.getEndTime().getFissuresTime());
    }

    public UnitRangeImpl getMillis() {
        return new UnitRangeImpl((double)this.beginTime.getTime(), (double)this.endTime.getTime(), (Unit)UnitImpl.MILLISECOND);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        MicroSecondTimeRange mstrTime = (MicroSecondTimeRange)other;
        return this.beginTime.equals((Object)mstrTime.getBeginTime()) && this.endTime.equals((Object)mstrTime.getEndTime());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.beginTime.hashCode();
        result = 37 * result + this.endTime.hashCode();
        return result;
    }

    public String toString() {
        return this.beginTime + " to " + this.endTime;
    }
}

