/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventLoadedListener;
import edu.sc.seis.fissuresUtil.cache.EventLoader;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Category;

public class EventTableModel
extends AbstractTableModel
implements EventLoadedListener {
    protected static ParseRegions FERegions = ParseRegions.getInstance();
    protected EventAccessOperations[] events = new EventAccessOperations[0];
    protected WeakHashMap cachedEvents = new WeakHashMap();
    protected WeakHashMap backgrounded = new WeakHashMap();
    protected HashMap rowNumber = new HashMap();
    protected NumberFormat depthFormat = new DecimalFormat("0.0");
    protected static final int LATITUDE = 4;
    protected static final int LONGITUDE = 5;
    protected static final int DEPTH = 3;
    protected static final int ORIGINTIME = 2;
    protected static final int MAGVALUE = 1;
    protected static final int CATALOG = 6;
    protected static final int CONTRIBUTOR = 7;
    protected static final int NAME = 8;
    protected static final int FEREGION = 0;
    protected static final int LATITUDESIZE = 50;
    protected static final int LONGITUDESIZE = 50;
    protected static final int DEPTHSIZE = 50;
    protected static final int ORIGINTIMESIZE = 150;
    protected static final int MAGVALUESIZE = 100;
    protected static final int CATALOGSIZE = 100;
    protected static final int CONTRIBUTORSIZE = 100;
    protected static final int NAMESIZE = 8;
    protected static final int FEREGIONSIZE = 150;
    protected String[] columnNames;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$EventTableModel == null ? (class$edu$sc$seis$fissuresUtil$display$EventTableModel = EventTableModel.class$("edu.sc.seis.fissuresUtil.display.EventTableModel")) : class$edu$sc$seis$fissuresUtil$display$EventTableModel).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$CacheEvent;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$EventDataListener;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$EventTableModel;

    public EventTableModel() {
        this(new ProxyEventAccessOperations[0]);
    }

    public EventTableModel(ProxyEventAccessOperations[] events) {
        this.updateEvents(events);
        this.columnNames = new String[9];
        this.columnNames[4] = "Latitude";
        this.columnNames[5] = "Longitude";
        this.columnNames[3] = "Depth";
        this.columnNames[2] = "Origin Time";
        this.columnNames[1] = "Magnitude";
        this.columnNames[6] = "Catalog";
        this.columnNames[7] = "Contributor";
        this.columnNames[0] = "Region";
    }

    public int getColumnCount() {
        return 8;
    }

    public int getRowCount() {
        return this.getAllEvents().length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public Object getValueAt(int row, int col) {
        if (!this.isRowCached(row)) {
            return "...";
        }
        EventAccessOperations cache = this.getEventForRow(row);
        try {
            switch (col) {
                case 8: {
                    if (cache.get_attributes() == null) {
                        return "";
                    }
                    return cache.get_attributes().name;
                }
                case 0: {
                    if (cache.get_attributes() == null || cache.get_attributes().region == null) {
                        return "";
                    }
                    return FERegions.getGeographicRegionName(cache.get_attributes().region.number);
                }
                case 6: {
                    return cache.get_preferred_origin().catalog;
                }
                case 7: {
                    return cache.get_preferred_origin().contributor;
                }
                case 4: {
                    return new Float(cache.get_preferred_origin().my_location.latitude);
                }
                case 5: {
                    return new Float(cache.get_preferred_origin().my_location.longitude);
                }
                case 3: {
                    QuantityImpl q = (QuantityImpl)cache.get_preferred_origin().my_location.depth;
                    q = q.convertTo(UnitImpl.KILOMETER);
                    return this.depthFormat.format(q.getValue()) + " km";
                }
                case 2: {
                    Time fisDate = cache.get_preferred_origin().origin_time;
                    MicroSecondDate msd = new MicroSecondDate(fisDate);
                    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return sdf.format((Date)msd);
                }
                case 1: {
                    if (cache.get_preferred_origin().magnitudes.length == 0) {
                        return "none";
                    }
                    String type = cache.get_preferred_origin().magnitudes[0].type;
                    if (type.equals("edu.iris.Fissures/MagType/mb")) {
                        type = "mb";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/ML")) {
                        type = "ml";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/mbmle")) {
                        type = "mbmle";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/MO")) {
                        type = "MO";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/Ms")) {
                        type = "Ms";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/msmle")) {
                        type = "msmle";
                    }
                    if (type.equals("edu.iris.Fissures/MagType/MW")) {
                        type = "MW";
                    }
                    return new Float(cache.get_preferred_origin().magnitudes[0].value).toString() + " " + type;
                }
            }
            return "XXXX";
        }
        catch (NoPreferredOrigin e) {
            return "No Pref Origin";
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle("Got exception in Table model: getValueAt(" + row + ", " + col + ")", e);
            return "error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventAccessOperations getEventForRow(int row) {
        EventAccessOperations[] eventAccessOperationsArray = this.events;
        synchronized (this.events) {
            if (this.isRowCached(row)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (EventAccessOperations)this.cachedEvents.get(this.events[row]);
            }
            ProxyEventAccessOperations cache = (ProxyEventAccessOperations)this.backgrounded.get(this.events[row]);
            if (cache == null) {
                cache = (ProxyEventAccessOperations)this.cachedEvents.get(this.events[row]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowCached(int row) {
        EventAccessOperations[] eventAccessOperationsArray = this.events;
        synchronized (this.events) {
            if (this.backgrounded.containsKey(this.events[row])) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (!this.cachedEvents.containsKey(this.events[row])) {
                ProxyEventAccessOperations cache = BulletproofVestFactory.vestEventAccess(this.events[row]);
                this.backgrounded.put(this.events[row], cache);
                this.rowNumber.put(this.events[row], new Integer(row));
                EventLoader backLoader = new EventLoader((CacheEvent)cache.getWrappedEventAccess(class$edu$sc$seis$fissuresUtil$cache$CacheEvent == null ? (class$edu$sc$seis$fissuresUtil$cache$CacheEvent = EventTableModel.class$("edu.sc.seis.fissuresUtil.cache.CacheEvent")) : class$edu$sc$seis$fissuresUtil$cache$CacheEvent), this);
                WorkerThreadPool.getDefaultPool().invokeLater(backLoader);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEvents(EventAccessOperations[] events) {
        EventAccessOperations[] eventAccessOperationsArray = events;
        synchronized (events) {
            this.events = events;
            this.cachedEvents.clear();
            this.rowNumber.clear();
            for (int i = 0; i < events.length; ++i) {
                events[i] = BulletproofVestFactory.vestEventAccess(events[i]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireEventDataCleared();
            this.fireTableDataChanged();
            this.fireEventDataChanged(events);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendEvents(EventAccessOperations[] appendEvents) {
        EventAccessOperations[] eventAccessOperationsArray = this.events;
        synchronized (this.events) {
            for (int i = 0; i < appendEvents.length; ++i) {
                appendEvents[i] = BulletproofVestFactory.vestEventAccess(appendEvents[i]);
            }
            ProxyEventAccessOperations[] tmp = new ProxyEventAccessOperations[this.events.length + appendEvents.length];
            System.arraycopy(this.events, 0, tmp, 0, this.events.length);
            System.arraycopy(appendEvents, 0, tmp, this.events.length, appendEvents.length);
            this.events = tmp;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireTableDataChanged();
            this.fireEventDataAppended(this.events);
            return;
        }
    }

    public void eventLoaded(ProxyEventAccessOperations cache) {
        this.cachedEvents.put(cache, cache);
        this.backgrounded.remove(cache);
        Integer rowNum = (Integer)this.rowNumber.get(cache);
        if (rowNum != null) {
            this.fireTableRowsUpdated(rowNum, rowNum);
        }
    }

    public void addEventDataListener(EventDataListener edl) {
        this.listenerList.add(class$edu$sc$seis$fissuresUtil$display$EventDataListener == null ? (class$edu$sc$seis$fissuresUtil$display$EventDataListener = EventTableModel.class$("edu.sc.seis.fissuresUtil.display.EventDataListener")) : class$edu$sc$seis$fissuresUtil$display$EventDataListener, edl);
    }

    private void fireEventDataChanged(EventAccessOperations[] events) {
        EQDataEvent eqDataEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$display$EventDataListener == null ? EventTableModel.class$("edu.sc.seis.fissuresUtil.display.EventDataListener") : class$edu$sc$seis$fissuresUtil$display$EventDataListener)) continue;
            if (eqDataEvent == null) {
                eqDataEvent = new EQDataEvent(events);
            }
            ((EventDataListener)listeners[i + 1]).eventDataChanged(eqDataEvent);
        }
    }

    private void fireEventDataAppended(EventAccessOperations[] events) {
        EQDataEvent eqDataEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$display$EventDataListener == null ? EventTableModel.class$("edu.sc.seis.fissuresUtil.display.EventDataListener") : class$edu$sc$seis$fissuresUtil$display$EventDataListener)) continue;
            if (eqDataEvent == null) {
                eqDataEvent = new EQDataEvent(events);
            }
            ((EventDataListener)listeners[i + 1]).eventDataAppended(eqDataEvent);
        }
    }

    private void fireEventDataCleared() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$display$EventDataListener == null ? EventTableModel.class$("edu.sc.seis.fissuresUtil.display.EventDataListener") : class$edu$sc$seis$fissuresUtil$display$EventDataListener)) continue;
            ((EventDataListener)listeners[i + 1]).eventDataCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventAccessOperations[] getAllEvents() {
        EventAccessOperations[] eventAccessOperationsArray = this.events;
        synchronized (this.events) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowForEvent(EventAccessOperations event) {
        EventAccessOperations[] eventAccessOperationsArray = this.events;
        synchronized (this.events) {
            EventAccessOperations[] copyEvents = this.getAllEvents();
            for (int i = 0; i < copyEvents.length; ++i) {
                if (!event.equals(copyEvents[i])) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

