/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.plottable;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class PlottableChunk {
    private static final int MILLIS_IN_DAY = 86400000;
    public static final TimeInterval ONE_DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private ChannelId channel;
    private Plottable data;
    private int pixelsPerDay;
    private int beginPixel;
    private int jday;
    private int year;

    public PlottableChunk(Plottable data, int startPixel, PlottableChunk otherStuff) {
        this(data, startPixel, otherStuff.getJDay(), otherStuff.getYear(), otherStuff.getPixelsPerDay(), otherStuff.getChannel());
    }

    public PlottableChunk(Plottable data, int startPixel, MicroSecondDate startDate, int pixelsPerDay, ChannelId channel) {
        this(data, startPixel, PlottableChunk.getJDay(startDate), PlottableChunk.getYear(startDate), pixelsPerDay, channel);
    }

    public PlottableChunk(Plottable data, int startPixel, int jday, int year, int pixelsPerDay, ChannelId channel) {
        this.data = data;
        this.beginPixel = startPixel;
        this.pixelsPerDay = pixelsPerDay;
        this.jday = jday;
        this.year = year;
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlottableChunk) {
            PlottableChunk oChunk = (PlottableChunk)o;
            if (ChannelIdUtil.areEqual((ChannelId)this.channel, (ChannelId)oChunk.channel) && this.pixelsPerDay == oChunk.pixelsPerDay && this.jday == oChunk.jday && this.year == oChunk.year && this.data.x_coor.length == oChunk.data.x_coor.length) {
                for (int i = 0; i < this.data.x_coor.length; ++i) {
                    if (this.data.x_coor[i] == oChunk.data.x_coor[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static Calendar makeCal() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    }

    public static MicroSecondDate getTime(int pixel, int jday, int year, int pixelsPerDay) {
        Calendar cal = PlottableChunk.makeCal();
        cal.set(6, jday);
        cal.set(1, year);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        double sampleMillis = SimplePlotUtil.linearInterp(0.0, 0.0, pixelsPerDay, 8.64E7, pixel);
        sampleMillis = Math.floor(sampleMillis);
        return new MicroSecondDate((cal.getTimeInMillis() + (long)sampleMillis) * 1000L);
    }

    public static int getJDay(MicroSecondDate time) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime((Date)time);
        return cal.get(6);
    }

    public static int getYear(MicroSecondDate time) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime((Date)time);
        return cal.get(1);
    }

    public static int getPixel(MicroSecondDate time, int pixelsPerDay) {
        MicroSecondDate day = new MicroSecondDate(PlottableChunk.stripToDay((Date)time));
        MicroSecondTimeRange tr = new MicroSecondTimeRange(day, ONE_DAY);
        double pixel = SimplePlotUtil.getPixel(pixelsPerDay, tr, time);
        return (int)Math.floor(pixel);
    }

    public static MicroSecondDate stripToDay(Date d) {
        Calendar cal = PlottableChunk.makeCal();
        cal.setTime(d);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new MicroSecondDate(cal.getTime());
    }

    public ChannelId getChannel() {
        return this.channel;
    }

    public Plottable getData() {
        return this.data;
    }

    public int getPixelsPerDay() {
        return this.pixelsPerDay;
    }

    public int getBeginPixel() {
        return this.beginPixel;
    }

    public int getNumPixels() {
        return this.data.y_coor.length / 2;
    }

    public MicroSecondDate getTime(int pixel) {
        return PlottableChunk.getTime(pixel, this.getJDay(), this.getYear(), this.getPixelsPerDay());
    }

    public MicroSecondDate getBeginTime() {
        return this.getTime(this.beginPixel);
    }

    public MicroSecondDate getEndTime() {
        return this.getTime(this.getBeginPixel() + this.getNumPixels());
    }

    public MicroSecondTimeRange getTimeRange() {
        return new MicroSecondTimeRange(this.getBeginTime(), this.getEndTime());
    }

    public int getJDay() {
        return this.jday;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        int hashCode = 81 + ChannelIdUtil.hashCode((ChannelId)this.getChannel());
        hashCode = 37 * hashCode + this.pixelsPerDay;
        hashCode = 37 * hashCode + this.jday;
        hashCode = 37 * hashCode + this.year;
        return 37 * hashCode + this.data.y_coor.length;
    }

    public String toString() {
        return this.getNumPixels() + " pixel chunk from " + ChannelIdUtil.toStringNoDates((ChannelId)this.channel) + " at " + this.pixelsPerDay + " ppd from " + this.getTimeRange();
    }

    public PlottableChunk[] breakIntoDays() {
        int numDays = (int)Math.ceil((double)this.getNumPixels() / (double)this.getPixelsPerDay());
        if (this.getNumPixels() % this.getPixelsPerDay() == 0 && this.beginPixel != 0) {
            ++numDays;
        }
        ArrayList<PlottableChunk> dayChunks = new ArrayList<PlottableChunk>();
        MicroSecondDate time = this.getBeginTime();
        for (int i = 0; i < numDays; ++i) {
            int firstDayPixels = this.pixelsPerDay - this.getBeginPixel();
            int startPixel = (i - 1) * this.pixelsPerDay + firstDayPixels;
            int stopPixel = i * this.pixelsPerDay + firstDayPixels;
            int pixelIntoNewDay = 0;
            if (i == 0) {
                startPixel = 0;
                stopPixel = firstDayPixels;
                pixelIntoNewDay = this.getBeginPixel();
            }
            if (i == numDays - 1) {
                stopPixel = this.getNumPixels();
            }
            int[] y = new int[(stopPixel - startPixel) * 2];
            System.arraycopy(this.data.y_coor, startPixel * 2, y, 0, y.length);
            Plottable p = new Plottable(null, y);
            dayChunks.add(new PlottableChunk(p, pixelIntoNewDay, PlottableChunk.getJDay(time), PlottableChunk.getYear(time), this.getPixelsPerDay(), this.getChannel()));
            time = time.add(ONE_DAY);
        }
        return dayChunks.toArray(new PlottableChunk[0]);
    }
}

