/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.plottable;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCChannel;
import edu.sc.seis.fissuresUtil.database.plottable.PlottableChunk;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class JDBCPlottable
extends JDBCTable {
    private PreparedStatement put;
    private PreparedStatement get;
    private PreparedStatement drop;
    private JDBCChannel chanTable;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$plottable$JDBCPlottable == null ? (class$edu$sc$seis$fissuresUtil$database$plottable$JDBCPlottable = JDBCPlottable.class$("edu.sc.seis.fissuresUtil.database.plottable.JDBCPlottable")) : class$edu$sc$seis$fissuresUtil$database$plottable$JDBCPlottable));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$plottable$JDBCPlottable;

    public JDBCPlottable(Connection conn, String dbType) throws SQLException {
        super("plottable", conn);
        this.chanTable = new JDBCChannel(conn);
        VelocityContext ctx = new VelocityContext();
        ctx.put(dbType, (Object)"true");
        TableSetup.setup(this.getTableName(), conn, (Object)this, "edu/sc/seis/fissuresUtil/database/props/plottable/default.props", (Context)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PlottableChunk[] chunks) throws SQLException, IOException {
        int i;
        MicroSecondTimeRange stuffInDB = RangeTool.getFullTime(chunks);
        logger.debug((Object)("stuffInDB timeRange: " + stuffInDB));
        MicroSecondDate startTime = PlottableChunk.stripToDay((Date)stuffInDB.getBeginTime());
        logger.debug((Object)("start time of chunks: " + startTime));
        MicroSecondDate strippedEnd = PlottableChunk.stripToDay((Date)stuffInDB.getEndTime());
        logger.debug((Object)("end time of chunks: " + strippedEnd));
        if (!strippedEnd.equals((Object)stuffInDB.getEndTime())) {
            logger.debug((Object)"!strippedEnd.equals(stuffInDB.getEndTime())");
            strippedEnd = strippedEnd.add(PlottableChunk.ONE_DAY);
            logger.debug((Object)("strippedEnd now: " + strippedEnd));
        }
        stuffInDB = new MicroSecondTimeRange(startTime, strippedEnd);
        PlottableChunk[] dbChunks = this.get(stuffInDB, chunks[0].getChannel(), chunks[0].getPixelsPerDay());
        logger.debug((Object)("got " + dbChunks.length + " chunks from stuff that was already in the database"));
        PlottableChunk[] everything = new PlottableChunk[chunks.length + dbChunks.length];
        System.arraycopy(dbChunks, 0, everything, 0, dbChunks.length);
        System.arraycopy(chunks, 0, everything, dbChunks.length, chunks.length);
        logger.debug((Object)("Merging " + everything.length + " chunks"));
        for (i = 0; i < everything.length; ++i) {
            logger.debug((Object)everything[i]);
        }
        everything = ReduceTool.merge(everything);
        logger.debug((Object)("Breaking " + everything.length + " remaining chunks after merge into seperate chunks based on day"));
        for (i = 0; i < everything.length; ++i) {
            logger.debug((Object)everything[i]);
        }
        everything = this.breakIntoDays(everything);
        logger.debug((Object)("Adding " + everything.length + " chunks split on days"));
        for (i = 0; i < everything.length; ++i) {
            logger.debug((Object)everything[i]);
        }
        int rowsDropped = this.drop(stuffInDB, chunks[0].getChannel(), chunks[0].getPixelsPerDay());
        logger.debug((Object)("Dropped " + rowsDropped + " rows of stuff that new data covered"));
        for (int i2 = 0; i2 < everything.length; ++i2) {
            logger.debug((Object)("Adding chunk " + i2 + ": " + everything[i2]));
            int stmtIndex = 1;
            PlottableChunk chunk = everything[i2];
            PreparedStatement preparedStatement = this.put;
            synchronized (preparedStatement) {
                this.put.setInt(stmtIndex++, this.chanTable.put(chunk.getChannel()));
                this.put.setInt(stmtIndex++, chunk.getPixelsPerDay());
                this.put.setTimestamp(stmtIndex++, chunk.getBeginTime().getTimestamp());
                this.put.setTimestamp(stmtIndex++, chunk.getEndTime().getTimestamp());
                int[] y = chunk.getData().y_coor;
                this.put.setInt(stmtIndex++, y.length / 2);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(out);
                for (int k = 0; k < y.length; ++k) {
                    dos.writeInt(y[k]);
                }
                this.put.setBytes(stmtIndex++, out.toByteArray());
                this.put.executeUpdate();
                continue;
            }
        }
    }

    private PlottableChunk[] breakIntoDays(PlottableChunk[] everything) {
        ArrayList<PlottableChunk> results = new ArrayList<PlottableChunk>();
        for (int i = 0; i < everything.length; ++i) {
            PlottableChunk[] days = everything[i].breakIntoDays();
            for (int j = 0; j < days.length; ++j) {
                results.add(days[j]);
            }
        }
        return results.toArray(new PlottableChunk[0]);
    }

    private static int getPixels(int pixelsPerDay, MicroSecondTimeRange tr) {
        TimeInterval inter = tr.getInterval();
        inter = (TimeInterval)inter.convertTo(UnitImpl.DAY);
        double samples = (double)pixelsPerDay * inter.getValue();
        return (int)Math.floor(samples);
    }

    public static int[] fill(MicroSecondTimeRange fullRange, int[] y, PlottableChunk chunk) {
        MicroSecondDate rowBeginTime = chunk.getBeginTime();
        int offsetIntoRequestSamples = SimplePlotUtil.getPixel(y.length, fullRange, rowBeginTime);
        int[] dataY = chunk.getData().y_coor;
        int numSamples = dataY.length;
        int firstSampleForRequest = 0;
        if (offsetIntoRequestSamples < 0) {
            firstSampleForRequest = -1 * offsetIntoRequestSamples;
        }
        int lastSampleForRequest = numSamples;
        if (offsetIntoRequestSamples + numSamples > y.length) {
            lastSampleForRequest = y.length - offsetIntoRequestSamples;
        }
        for (int i = firstSampleForRequest; i < lastSampleForRequest; ++i) {
            y[i + offsetIntoRequestSamples] = dataY[i];
        }
        return y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drop(MicroSecondTimeRange requestRange, ChannelId id, int samplesPerDay) throws SQLException {
        int chanDbId;
        try {
            chanDbId = this.chanTable.getDBId(id);
        }
        catch (NotFound e) {
            logger.info((Object)("Channel " + ChannelIdUtil.toStringNoDates((ChannelId)id) + " not found"));
            return 0;
        }
        PreparedStatement preparedStatement = this.drop;
        synchronized (preparedStatement) {
            this.drop.setTimestamp(1, requestRange.getEndTime().getTimestamp());
            this.drop.setTimestamp(2, requestRange.getBeginTime().getTimestamp());
            this.drop.setInt(3, chanDbId);
            this.drop.setDouble(4, samplesPerDay);
            return this.drop.executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlottableChunk[] get(MicroSecondTimeRange requestRange, ChannelId id, int pixelsPerDay) throws SQLException, IOException {
        ResultSet rs;
        int chanDbId;
        try {
            chanDbId = this.chanTable.getDBId(id);
        }
        catch (NotFound e) {
            logger.info((Object)("Channel " + ChannelIdUtil.toStringNoDates((ChannelId)id) + " not found"));
            return new PlottableChunk[0];
        }
        int index = 1;
        PreparedStatement preparedStatement = this.get;
        synchronized (preparedStatement) {
            this.get.setTimestamp(index++, requestRange.getEndTime().getTimestamp());
            this.get.setTimestamp(index++, requestRange.getBeginTime().getTimestamp());
            this.get.setInt(index++, chanDbId);
            this.get.setInt(index++, pixelsPerDay);
            rs = this.get.executeQuery();
        }
        ArrayList<PlottableChunk> chunks = new ArrayList<PlottableChunk>();
        int requestPixels = JDBCPlottable.getPixels(pixelsPerDay, requestRange);
        logger.debug((Object)("Request made for " + requestPixels + " from " + requestRange + " at " + pixelsPerDay + "ppd"));
        while (rs.next()) {
            int i;
            Timestamp ts = rs.getTimestamp("start_time");
            MicroSecondDate rowBeginTime = new MicroSecondDate(ts);
            logger.debug((Object)("rowBeginTime: " + rowBeginTime));
            int offsetIntoRequestPixels = SimplePlotUtil.getPixel(requestPixels, requestRange, rowBeginTime);
            logger.debug((Object)("offetIntoRequestPixels: " + offsetIntoRequestPixels));
            int numPixels = rs.getInt("pixel_count");
            logger.debug((Object)("numPixels: " + numPixels));
            int firstPixelForRequest = 0;
            if (offsetIntoRequestPixels < 0) {
                firstPixelForRequest = -1 * offsetIntoRequestPixels;
            }
            logger.debug((Object)("firstPixelForRequest: " + firstPixelForRequest));
            int lastPixelForRequest = numPixels;
            if (offsetIntoRequestPixels + numPixels > requestPixels) {
                lastPixelForRequest = requestPixels - offsetIntoRequestPixels;
            }
            logger.debug((Object)("lastPixleForRequest: " + lastPixelForRequest));
            int pixelsUsed = lastPixelForRequest - firstPixelForRequest;
            logger.debug((Object)("pixelsUsed: " + pixelsUsed));
            int[] x = new int[pixelsUsed * 2];
            int[] y = new int[pixelsUsed * 2];
            byte[] dataBytes = rs.getBytes("data");
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(dataBytes));
            for (i = 0; i < firstPixelForRequest; ++i) {
                dis.readInt();
                dis.readInt();
            }
            for (i = 0; i < pixelsUsed * 2; ++i) {
                x[i] = firstPixelForRequest + offsetIntoRequestPixels + i / 2;
                y[i] = dis.readInt();
            }
            if (x.length > 0) {
                logger.debug((Object)("x[0]: " + x[0]));
            } else {
                logger.debug((Object)"ZERO LENGTH ARRAY!!!");
            }
            Plottable p = new Plottable(x, y);
            PlottableChunk pc = new PlottableChunk(p, PlottableChunk.getPixel(rowBeginTime, pixelsPerDay) + firstPixelForRequest, PlottableChunk.getJDay(rowBeginTime), PlottableChunk.getYear(rowBeginTime), pixelsPerDay, id);
            chunks.add(pc);
            logger.debug((Object)("Returning " + pc + " from chunk starting at " + rowBeginTime));
        }
        return chunks.toArray(new PlottableChunk[chunks.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

