/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.network;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.NetworkTable;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JDBCNetwork
extends NetworkTable {
    private JDBCSequence seq;
    private JDBCTime time;
    protected PreparedStatement putAll;
    protected PreparedStatement putId;
    protected PreparedStatement getAll;
    protected PreparedStatement getIfNameExists;
    protected PreparedStatement getByDBId;
    protected PreparedStatement getDBId;
    protected PreparedStatement updateAttr;
    protected PreparedStatement getNetIdByDBId;
    protected PreparedStatement getByCode;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$network$JDBCNetwork == null ? (class$edu$sc$seis$fissuresUtil$database$network$JDBCNetwork = JDBCNetwork.class$("edu.sc.seis.fissuresUtil.database.network.JDBCNetwork")) : class$edu$sc$seis$fissuresUtil$database$network$JDBCNetwork));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$network$JDBCNetwork;

    public JDBCNetwork() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCNetwork(Connection conn) throws SQLException {
        this(conn, new JDBCTime(conn));
    }

    public JDBCNetwork(Connection conn, JDBCTime time) throws SQLException {
        super("network", conn);
        this.time = time;
        this.seq = new JDBCSequence(conn, "NetworkSeq");
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/network/default.props");
        this.putAll = conn.prepareStatement("INSERT INTO network (net_id, net_code, net_begin_id, net_end_id,net_name, net_owner, net_description) VALUES (?, ?, ?, ?, ?, ?, ?)");
        this.putId = conn.prepareStatement("INSERT INTO network(net_id, net_code, net_begin_id) VALUES (?, ?, ?)");
        this.updateAttr = conn.prepareStatement("UPDATE network SET net_end_id = ?, net_name = ?, net_owner = ?, net_description = ? WHERE net_id = ?");
        this.getAll = conn.prepareStatement("SELECT * FROM network ORDER BY net_code");
        this.getByDBId = conn.prepareStatement("SELECT * FROM network WHERE net_id = ?");
        this.getDBId = conn.prepareStatement("SELECT net_id FROM network WHERE net_code = ? AND net_begin_id = ?");
        this.getIfNameExists = conn.prepareStatement("SELECT net_id FROM network WHERE net_id = ? AND net_name IS NOT NULL");
        this.getNetIdByDBId = conn.prepareStatement("SELECT net_id, net_code, net_begin_id FROM network WHERE net_id = ?");
    }

    public int[] getAllNetworkDBIds() throws SQLException {
        ResultSet rs = this.getAll.executeQuery();
        ArrayList<Integer> aList = new ArrayList<Integer>();
        while (rs.next()) {
            aList.add(new Integer(rs.getInt("net_id")));
        }
        int[] out = new int[aList.size()];
        int i = 0;
        Iterator it = aList.iterator();
        while (it.hasNext()) {
            out[i] = (Integer)it.next();
            ++i;
        }
        return out;
    }

    public NetworkId[] getAllNetworkIds() throws SQLException, NotFound {
        ResultSet rs = this.getAll.executeQuery();
        ArrayList<NetworkId> aList = new ArrayList<NetworkId>();
        while (rs.next()) {
            aList.add(JDBCNetwork.extractId(rs, this.time));
        }
        return aList.toArray(new NetworkId[aList.size()]);
    }

    public NetworkAttr[] getAllNetworkAttrs() throws SQLException, NotFound {
        ResultSet rs = this.getAll.executeQuery();
        ArrayList<NetworkAttr> aList = new ArrayList<NetworkAttr>();
        while (rs.next()) {
            aList.add(JDBCNetwork.extract(rs, this.time));
        }
        return aList.toArray(new NetworkAttr[aList.size()]);
    }

    public int put(NetworkAttr network) throws SQLException {
        int dbid;
        try {
            dbid = this.getDbId(network.get_id());
            this.getIfNameExists.setInt(1, dbid);
            ResultSet rs = this.getIfNameExists.executeQuery();
            if (!rs.next()) {
                int index = JDBCNetwork.insertOnlyAttr(network, this.updateAttr, 1, this.time);
                this.updateAttr.setInt(index, dbid);
                this.updateAttr.executeUpdate();
            }
        }
        catch (NotFound notFound) {
            dbid = this.seq.next();
            this.putAll.setInt(1, dbid);
            JDBCNetwork.insertAll(network, this.putAll, 2, this.time);
            this.putAll.executeUpdate();
        }
        return dbid;
    }

    public int put(NetworkId id) throws SQLException {
        int dbid;
        try {
            dbid = this.getDbId(id);
        }
        catch (NotFound e) {
            dbid = this.seq.next();
            this.putId.setInt(1, dbid);
            JDBCNetwork.insertId(id, this.putId, 2, this.time);
            this.putId.executeUpdate();
        }
        return dbid;
    }

    public NetworkAttr get(int dbid) throws SQLException, NotFound {
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        if (rs.next()) {
            return JDBCNetwork.extract(rs, this.time);
        }
        throw new NotFound("No Network found for database id = " + dbid);
    }

    public NetworkId getNetworkId(int dbid) throws SQLException, NotFound {
        this.getNetIdByDBId.setInt(1, dbid);
        ResultSet rs = this.getNetIdByDBId.executeQuery();
        if (rs.next()) {
            return JDBCNetwork.extractId(rs, this.time);
        }
        throw new NotFound("No Network found for database id = " + dbid);
    }

    public NetworkAttr get(NetworkId id) throws SQLException, NotFound {
        return this.get(this.getDbId(id));
    }

    public NetworkId[] getByCode(String netCode) throws SQLException, NotFound {
        this.getByCode.setString(1, netCode);
        ResultSet rs = this.getByCode.executeQuery();
        ArrayList<NetworkId> aList = new ArrayList<NetworkId>();
        while (rs.next()) {
            aList.add(JDBCNetwork.extractId(rs, this.time));
        }
        return aList.toArray(new NetworkId[aList.size()]);
    }

    public int getDbId(NetworkId id) throws SQLException, NotFound {
        JDBCNetwork.insertId(id, this.getDBId, 1, this.time);
        ResultSet rs = this.getDBId.executeQuery();
        if (rs.next()) {
            return rs.getInt("net_id");
        }
        throw new NotFound("No such network id in the db");
    }

    public static NetworkAttr extract(ResultSet rs, JDBCTime time) throws SQLException, NotFound {
        NetworkId networkId = JDBCNetwork.extractId(rs, time);
        return new NetworkAttrImpl(networkId, rs.getString("net_name"), rs.getString("net_description"), rs.getString("net_owner"), new TimeRange(networkId.begin_time, time.get(rs.getInt("net_end_id"))));
    }

    public static NetworkId extractId(ResultSet rs, JDBCTime time) throws SQLException, NotFound {
        return new NetworkId(rs.getString("net_code"), time.get(rs.getInt("net_begin_id")));
    }

    public static int insertAll(NetworkAttr net, PreparedStatement stmt, int index, JDBCTime time) throws SQLException {
        index = JDBCNetwork.insertId(net.get_id(), stmt, index, time);
        index = JDBCNetwork.insertOnlyAttr(net, stmt, index, time);
        return index;
    }

    public static int insertOnlyAttr(NetworkAttr net, PreparedStatement stmt, int index, JDBCTime time) throws SQLException {
        stmt.setInt(index++, time.put(net.effective_time.end_time));
        stmt.setString(index++, net.name);
        stmt.setString(index++, net.owner);
        stmt.setString(index++, net.description);
        return index;
    }

    public static int insertId(NetworkId id, PreparedStatement stmt, int index, JDBCTime time) throws SQLException {
        stmt.setString(index++, id.network_code);
        stmt.setInt(index++, time.put(id.begin_time));
        return index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

