/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.FlinnEngdahlRegion;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCEventAttr;
import edu.sc.seis.fissuresUtil.database.event.JDBCOrigin;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JDBCEventAccess
extends EventTable {
    private JDBCOrigin jdbcOrigin;
    private JDBCEventAttr jdbcAttr;
    private JDBCSequence seq;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$event$JDBCEventAccess == null ? (class$edu$sc$seis$fissuresUtil$database$event$JDBCEventAccess = JDBCEventAccess.class$("edu.sc.seis.fissuresUtil.database.event.JDBCEventAccess")) : class$edu$sc$seis$fissuresUtil$database$event$JDBCEventAccess));
    private static Map idsToEvents = Collections.synchronizedMap(new HashMap());
    private static Map eventsToIds = Collections.synchronizedMap(new HashMap());
    private PreparedStatement put;
    private PreparedStatement getDBIdStmt;
    private PreparedStatement getCorbaStrings;
    private PreparedStatement getAttrAndOrigin;
    private PreparedStatement getEventIds;
    private PreparedStatement queryStmt;
    private PreparedStatement getByNameStmt;
    private PreparedStatement getLast;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$event$JDBCEventAccess;

    public JDBCEventAccess() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCEventAccess(Connection conn) throws SQLException {
        this(conn, new JDBCOrigin(conn), new JDBCEventAttr(conn));
    }

    public JDBCEventAccess(Connection conn, JDBCOrigin origins, JDBCEventAttr attrs) throws SQLException {
        super("eventaccess", conn);
        this.jdbcOrigin = origins;
        this.jdbcAttr = attrs;
        this.seq = new JDBCSequence(conn, "EventAccessSeq");
        Statement stmt = conn.createStatement();
        if (!DBUtil.tableExists("eventaccess", conn)) {
            stmt.executeUpdate(ConnMgr.getSQL("EventAccess.create"));
        }
        this.put = conn.prepareStatement(" INSERT INTO eventaccess (event_id, IOR, origin_id, eventattr_id, server, dns)VALUES(?,?,?,?,?,?)");
        this.getDBIdStmt = conn.prepareStatement(" SELECT event_id FROM eventaccess  WHERE eventattr_id = ? AND origin_id = ?");
        this.getCorbaStrings = conn.prepareStatement(" SELECT IOR, server, dns FROM eventaccess  WHERE event_id = ?");
        this.getAttrAndOrigin = conn.prepareStatement(" SELECT eventattr_id, origin_id FROM eventaccess  WHERE event_id = ?");
        this.getEventIds = conn.prepareStatement(" SELECT eventattr_id, event_id, origin_id FROM eventaccess");
        this.queryStmt = conn.prepareStatement("SELECT DISTINCT event_id FROM eventaccess, origin, location, magnitude, time WHERE eventaccess.event_id = origin.origin_event_id AND origin_location_id = location.loc_id AND origin.origin_id = magnitude.originid AND origin.origin_time_id = time.time_id AND location.loc_lat >= ? AND location.loc_lat <= ? AND location.loc_lon >= ? AND location.loc_lon <= ? AND magnitude.magnitudevalue >= ? AND magnitude.magnitudevalue <= ? AND time.time_stamp >= ? AND time.time_stamp <= ? ");
        this.getByNameStmt = conn.prepareStatement("SELECT DISTINCT event_id FROM eventaccess, eventattr WHERE eventattr.eventattr_name = ? AND eventaccess.eventattr_id = eventattr.eventattr_id");
        this.getLast = conn.prepareStatement("SELECT TOP 1 event_id from eventaccess ORDER BY event_id DESC");
    }

    public CacheEvent getEvent(int dbid) throws SQLException, NotFound {
        CacheEvent ev = (CacheEvent)idsToEvents.get(new Integer(dbid));
        if (ev != null) {
            ev.setDbId(dbid);
            return ev;
        }
        this.getAttrAndOrigin.setInt(1, dbid);
        ResultSet rs = this.getAttrAndOrigin.executeQuery();
        if (rs.next()) {
            return this.getEvent(rs, dbid);
        }
        throw new NotFound();
    }

    private CacheEvent getEvent(ResultSet rs, int dbid) throws NotFound, SQLException {
        Origin preferredOrigin = this.jdbcOrigin.get(rs.getInt("origin_id"));
        Origin[] allOrigins = this.jdbcOrigin.getOrigins(dbid);
        EventAttr attr = this.jdbcAttr.get(rs.getInt("eventattr_id"));
        CacheEvent ev = new CacheEvent(attr, allOrigins, preferredOrigin);
        idsToEvents.put(new Integer(dbid), ev);
        ev.setDbId(dbid);
        return ev;
    }

    public CacheEvent[] getAllEvents() throws SQLException, SQLException {
        ArrayList<CacheEvent> events = new ArrayList<CacheEvent>();
        ResultSet rs = this.getEventIds.executeQuery();
        while (rs.next()) {
            try {
                int id = rs.getInt("event_id");
                CacheEvent ev = (CacheEvent)idsToEvents.get(new Integer(id));
                if (ev != null) {
                    events.add(ev);
                    continue;
                }
                events.add(this.getEvent(rs, id));
            }
            catch (NotFound e) {
                throw new RuntimeException("This shouldn't happen.  I just got that id", e);
            }
        }
        return events.toArray(new CacheEvent[events.size()]);
    }

    public String getServer(int dbid) throws SQLException {
        return this.getCorbaStrings(dbid)[0];
    }

    public String getDNS(int dbid) throws SQLException {
        return this.getCorbaStrings(dbid)[1];
    }

    public String getIOR(int dbid) throws SQLException {
        return this.getCorbaStrings(dbid)[2];
    }

    public String[] getCorbaStrings(int dbid) throws SQLException {
        String[] serverInfo = new String[3];
        this.getCorbaStrings.setInt(1, dbid);
        ResultSet rs = this.getCorbaStrings.executeQuery();
        rs.next();
        serverInfo[0] = rs.getString("server");
        serverInfo[1] = rs.getString("dns");
        serverInfo[2] = rs.getString("IOR");
        return serverInfo;
    }

    public int put(EventAccessOperations eao, String IOR, String server, String dns) throws SQLException {
        if (!(eao instanceof CacheEvent)) {
            eao = new CacheEvent(eao);
        }
        try {
            return this.getDBId(eao);
        }
        catch (NotFound e) {
            int originId;
            int id = this.seq.next();
            int attrId = this.jdbcAttr.put(eao.get_attributes());
            for (int i = 0; i < eao.get_origins().length; ++i) {
                this.jdbcOrigin.put(eao.get_origins()[i], id);
            }
            try {
                originId = this.jdbcOrigin.getDBId(eao.get_preferred_origin());
            }
            catch (NotFound ex) {
                throw new RuntimeException("The preferred origin wasn't found right after all origins were inserted.  This shouldn't ever happen.  If you're seeing this, I imagine very bad things are happening to the database right now");
            }
            catch (NoPreferredOrigin ee) {
                throw new IllegalArgumentException("Events passed in must have preferred origins");
            }
            this.put.setInt(1, id);
            this.put.setString(2, IOR);
            this.put.setInt(3, originId);
            this.put.setInt(4, attrId);
            this.put.setString(5, server);
            this.put.setString(6, dns);
            this.put.executeUpdate();
            eventsToIds.put(eao, new Integer(id));
            idsToEvents.put(new Integer(id), eao);
            return id;
        }
    }

    public int getDBId(EventAccessOperations eao) throws SQLException, NotFound {
        Integer id;
        if (!(eao instanceof CacheEvent)) {
            eao = new CacheEvent(eao);
        }
        if ((id = (Integer)eventsToIds.get(eao)) != null) {
            return id;
        }
        this.getDBIdStmt.setInt(1, this.jdbcAttr.getDBId(eao.get_attributes()));
        try {
            this.getDBIdStmt.setInt(2, this.jdbcOrigin.getDBId(eao.get_preferred_origin()));
        }
        catch (NoPreferredOrigin e) {
            throw new IllegalArgumentException("The event access passed into getDBId must have a preferred origin");
        }
        ResultSet rs = this.getDBIdStmt.executeQuery();
        if (rs.next()) {
            int dbid = rs.getInt("event_id");
            eventsToIds.put(eao, new Integer(dbid));
            return dbid;
        }
        throw new NotFound("The event wasn't found in the db!");
    }

    public int[] query(Quantity min_depth, Quantity max_depth, float minLat, float maxLat, float minLon, float maxLon, Time start_time, Time end_time, float min_magnitude, float max_magnitude, String[] search_types, String[] catalogs, String[] contributors) throws SQLException {
        int index = 1;
        this.queryStmt.setFloat(index++, minLat);
        this.queryStmt.setFloat(index++, maxLat);
        this.queryStmt.setFloat(index++, minLon);
        this.queryStmt.setFloat(index++, maxLon);
        this.queryStmt.setFloat(index++, min_magnitude);
        this.queryStmt.setFloat(index++, max_magnitude);
        this.queryStmt.setTimestamp(index++, new MicroSecondDate(start_time).getTimestamp());
        this.queryStmt.setTimestamp(index++, new MicroSecondDate(end_time).getTimestamp());
        logger.debug((Object)this.queryStmt);
        ResultSet rs = this.queryStmt.executeQuery();
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (rs.next()) {
            out.add(new Integer(rs.getInt(1)));
        }
        Integer[] bigInt = out.toArray(new Integer[out.size()]);
        int[] littleInt = new int[bigInt.length];
        for (int i = 0; i < bigInt.length; ++i) {
            littleInt[i] = bigInt[i];
        }
        return littleInt;
    }

    public int[] getByName(String name) throws SQLException, NotFound {
        this.getByNameStmt.setString(1, name);
        ResultSet rs = this.getByNameStmt.executeQuery();
        ArrayList<Integer> out = new ArrayList<Integer>();
        while (rs.next()) {
            out.add(new Integer(rs.getInt(1)));
        }
        Integer[] bigInt = out.toArray(new Integer[out.size()]);
        int[] littleInt = new int[bigInt.length];
        for (int i = 0; i < bigInt.length; ++i) {
            littleInt[i] = bigInt[i];
        }
        return littleInt;
    }

    public JDBCEventAttr getAttributeTable() {
        return this.jdbcAttr;
    }

    public static void emptyCache() {
        idsToEvents.clear();
        eventsToIds.clear();
    }

    public void updateFlinnEngdahlRegion(int eventid, FlinnEngdahlRegion region) throws NotFound, SQLException {
    }

    public JDBCEventAttr getJDBCAttr() {
        return this.jdbcAttr;
    }

    public JDBCOrigin getJDBCOrigin() {
        return this.jdbcOrigin;
    }

    public CacheEvent getLastEvent() throws SQLException, NotFound {
        ResultSet rs = this.getLast.executeQuery();
        if (rs.next()) {
            return this.getEvent(rs.getInt("event_id"));
        }
        throw new NotFound("No events!");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

