/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Category;

public class DataSetDb {
    private Connection connection;
    private PreparedStatement insertStmt;
    private PreparedStatement getPathStmt;
    private PreparedStatement getStorageTypeStmt;
    private PreparedStatement getNamesStmt;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$database$DataSetDb == null ? (class$edu$sc$seis$fissuresUtil$database$DataSetDb = DataSetDb.class$("edu.sc.seis.fissuresUtil.database.DataSetDb")) : class$edu$sc$seis$fissuresUtil$database$DataSetDb).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$DataSetDb;

    public DataSetDb() {
        this.create();
    }

    public void create() {
        this.connection = this.getConnection();
        try {
            Statement stmt = this.connection.createStatement();
            stmt.executeUpdate(" create table " + this.getDatabaseName() + " ( " + " seismogramid VARCHAR PRIMARY KEY, " + " datasetid VARCHAR, " + " storagetype VARCHAR_IGNORECASE, " + " path VARCHAR_IGNORECASE) ");
            stmt.executeUpdate(" create table geedb (  datasetid VARCHAR PRIMARY KEY,  datasetname VARCHAR_IGNORECASE) ");
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        try {
            this.insertStmt = this.connection.prepareStatement(" INSERT INTO " + this.getDatabaseName() + " VALUES(?, ?, ?) ");
            this.getPathStmt = this.connection.prepareStatement(" SELECT path from " + this.getDatabaseName() + " WHERE seismogramID = ? ");
            this.getStorageTypeStmt = this.connection.prepareStatement(" SELECT storagetype from " + this.getDatabaseName() + " WHERE seismogramID = ? ");
            this.getNamesStmt = this.connection.prepareStatement(" SELECT seismogramID from " + this.getDatabaseName());
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public Connection getConnection() {
        try {
            if (this.connection == null) {
                String driverName = new String("org.hsqldb.jdbcDriver");
                Class.forName(driverName).newInstance();
                this.connection = DriverManager.getConnection("jdbc:hsqldb:" + this.getDatabaseName(), "sa", "");
            }
            return this.connection;
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
            return null;
        }
    }

    public void insert(String seismogramID, String storageType, String path) {
        try {
            this.insertStmt.setString(1, seismogramID);
            this.insertStmt.setString(2, storageType);
            this.insertStmt.setString(3, path);
            this.insertStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public String getPath(String seismogramID) {
        try {
            this.getPathStmt.setString(1, seismogramID);
            ResultSet rs = this.getPathStmt.executeQuery();
            if (rs.next()) {
                return rs.getString("path");
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return null;
    }

    public String getStorageType(String seismogramID) {
        try {
            this.getStorageTypeStmt.setString(1, seismogramID);
            ResultSet rs = this.getStorageTypeStmt.executeQuery();
            if (rs.next()) {
                return rs.getString("storagetype");
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        return null;
    }

    public String[] getSeismogramNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ResultSet rs = this.getNamesStmt.executeQuery();
            while (rs.next()) {
                arrayList.add(rs.getString("seismogramID"));
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
        String[] rtnValues = new String[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    private String getDatabaseName() {
        return "datasetDB";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

