/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConnectionCreator {
    private String url;
    private String type;
    private String username;
    private String password;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$ConnectionCreator == null ? (class$edu$sc$seis$fissuresUtil$database$ConnectionCreator = ConnectionCreator.class$("edu.sc.seis.fissuresUtil.database.ConnectionCreator")) : class$edu$sc$seis$fissuresUtil$database$ConnectionCreator));
    public static final String DB_PROP_PREFIX = "fissuresUtil.database.";
    public static final String DB_URL_KEY = "fissuresUtil.database.url";
    public static final String DB_TYPE_KEY = "fissuresUtil.database.type";
    public static final String DB_USER_KEY = "fissuresUtil.database.username";
    public static final String DB_PASS_KEY = "fissuresUtil.database.password";
    public static final String[] DB_PROP_KEYS = new String[]{"fissuresUtil.database.url", "fissuresUtil.database.type", "fissuresUtil.database.username", "fissuresUtil.database.password"};
    public static final String DB_SERVER_PORT = "server.port";
    public static final String HSQL = "HSQL";
    public static final String MCKOI = "MCKOI";
    public static final String POSTGRES = "POSTGRES";
    public static final String JDBC_DRIVER_PREFIX = "fissuresUtil.database.driver.";
    private Properties jdbcDrivers;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$ConnectionCreator;

    public ConnectionCreator(String[] args) {
        this(ConnectionCreator.loadDbProperties(args));
    }

    public ConnectionCreator(Properties props) {
        this(props.getProperty(DB_URL_KEY, "jdbc:hsqldb:."), props.getProperty(DB_TYPE_KEY, HSQL), props.getProperty(DB_USER_KEY, "SA"), props.getProperty(DB_PASS_KEY, ""));
    }

    public ConnectionCreator(String url, String type, String username, String password) {
        this.url = url;
        this.type = type;
        this.username = username;
        this.password = password;
        this.jdbcDrivers = new Properties();
        try {
            this.jdbcDrivers.load(this.getClass().getClassLoader().getResourceAsStream("edu/sc/seis/fissuresUtil/database/props/drivers.props"));
        }
        catch (Exception e) {
            throw new RuntimeException("unable to load database driver properties");
        }
    }

    public Connection createConnection() throws SQLException {
        try {
            Class.forName(this.jdbcDrivers.getProperty(JDBC_DRIVER_PREFIX + this.type));
        }
        catch (Exception e) {
            SQLException ee = new SQLException("Unable to instantiate DBDriver. type=" + this.type);
            ee.initCause(e);
            throw ee;
        }
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public String getPassword() {
        return this.password;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public static Properties loadDbProperties(String[] args) {
        Properties dbProps = ConnectionCreator.loadDbPropsFromHSQLProps();
        dbProps.putAll((Map<?, ?>)ConnectionCreator.loadDbPropsFromArgProps(args));
        dbProps.putAll((Map<?, ?>)ConnectionCreator.loadDbPropsFromSystemProps());
        return dbProps;
    }

    public static Properties loadDbPropsFromHSQLProps() {
        Properties dbProperties = new Properties();
        try {
            dbProperties.load(new FileInputStream("server.properties"));
            if (dbProperties.containsKey(DB_SERVER_PORT)) {
                if (dbProperties.containsKey(DB_URL_KEY)) {
                    logger.error((Object)"hsql configuration mismatch.  using local hsql config.");
                }
                String url = "jdbc:hsqldb:hsql://localhost";
                if (dbProperties.containsKey(DB_SERVER_PORT)) {
                    url = url + ":" + dbProperties.getProperty(DB_SERVER_PORT);
                }
                url = url + "/";
                if (dbProperties.containsKey("server.dbname.0")) {
                    url = url + dbProperties.getProperty("server.dbname.0");
                }
                logger.debug((Object)("Setting db url to " + url));
                dbProperties.setProperty(DB_URL_KEY, url);
            }
            dbProperties.setProperty(DB_TYPE_KEY, HSQL);
        }
        catch (FileNotFoundException e) {
            logger.debug((Object)"didn't find default server.properties file");
        }
        catch (IOException e) {
            logger.debug((Object)"had trouble reading server.properties file");
        }
        return dbProperties;
    }

    public static Properties loadDbPropsFromArgProps(String[] args) {
        Properties dbProperties = new Properties();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-props")) continue;
            System.out.println("Loading db props");
            try {
                Initializer.loadProps(new FileInputStream(args[i + 1]), dbProperties);
                continue;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Unable to find file " + args[i + 1] + " specified by -props"));
            }
        }
        return dbProperties;
    }

    public static Properties loadDbPropsFromOtherProps(Properties props) {
        Properties dbProperties = new Properties();
        for (int i = 0; i < DB_PROP_KEYS.length; ++i) {
            String curKey = DB_PROP_KEYS[i];
            if (!props.containsKey(curKey)) continue;
            dbProperties.put(curKey, props.get(curKey));
        }
        return dbProperties;
    }

    public static Properties loadDbPropsFromSystemProps() {
        return ConnectionCreator.loadDbPropsFromOtherProps(System.getProperties());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

