/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConnMgr {
    private static final String DEFAULT_LOC = "edu/sc/seis/fissuresUtil/database/props/";
    public static final String DEFAULT = "default";
    private static String DEFAULT_PROPS = "default.props";
    public static final String HSQL = "HSQL";
    private static String HSQL_PROPS = "HSQL.props";
    public static final String MCKOI = "MCKOI";
    private static String MCKOI_PROPS = "MCKOI.props";
    public static final String POSTGRES = "POSTGRES";
    public static final String POSTGRES_PROPS = "Postgres.props";
    public static final String DB_SERVER_PORT = "server.port";
    public static final String DBURL_KEY = "fissuresUtil.database.url";
    private static String DB_NAME = "HSQL";
    private static Properties props;
    private static List propLocs;
    private static final Logger logger;
    private static String url;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$ConnMgr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropsLocation(String loc) {
        List list = propLocs;
        synchronized (list) {
            if (!propLocs.contains(loc)) {
                propLocs.add(loc);
            }
            if (props != null) {
                try {
                    ConnMgr.load(loc, props);
                }
                catch (IOException e) {
                    throw new RuntimeException("Bad props location " + loc, e);
                }
            }
        }
    }

    public static void setDB() throws IOException {
        ConnMgr.setDB(DB_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDB(String dbName) throws IOException {
        DB_NAME = dbName;
        Properties props = new Properties();
        List list = propLocs;
        synchronized (list) {
            Iterator it = propLocs.iterator();
            while (it.hasNext()) {
                ConnMgr.load((String)it.next(), props);
            }
        }
        ConnMgr.setDB(props);
    }

    private static void load(String loc, Properties existing) throws IOException {
        ClassLoader cl = (class$edu$sc$seis$fissuresUtil$database$ConnMgr == null ? (class$edu$sc$seis$fissuresUtil$database$ConnMgr = ConnMgr.class$("edu.sc.seis.fissuresUtil.database.ConnMgr")) : class$edu$sc$seis$fissuresUtil$database$ConnMgr).getClassLoader();
        ConnMgr.load(cl, loc + DEFAULT_PROPS, existing);
        if (DB_NAME == HSQL) {
            ConnMgr.load(cl, loc + HSQL_PROPS, existing);
        } else if (DB_NAME == MCKOI) {
            ConnMgr.load(cl, loc + MCKOI_PROPS, existing);
        } else if (DB_NAME == POSTGRES) {
            ConnMgr.load(cl, loc + POSTGRES_PROPS, existing);
        }
    }

    private static void load(ClassLoader cl, String loc, Properties existing) throws IOException {
        InputStream in = cl.getResourceAsStream(loc);
        if (in != null) {
            existing.load(in);
        }
    }

    public static void setDB(Properties newprops) {
        props = newprops;
    }

    public static boolean hasSQL(String key) {
        return ConnMgr.getProps().containsKey(key);
    }

    public static String getSQL(String key) {
        String SQL = ConnMgr.getProps().getProperty(key);
        if (SQL == null) {
            throw new IllegalArgumentException("No such sql entry " + key + " Make sure the properties files are in the jars and are being loaded");
        }
        return SQL;
    }

    private static String getDriver() {
        return ConnMgr.getProps().getProperty("driver");
    }

    public static void setURL(String url) {
        ConnMgr.url = url;
    }

    public static void setURL(String url, String databaseUser, String databasePassword) {
        ConnMgr.setURL(url);
        if (databaseUser != null) {
            ConnMgr.getProps().setProperty("user", databaseUser);
        }
        if (databasePassword != null) {
            ConnMgr.getProps().setProperty("password", databasePassword);
        }
    }

    public static String getURL() {
        if (url == null) {
            url = ConnMgr.getProps().getProperty("URL");
        }
        return url;
    }

    private static String getPass() {
        return ConnMgr.getProps().getProperty("password");
    }

    private static String getUser() {
        return ConnMgr.getProps().getProperty("user");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProps() {
        Class clazz = class$edu$sc$seis$fissuresUtil$database$ConnMgr == null ? (class$edu$sc$seis$fissuresUtil$database$ConnMgr = ConnMgr.class$("edu.sc.seis.fissuresUtil.database.ConnMgr")) : class$edu$sc$seis$fissuresUtil$database$ConnMgr;
        synchronized (clazz) {
            if (props == null) {
                try {
                    ConnMgr.setDB();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return props;
    }

    public static Connection createConnection() throws SQLException {
        try {
            logger.info((Object)("Using driver class: " + ConnMgr.getDriver()));
            Class.forName(ConnMgr.getDriver()).newInstance();
        }
        catch (Exception e) {
            SQLException ee = new SQLException("Unable to instantiate DBDriver");
            ee.initCause(e);
            throw ee;
        }
        return DriverManager.getConnection(ConnMgr.getURL(), ConnMgr.getUser(), ConnMgr.getPass());
    }

    private static Connection createPSQLConn() throws SQLException {
        return DriverManager.getConnection("jdbc:postgresql:anhingatest", "anhingatest", "");
    }

    public static void installDbProperties(Properties sysProperties, Properties dbProperties) {
        if (dbProperties.containsKey(DB_SERVER_PORT)) {
            if (dbProperties.containsKey(DBURL_KEY)) {
                logger.error((Object)"-hsql properties and SOD properties are both specifying the db connection.  Using -hsql properties");
            }
            String url = "jdbc:hsqldb:hsql://localhost";
            if (dbProperties.containsKey(DB_SERVER_PORT)) {
                url = url + ":" + dbProperties.getProperty(DB_SERVER_PORT);
            }
            url = url + "/";
            if (dbProperties.containsKey("server.dbname.0")) {
                url = url + dbProperties.getProperty("server.dbname.0");
            }
            logger.debug((Object)("Setting db url to " + url));
            ConnMgr.setURL(url);
        } else if (sysProperties.containsKey(DBURL_KEY)) {
            logger.debug((Object)("Setting db url to " + sysProperties.getProperty(DBURL_KEY)));
            ConnMgr.setURL(sysProperties.getProperty(DBURL_KEY));
        } else {
            logger.debug((Object)("using default url of " + ConnMgr.getURL()));
        }
    }

    public static Properties readDbProperties(String[] args) {
        Properties dbProperties = new Properties();
        boolean loadedFromArg = false;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-hsql")) continue;
            System.out.println("Loading db props");
            try {
                Initializer.loadProps(new FileInputStream(args[i + 1]), dbProperties);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Unable to find file " + args[i + 1] + " specified by -hsql"));
            }
            loadedFromArg = true;
        }
        if (!loadedFromArg) {
            try {
                logger.debug((Object)"No -hsql argument found, trying to load from server.properties in current working directory");
                Initializer.loadProps(new FileInputStream("server.properties"), dbProperties);
                logger.debug((Object)"loaded props from server.properties in working directory");
            }
            catch (FileNotFoundException e) {
                logger.debug((Object)"Didn't find default server.properties file");
            }
        }
        return dbProperties;
    }

    public static void installDbProperties(Properties sysProperties, String[] args) {
        ConnMgr.installDbProperties(sysProperties, ConnMgr.readDbProperties(args));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propLocs = new ArrayList();
        logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$ConnMgr == null ? (class$edu$sc$seis$fissuresUtil$database$ConnMgr = ConnMgr.class$("edu.sc.seis.fissuresUtil.database.ConnMgr")) : class$edu$sc$seis$fissuresUtil$database$ConnMgr));
        propLocs.add(DEFAULT_LOC);
    }
}

