/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import org.apache.log4j.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class NSSeismogramDC
implements ServerNameDNS,
ProxySeismogramDC {
    protected String serverDNS;
    protected String serverName;
    private DataCenter dc;
    protected FissuresNamingService nameService;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$cache$NSSeismogramDC == null ? (class$edu$sc$seis$fissuresUtil$cache$NSSeismogramDC = NSSeismogramDC.class$("edu.sc.seis.fissuresUtil.cache.NSSeismogramDC")) : class$edu$sc$seis$fissuresUtil$cache$NSSeismogramDC));
    static /* synthetic */ Class class$edu$iris$Fissures$IfSeismogramDC$DataCenter;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$NSSeismogramDC;

    public NSSeismogramDC(String serverDNS, String serverName, FissuresNamingService fissuresNamingService) {
        this.serverDNS = serverDNS;
        this.serverName = serverName;
        this.nameService = fissuresNamingService;
    }

    public DataCenterOperations getWrappedDC() {
        return this.getDataCenter();
    }

    public DataCenterOperations getWrappedDC(Class wrappedClass) {
        if (wrappedClass.equals(class$edu$iris$Fissures$IfSeismogramDC$DataCenter == null ? (class$edu$iris$Fissures$IfSeismogramDC$DataCenter = NSSeismogramDC.class$("edu.iris.Fissures.IfSeismogramDC.DataCenter")) : class$edu$iris$Fissures$IfSeismogramDC$DataCenter)) {
            return this.getDataCenter();
        }
        throw new IllegalArgumentException("NSSeismogramDCs only contain DataCenters, so it can't contain a ProxyDC of class " + wrappedClass);
    }

    public String getServerDNS() {
        return this.serverDNS;
    }

    public String getServerName() {
        return this.serverName;
    }

    public synchronized void reset() {
        this.dc = null;
    }

    public Object getCorbaObject() {
        return this.getDataCenter();
    }

    public synchronized DataCenter getDataCenter() {
        if (this.dc == null) {
            try {
                try {
                    this.dc = this.nameService.getSeismogramDC(this.serverDNS, this.serverName);
                }
                catch (Throwable t) {
                    this.nameService.reset();
                    this.dc = this.nameService.getSeismogramDC(this.serverDNS, this.serverName);
                }
            }
            catch (NotFound e) {
                this.repackageException((UserException)e);
            }
            catch (CannotProceed e) {
                this.repackageException((UserException)e);
            }
            catch (InvalidName e) {
                this.repackageException((UserException)e);
            }
        }
        return this.dc;
    }

    protected void repackageException(UserException e) {
        String msg = "Unable to resolve " + this.serverName + " " + this.serverDNS + " " + e.toString();
        TRANSIENT t = new TRANSIENT(msg, 0, CompletionStatus.COMPLETED_NO);
        t.initCause((Throwable)e);
        throw t;
    }

    public String queue_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        try {
            return this.getDataCenter().queue_seismograms(a_filterseq);
        }
        catch (Throwable e) {
            logger.warn((java.lang.Object)"Exception in queue_seismograms(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getDataCenter().queue_seismograms(a_filterseq);
        }
    }

    public LocalSeismogram[] retrieve_queue(String a_request) throws FissuresException {
        try {
            return this.getDataCenter().retrieve_queue(a_request);
        }
        catch (Throwable e) {
            logger.warn((java.lang.Object)"Exception in retrieve_queue(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getDataCenter().retrieve_queue(a_request);
        }
    }

    public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
        try {
            return this.getDataCenter().available_data(a_filterseq);
        }
        catch (Throwable e) {
            String msg = "Exception in available_data(), regetting from nameservice to try again. ";
            if (e instanceof FissuresException) {
                msg = msg + ((FissuresException)e).the_error.error_description;
            }
            logger.warn((java.lang.Object)msg, e);
            this.reset();
            return this.getDataCenter().available_data(a_filterseq);
        }
    }

    public void cancel_request(String a_request) throws FissuresException {
        try {
            this.getDataCenter().cancel_request(a_request);
        }
        catch (Throwable e) {
            String msg = "Exception in cancel_request(), regetting from nameservice to try again. ";
            if (e instanceof FissuresException) {
                msg = msg + ((FissuresException)e).the_error.error_description;
            }
            logger.warn((java.lang.Object)msg, e);
            this.reset();
            this.getDataCenter().cancel_request(a_request);
        }
    }

    public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) throws FissuresException {
        try {
            return this.getDataCenter().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
        }
        catch (Throwable e) {
            logger.warn((java.lang.Object)"Exception in request_seismograms(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getDataCenter().request_seismograms(a_filterseq, a_client, long_lived, expiration_time);
        }
    }

    public String request_status(String a_request) throws FissuresException {
        try {
            return this.getDataCenter().request_status(a_request);
        }
        catch (Throwable e) {
            logger.warn((java.lang.Object)"Exception in request_status(), regetting from nameservice to try again.", e);
            this.reset();
            return this.getDataCenter().request_status(a_request);
        }
    }

    public LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        try {
            return this.getDataCenter().retrieve_seismograms(a_filterseq);
        }
        catch (Throwable e) {
            String msg = "Exception in retrieve_seismograms(), regetting from nameservice to try again. ";
            if (e instanceof FissuresException) {
                msg = msg + ((FissuresException)e).the_error.error_description;
            }
            logger.warn((java.lang.Object)msg, e);
            this.reset();
            return this.getDataCenter().retrieve_seismograms(a_filterseq);
        }
    }

    public String toString() {
        return "NSSeismogramDC " + this.serverDNS + "/" + this.serverName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

