/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.ParseRegions;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class EventUtil {
    private static DecimalFormat depthFormatter = new DecimalFormat("###0.00");
    public static final String LOC = "LOC";
    public static final String TIME = "TIME";
    public static final String MAG = "MAG";
    public static final String DEPTH = "DEPTH";
    public static final String DEPTH_UNIT = "DEPTH_UNIT";
    public static final String LAT = "LAT";
    public static final String LON = "LON";
    private static final String[] magicStrings = new String[]{"LOC", "TIME", "MAG", "DEPTH", "DEPTH_UNIT", "LAT", "LON"};
    public static final String NO_ARG_STRING = "Event: LOC | TIME | Mag: MAG | Depth DEPTH DEPTH_UNIT| (LAT, LON)";
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$cache$EventUtil == null ? (class$edu$sc$seis$fissuresUtil$cache$EventUtil = EventUtil.class$("edu.sc.seis.fissuresUtil.cache.EventUtil")) : class$edu$sc$seis$fissuresUtil$cache$EventUtil));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$EventUtil;

    public static Origin extractOrigin(EventAccessOperations ev) {
        try {
            return ev.get_preferred_origin();
        }
        catch (NoPreferredOrigin e) {
            logger.info((Object)"No preferred origin in event.  Trying get_origins instead");
            Origin[] oArray = ev.get_origins();
            if (oArray.length > 0) {
                return oArray[0];
            }
            throw new RuntimeException("No preferred origin", e);
        }
    }

    public static String getEventInfo(EventAccessOperations event) {
        return EventUtil.getEventInfo(event, NO_ARG_STRING);
    }

    public static String getEventInfo(EventAccessOperations event, String format) {
        return EventUtil.getEventInfo(event, format, new SimpleDateFormat("MM/dd/yyyy HH:mm:sss z"));
    }

    public static String getEventInfo(EventAccessOperations event, String format, DateFormat sdf) {
        Origin origin = EventUtil.extractOrigin(event);
        StringBuffer buf = new StringBuffer(format);
        int index = buf.indexOf(LOC);
        if (index != -1) {
            ParseRegions regions = ParseRegions.getInstance();
            String location = regions.getGeographicRegionName(event.get_attributes().region.number);
            buf.delete(index, index + LOC.length());
            buf.insert(index, location);
        }
        return EventUtil.getOriginInfo(origin, buf.toString(), sdf);
    }

    public static String getOriginInfo(Origin origin) {
        return EventUtil.getOriginInfo(origin, NO_ARG_STRING);
    }

    public static String getOriginInfo(Origin origin, String format) {
        return EventUtil.getOriginInfo(origin, format, new SimpleDateFormat("MM/dd/yyyy HH:mm:sss z"));
    }

    public static String getOriginInfo(Origin origin, String format, DateFormat sdf) {
        MicroSecondDate msd = new MicroSecondDate(origin.origin_time);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String originTimeString = sdf.format((Date)msd);
        float mag = Float.NaN;
        if (origin.magnitudes.length > 0) {
            mag = origin.magnitudes[0].value;
        }
        Quantity depth = origin.my_location.depth;
        float latitude = origin.my_location.latitude;
        float longitude = origin.my_location.longitude;
        StringBuffer buf = new StringBuffer(format);
        for (int i = 0; i < magicStrings.length; ++i) {
            int index = buf.indexOf(magicStrings[i]);
            if (index == -1) continue;
            buf.delete(index, index + magicStrings[i].length());
            if (magicStrings[i].equals(TIME)) {
                buf.insert(index, originTimeString);
                continue;
            }
            if (magicStrings[i].equals(MAG)) {
                if (Float.isNaN(mag)) {
                    buf.insert(index, "...");
                    continue;
                }
                buf.insert(index, mag);
                continue;
            }
            if (magicStrings[i].equals(DEPTH)) {
                buf.insert(index, depthFormatter.format(depth.value));
                continue;
            }
            if (magicStrings[i].equals(DEPTH_UNIT)) {
                buf.insert(index, UnitDisplayUtil.getNameForUnit((UnitImpl)depth.the_units));
                continue;
            }
            if (magicStrings[i].equals(LAT)) {
                buf.insert(index, latitude);
                continue;
            }
            if (!magicStrings[i].equals(LON)) continue;
            buf.insert(index, longitude);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

