/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheNetworkAccess
extends ProxyNetworkAccess {
    private Map knownTimes = Collections.synchronizedMap(new HashMap());
    private Map knownStations = Collections.synchronizedMap(new HashMap());
    private Map knownSites = Collections.synchronizedMap(new HashMap());
    private NetworkAttr attr;
    private Station[] stations;
    private HashMap channelMap = new HashMap();
    private HashMap sensMap = new HashMap();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$cache$CacheNetworkAccess == null ? (class$edu$sc$seis$fissuresUtil$cache$CacheNetworkAccess = CacheNetworkAccess.class$("edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess")) : class$edu$sc$seis$fissuresUtil$cache$CacheNetworkAccess));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$CacheNetworkAccess;

    public CacheNetworkAccess(NetworkAccess net) {
        super(net);
    }

    public void reset() {
        this.attr = null;
        this.stations = null;
        this.channelMap.clear();
        this.knownStations.clear();
        this.knownTimes.clear();
        this.knownSites.clear();
        this.sensMap.clear();
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkAttr get_attributes() {
        CacheNetworkAccess cacheNetworkAccess = this;
        synchronized (cacheNetworkAccess) {
            if (this.attr == null) {
                this.attr = this.net.get_attributes();
                this.attr.description = this.attr.description.intern();
                this.attr.name = this.attr.name.intern();
                this.attr.owner = this.attr.owner.intern();
                this.intern(this.attr.get_id());
            }
        }
        return this.attr;
    }

    private void intern(NetworkId id) {
        id.begin_time = this.intern(id.begin_time);
        id.network_code = id.network_code.intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Station[] retrieve_stations() {
        Map map = this.knownStations;
        synchronized (map) {
            if (this.stations == null) {
                this.stations = this.net.retrieve_stations();
                for (int i = 0; i < this.stations.length; ++i) {
                    this.stations[i] = this.intern(this.stations[i]);
                }
            }
        }
        return this.stations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel[] retrieve_for_station(StationId id) {
        String idStr = StationIdUtil.toString((StationId)id);
        HashMap hashMap = this.channelMap;
        synchronized (hashMap) {
            if (!this.channelMap.containsKey(idStr)) {
                Channel[] chans = this.net.retrieve_for_station(id);
                for (int i = 0; i < chans.length; ++i) {
                    this.intern(chans[i]);
                }
                if (chans.length == 0) {
                    logger.debug((Object)("Got 0 channels for station " + StationIdUtil.toString((StationId)id) + " in network " + NetworkIdUtil.toString((NetworkId)this.get_attributes().get_id())));
                }
                this.channelMap.put(idStr, chans);
                return chans;
            }
            return (Channel[])this.channelMap.get(idStr);
        }
    }

    public Instrumentation retrieve_instrumentation(ChannelId id, Time the_time) throws ChannelNotFound {
        Instrumentation inst = this.net.retrieve_instrumentation(id, the_time);
        this.updateHolder(id, the_time, inst);
        return inst;
    }

    private SensitivityHolder updateHolder(ChannelId id, Time the_time, Instrumentation inst) {
        SensitivityHolder holder = this.extractExistingHolder(id, the_time);
        List sensForChannel = this.extractSensForChannel(id);
        if (holder == null) {
            holder = new SensitivityHolder(inst);
            sensForChannel.add(holder);
        } else {
            holder.updateHoldings(inst);
        }
        return holder;
    }

    private SensitivityHolder extractExistingHolder(ChannelId id, Time time) {
        MicroSecondDate date = new MicroSecondDate(time);
        List sensForChannel = this.extractSensForChannel(id);
        Iterator iter = sensForChannel.iterator();
        while (iter.hasNext()) {
            SensitivityHolder holder = (SensitivityHolder)iter.next();
            if (!holder.range.intersects(date)) continue;
            return holder;
        }
        return null;
    }

    private List extractSensForChannel(ChannelId id) {
        String idString = ChannelIdUtil.toString((ChannelId)id);
        ArrayList sensForChannel = (ArrayList)this.sensMap.get(idString);
        if (sensForChannel == null) {
            sensForChannel = new ArrayList();
            this.sensMap.put(idString, sensForChannel);
        }
        return sensForChannel;
    }

    private SensitivityHolder getFilledHolder(ChannelId id, Time the_time) throws ChannelNotFound {
        SensitivityHolder holder = this.extractExistingHolder(id, the_time);
        if (holder == null) {
            this.retrieve_instrumentation(id, the_time);
            return this.extractExistingHolder(id, the_time);
        }
        return holder;
    }

    public Sensitivity retrieve_sensitivity(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).sensitivity;
    }

    public Unit retrieve_initial_units(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).initialUnits;
    }

    public Unit retrieve_final_units(ChannelId id, Time the_time) throws ChannelNotFound {
        return this.getFilledHolder((ChannelId)id, (Time)the_time).finalUnits;
    }

    private void intern(Channel channel) {
        this.intern(channel.get_id());
        channel.my_site = this.intern(channel.my_site);
        this.intern(channel.effective_time);
        channel.name = channel.name.intern();
    }

    private void intern(ChannelId id) {
        id.channel_code = id.channel_code.intern();
        id.network_id = this.get_attributes().get_id();
        id.station_code = id.station_code.intern();
        id.site_code = id.site_code.intern();
        id.begin_time = this.intern(id.begin_time);
    }

    private void intern(SiteId id) {
        id.network_id = this.get_attributes().get_id();
        id.station_code = id.station_code.intern();
        id.site_code = id.site_code.intern();
        id.begin_time = this.intern(id.begin_time);
    }

    private void intern(StationId id) {
        id.network_id = this.get_attributes().get_id();
        id.station_code = id.station_code.intern();
        id.begin_time = this.intern(id.begin_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Site intern(Site site) {
        Map map = this.knownSites;
        synchronized (map) {
            String id = SiteIdUtil.toString((SiteId)site.get_id());
            if (!this.knownSites.containsKey(id)) {
                this.intern(site.get_id());
                site.comment = site.comment.intern();
                site.my_station = this.intern(site.my_station);
                site.effective_time = this.intern(site.effective_time);
                this.knownSites.put(id, site);
                return site;
            }
            return (Site)this.knownSites.get(id);
        }
    }

    private TimeRange intern(TimeRange effective_time) {
        effective_time.end_time = this.intern(effective_time.end_time);
        effective_time.start_time = this.intern(effective_time.start_time);
        return effective_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Station intern(Station station) {
        Map map = this.knownStations;
        synchronized (map) {
            String id = StationIdUtil.toString((StationId)station.get_id());
            if (!this.knownStations.containsKey(id)) {
                this.intern(station.get_id());
                station.my_network = this.get_attributes();
                this.knownStations.put(id, station);
                return station;
            }
            return (Station)this.knownStations.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Time intern(Time unknownTime) {
        Map map = this.knownTimes;
        synchronized (map) {
            if (!this.knownTimes.containsKey(unknownTime.date_time)) {
                this.knownTimes.put(unknownTime.date_time, unknownTime);
                return unknownTime;
            }
            return (Time)this.knownTimes.get(unknownTime.date_time);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SensitivityHolder {
        Sensitivity sensitivity;
        Unit initialUnits;
        Unit finalUnits;
        MicroSecondTimeRange range;

        public SensitivityHolder(Instrumentation inst) {
            this.updateHoldings(inst);
        }

        private void updateHoldings(Instrumentation inst) {
            this.sensitivity = inst.the_response.the_sensitivity;
            Stage[] stages = inst.the_response.stages;
            this.initialUnits = stages[0].input_units;
            this.finalUnits = stages[stages.length - 1].output_units;
            this.range = new MicroSecondTimeRange(inst.effective_time);
        }
    }
}

