/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import java.util.HashMap;
import java.util.Map;

public class TauPUtil {
    static Map taupUtilMap = new HashMap();
    TauP_Time taup_time;

    private TauPUtil(String modelName) throws TauModelException {
        this.taup_time = new TauP_Time(modelName);
    }

    public Arrival[] calcTravelTimes(Station station, Origin origin, String[] phaseNames) throws TauModelException {
        return this.calcTravelTimes(station.my_location, origin, phaseNames);
    }

    public synchronized Arrival[] calcTravelTimes(Location stationLoc, Origin origin, String[] phaseNames) throws TauModelException {
        QuantityImpl depth = (QuantityImpl)origin.my_location.depth;
        depth = depth.convertTo(UnitImpl.KILOMETER);
        DistAz distAz = new DistAz(stationLoc, origin.my_location);
        this.taup_time.setSourceDepth(depth.getValue());
        this.taup_time.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.taup_time.appendPhaseName(phaseNames[i]);
        }
        this.taup_time.calculate(distAz.getDelta());
        Arrival[] arrivals = this.taup_time.getArrivals();
        return arrivals;
    }

    public TauModel getTauModel() {
        return this.taup_time.getTauModel();
    }

    public static synchronized TauPUtil getTauPUtil() {
        try {
            return TauPUtil.getTauPUtil("prem");
        }
        catch (TauModelException e) {
            throw new RuntimeException("Should never happen as prem is bundled with TauP", e);
        }
    }

    public static synchronized TauPUtil getTauPUtil(String modelName) throws TauModelException {
        if (!taupUtilMap.containsKey(modelName)) {
            taupUtilMap.put(modelName, new TauPUtil(modelName));
        }
        return (TauPUtil)taupUtilMap.get(modelName);
    }
}

