/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.bag.PhaseNonExistent;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import org.apache.log4j.Logger;

public class PhaseCut {
    TauPUtil timeCalc;
    String beginPhase;
    TimeInterval beginOffset;
    String endPhase;
    TimeInterval endOffset;
    Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$bag$PhaseCut == null ? (class$edu$sc$seis$fissuresUtil$bag$PhaseCut = PhaseCut.class$("edu.sc.seis.fissuresUtil.bag.PhaseCut")) : class$edu$sc$seis$fissuresUtil$bag$PhaseCut));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$bag$PhaseCut;

    public PhaseCut(TauPUtil timeCalc, String beginPhase, TimeInterval beginOffset, String endPhase, TimeInterval endOffset) {
        this.timeCalc = timeCalc;
        this.beginPhase = beginPhase;
        this.beginOffset = beginOffset;
        this.endPhase = endPhase;
        this.endOffset = endOffset;
    }

    public LocalSeismogramImpl cut(Location stationLoc, Origin origin, LocalSeismogramImpl seis) throws TauModelException, PhaseNonExistent, FissuresException {
        Arrival[] beginArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.beginPhase});
        Arrival[] endArrivals = this.timeCalc.calcTravelTimes(stationLoc, origin, new String[]{this.endPhase});
        MicroSecondDate beginTime = null;
        MicroSecondDate endTime = null;
        MicroSecondDate originTime = new MicroSecondDate(origin.origin_time);
        if (beginArrivals.length == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.my_location);
            throw new PhaseNonExistent("Phase " + this.beginPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        beginTime = originTime.add(new TimeInterval(beginArrivals[0].getTime(), UnitImpl.SECOND));
        beginTime = beginTime.add(this.beginOffset);
        if (endArrivals.length == 0) {
            DistAz distAz = new DistAz(stationLoc, origin.my_location);
            throw new PhaseNonExistent("Phase " + this.endPhase + " does not exist at this distance, " + distAz.getDelta() + " degrees");
        }
        endTime = originTime.add(new TimeInterval(endArrivals[0].getTime(), UnitImpl.SECOND));
        endTime = endTime.add(this.endOffset);
        this.logger.debug((Object)("Phase cut from " + beginTime + " to " + endTime));
        Cut cut = new Cut(beginTime, endTime);
        return cut.apply(seis);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

