/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.LocalSeismogramFunction;
import java.util.Date;
import org.apache.log4j.Logger;

public class Cut
implements LocalSeismogramFunction {
    protected MicroSecondDate begin;
    protected MicroSecondDate end;
    protected UnitImpl secPerSec;
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$bag$Cut == null ? (class$edu$sc$seis$fissuresUtil$bag$Cut = Cut.class$("edu.sc.seis.fissuresUtil.bag.Cut")) : class$edu$sc$seis$fissuresUtil$bag$Cut));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$bag$Cut;

    public Cut(MicroSecondDate begin, MicroSecondDate end) {
        this.begin = begin;
        this.end = end;
        this.secPerSec = UnitImpl.divide((UnitImpl)UnitImpl.SECOND, (UnitImpl)UnitImpl.SECOND);
    }

    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        LocalSeismogramImpl outSeis;
        if (this.begin.after((Date)seis.getEndTime()) || this.end.before((Date)seis.getBeginTime())) {
            return null;
        }
        TimeInterval sampPeriod = seis.getSampling().getPeriod();
        TimeInterval beginShift = this.begin.subtract(seis.getBeginTime());
        beginShift = beginShift.divideBy((QuantityImpl)sampPeriod);
        beginShift = beginShift.convertTo(this.secPerSec);
        int beginIndex = (int)Math.ceil(beginShift.value);
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex >= seis.getNumPoints()) {
            beginIndex = seis.getNumPoints() - 1;
        }
        TimeInterval endShift = seis.getEndTime().subtract(this.end);
        endShift = endShift.divideBy((QuantityImpl)sampPeriod);
        endShift = endShift.convertTo(this.secPerSec);
        int endIndex = seis.getNumPoints() - (int)Math.floor(endShift.value);
        if (endIndex < 0) {
            endIndex = 0;
        }
        if (endIndex > seis.getNumPoints()) {
            endIndex = seis.getNumPoints();
        }
        if (seis.can_convert_to_short()) {
            short[] outS = new short[endIndex - beginIndex];
            short[] inS = seis.get_as_shorts();
            System.arraycopy(inS, beginIndex, outS, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outS);
        } else if (seis.can_convert_to_long()) {
            int[] outI = new int[endIndex - beginIndex];
            int[] inI = seis.get_as_longs();
            System.arraycopy(inI, beginIndex, outI, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outI);
        } else if (seis.can_convert_to_float()) {
            float[] outF = new float[endIndex - beginIndex];
            float[] inF = seis.get_as_floats();
            System.arraycopy(inF, beginIndex, outF, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outF);
        } else {
            double[] outD = new double[endIndex - beginIndex];
            double[] inD = seis.get_as_doubles();
            System.arraycopy(inD, beginIndex, outD, 0, endIndex - beginIndex);
            outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, outD);
        }
        outSeis.begin_time = seis.getBeginTime().add((TimeInterval)sampPeriod.multiplyBy((double)beginIndex)).getFissuresTime();
        return outSeis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

