/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class Bag {
    protected BufferedReader in;
    protected BufferedWriter out;
    protected DataSet dataSet;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$bag$Bag == null ? (class$edu$sc$seis$fissuresUtil$bag$Bag = Bag.class$("edu.sc.seis.fissuresUtil.bag.Bag")) : class$edu$sc$seis$fissuresUtil$bag$Bag));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$bag$Bag;

    public Bag(BufferedReader reader, BufferedWriter writer) {
        this.in = reader;
        this.out = writer;
        AuditInfo[] audit = new AuditInfo[]{};
        this.dataSet = new MemoryDataSet("BagMaster", "Main", System.getProperty("user.name"), audit);
    }

    public void start() {
        try {
            block2: while (true) {
                this.out.write("bag> ");
                this.out.flush();
                String cmdLine = this.in.readLine();
                StringTokenizer tokenizer = new StringTokenizer(cmdLine);
                LinkedList<String> tokens = new LinkedList<String>();
                while (tokenizer.hasMoreTokens()) {
                    tokens.add(tokenizer.nextToken());
                }
                Iterator it = tokens.iterator();
                String cmd = "";
                if (!it.hasNext()) continue;
                cmd = (String)it.next();
                if (cmd.equals("r") || cmd.equals("read")) {
                    while (true) {
                        if (!it.hasNext()) continue block2;
                        File file = new File((String)it.next());
                        if (file.exists()) {
                            URLDataSetSeismogram urlSeis = new URLDataSetSeismogram(file.toURL(), SeismogramFileTypes.SAC);
                            AuditInfo[] dssAudit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "Load from sac file " + file.getName())};
                            this.dataSet.addDataSetSeismogram(urlSeis, dssAudit);
                            SacTimeSeries sac = new SacTimeSeries();
                            sac.read(file.getAbsolutePath());
                            Channel chan = SacToFissures.getChannel(sac);
                            this.dataSet.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)chan.get_id()), chan, dssAudit);
                            continue;
                        }
                        System.err.println("File " + file.getName() + " doesn't exist");
                    }
                }
                if (cmd.equals("lh") || cmd.equals("listheader")) {
                    String[] names = this.dataSet.getDataSetSeismogramNames();
                    int i = 0;
                    while (true) {
                        if (i >= names.length) continue block2;
                        URLDataSetSeismogram dss = (URLDataSetSeismogram)this.dataSet.getDataSetSeismogram(names[i]);
                        this.out.write("NAME:" + names[i]);
                        this.out.newLine();
                        this.out.write("CHANNEL ID:" + ChannelIdUtil.toStringNoDates((ChannelId)dss.getRequestFilter().channel_id));
                        this.out.newLine();
                        Channel chan = this.dataSet.getChannel(dss.getRequestFilter().channel_id);
                        if (chan != null) {
                            Location loc = chan.my_site.my_station.my_location;
                            this.out.write("Station Loc: " + loc.latitude + " / " + loc.longitude);
                            this.out.newLine();
                        }
                        dss.retrieveData(new PrintSeisDataChangeListener(this.out));
                        ++i;
                    }
                }
                if (cmd.equals("quit")) break;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Got IOExcetion.", (Throwable)e);
        }
        logger.debug((Object)"Done");
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Bag bag = new Bag(new BufferedReader(new InputStreamReader(System.in)), new BufferedWriter(new OutputStreamWriter(System.out)));
        bag.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PrintSeisDataChangeListener
    implements SeisDataChangeListener {
        BufferedWriter out;

        PrintSeisDataChangeListener(BufferedWriter out) {
            this.out = out;
        }

        public void pushData(SeisDataChangeEvent sdce) {
            LocalSeismogramImpl[] seis = sdce.getSeismograms();
            for (int j = 0; j < seis.length; ++j) {
                try {
                    this.out.write("NPTS:" + seis[j].getNumPoints());
                    this.out.newLine();
                    this.out.write("Sampling: " + seis[j].getSampling());
                    this.out.newLine();
                    this.out.write("begin: " + seis[j].getBeginTime());
                    this.out.newLine();
                    this.out.flush();
                    continue;
                }
                catch (IOException e) {
                    GlobalExceptionHandler.handle("Problem writing to Writer", e);
                }
            }
        }

        public void finished(SeisDataChangeEvent sdce) {
        }

        public void error(SeisDataErrorEvent sdce) {
        }
    }
}

