/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seismogramDC;

import edu.iris.Fissures.AuditElement;
import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.SequenceOutOfOrder;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnsupportedFormat;
import java.io.Serializable;
import org.omg.CORBA.NO_IMPLEMENT;

public class SeismogramAttrImpl
extends LocalSeismogram {
    protected MicroSecondDate beginTime;

    protected SeismogramAttrImpl() {
    }

    public static Serializable createEmpty() {
        return new SeismogramAttrImpl();
    }

    public SeismogramAttrImpl(String id, Property[] properties, Time begin_time, int num_points, Sampling sample_info, Unit y_unit, ChannelId channel_id, ParameterRef[] parm_ids, Quantity[] time_corrections, Sampling[] sample_rate_history) {
        this.id = id;
        this.begin_time = begin_time;
        this.num_points = num_points;
        this.sampling_info = sample_info;
        this.y_unit = y_unit;
        this.channel_id = channel_id;
        this.time_corrections = time_corrections;
        this.sample_rate_history = sample_rate_history;
        this.setProperties(properties);
        this.setParameterRefs(parm_ids);
    }

    public String get_id() {
        return this.id;
    }

    public int getNumPoints() {
        return this.num_points;
    }

    public void setProperties(Property[] props) {
        if (props == null) {
            throw new IllegalArgumentException("Cannot set null properties.");
        }
        this.properties = props;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return this.properties[i].value;
        }
        return null;
    }

    public void setProperty(String name, String value) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            this.properties[i].value = value;
            return;
        }
        Property[] props = new Property[this.properties.length + 1];
        System.arraycopy(this.properties, 0, props, 0, this.properties.length);
        props[this.properties.length].name = name;
        props[this.properties.length].value = value;
        this.setProperties(props);
    }

    public void setParameterRefs(ParameterRef[] parm_ids) {
        this.parm_ids = parm_ids;
    }

    public ParameterRef[] getParameterRefs() {
        return this.parm_ids;
    }

    public MicroSecondDate getBeginTime() throws UnsupportedFormat {
        if (this.beginTime == null) {
            ISOTime t = new ISOTime(this.begin_time.date_time);
            this.beginTime = t.getDate();
        }
        return this.beginTime;
    }

    public TimeInterval getTimeInterval() {
        TimeInterval q = this.getSampling().getPeriod();
        return new TimeInterval(q.getValue() * (double)(this.num_points - 1), q.getUnit());
    }

    public MicroSecondDate getEndTime() {
        return this.getBeginTime().add(this.getTimeInterval());
    }

    public String getName() {
        if (this.properties == null) {
            return this.get_id();
        }
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals("Name")) continue;
            return this.properties[i].value;
        }
        return this.get_id();
    }

    public void setName(String name) {
        int nameNum = -1;
        if (this.properties == null || this.properties.length == 0) {
            this.properties = new Property[1];
            nameNum = 0;
        } else {
            for (int i = 0; i < this.properties.length; ++i) {
                if (!this.properties[i].name.equals("Name")) continue;
                nameNum = i;
                break;
            }
            if (nameNum == -1) {
                Property[] tmp = new Property[this.properties.length + 1];
                System.arraycopy(this.properties, 0, tmp, 0, this.properties.length);
                nameNum = this.properties.length - 1;
                this.properties = tmp;
            }
        }
        this.properties[nameNum] = new Property("Name", name);
    }

    public UnitImpl getUnit() {
        return (UnitImpl)this.y_unit;
    }

    public ChannelId getChannelID() {
        return this.channel_id;
    }

    public SamplingImpl getSampling() {
        return (SamplingImpl)this.sampling_info;
    }

    public boolean is_closed() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean is_long() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean is_float() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean is_double() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean is_short() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean is_encoded() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean can_convert_to_long() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean can_convert_to_float() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean can_convert_to_double() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public boolean can_convert_to_short() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public int[] get_as_longs() throws FissuresException {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public short[] get_as_shorts() throws FissuresException {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public float[] get_as_floats() throws FissuresException {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public double[] get_as_doubles() throws FissuresException {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public EncodedData[] get_as_encoded() throws FissuresException {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void close() {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public AuditElement[] get_audit_trail() throws NotImplemented {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_longs(int seq_num, int[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_shorts(int seq_num, short[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_floats(int seq_num, float[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_doubles(int seq_num, double[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_encoded_seq(int seq_num, EncodedData[] data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }

    public void append_encoded(int seq_num, EncodedData data, AuditInfo[] audit_info) throws SequenceOutOfOrder {
        throw new NO_IMPLEMENT("not a LocalSeismogram");
    }
}

