/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.TimeFormatter;
import java.util.StringTokenizer;

public class NetworkIdUtil {
    public static boolean areEqual(Time a, Time b) {
        if (a.date_time.equals(b.date_time) && a.leap_seconds_version == b.leap_seconds_version) {
            return true;
        }
        MicroSecondDate aMSD = new MicroSecondDate(a);
        MicroSecondDate bMSD = new MicroSecondDate(b);
        return aMSD.equals(bMSD);
    }

    public static boolean areEqual(NetworkId a, NetworkId b) {
        return a.network_code.equals(b.network_code) && NetworkIdUtil.areEqual(a.begin_time, b.begin_time);
    }

    public static String toString(NetworkId id) {
        return id.network_code + "." + new MicroSecondDate((Time)id.begin_time).getFissuresTime().date_time;
    }

    public static NetworkId fromString(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        return new NetworkId(st.nextToken(), new ISOTime(st.nextToken()).getDate().getFissuresTime());
    }

    public static StringTokenizer getTokenizerAfterNetworkId(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        st.nextToken();
        st.nextToken();
        return st;
    }

    public static String toStringFormatDates(NetworkId id) {
        return id.network_code + "." + TimeFormatter.format(id.begin_time);
    }

    public static String toStringNoDates(NetworkId id) {
        if (id.network_code.startsWith("X") || id.network_code.startsWith("Y") || id.network_code.startsWith("Z")) {
            String netYear = id.begin_time.date_time.substring(2, 4);
            return id.network_code + netYear;
        }
        return id.network_code;
    }

    public static int hashCode(NetworkId id) {
        return 57 + NetworkIdUtil.toString(id).hashCode();
    }
}

