/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNEventInfo;
import edu.sc.seis.seisFile.psn.PSNPhasePick;
import edu.sc.seis.seisFile.psn.PSNPolesAndZeros;
import edu.sc.seis.seisFile.psn.PSNSensorAmpAtoD;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PSNVariableHeader {
    private DataInputStream dis;
    private Map entries = new HashMap();

    public PSNVariableHeader(DataInputStream data, int length) throws IOException {
        this.dis = data;
        for (int i = 0; i < length; ++i) {
            byte check = this.dis.readByte();
            if (check != 85) {
                throw new IOException("file may not be a standard Type 4 PSN format");
            }
            byte id = this.dis.readByte();
            int fieldLength = SacTimeSeries.swapBytes(this.dis.readInt());
            switch (id) {
                case 0: {
                    if (fieldLength == 0) break;
                    throw new IOException("end of header has unread data");
                }
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    byte[] stringArray = new byte[fieldLength];
                    this.dis.readFully(stringArray);
                    String aString = new String(PSNDataFile.chopToLength(stringArray));
                    this.entries.put(new Byte(id), aString);
                    break;
                }
                case 4: {
                    ArrayList eventInfoList = this.entries.containsKey(new Byte(id)) ? (ArrayList)this.entries.get(new Byte(id)) : new ArrayList();
                    eventInfoList.add(new PSNEventInfo(this.dis));
                    this.entries.put(new Byte(id), eventInfoList);
                    break;
                }
                case 5: {
                    ArrayList phasePickList = this.hasPhasePicks() ? (ArrayList)this.entries.get(new Byte(id)) : new ArrayList();
                    phasePickList.add(new PSNPhasePick(this.dis));
                    this.entries.put(new Byte(id), phasePickList);
                    break;
                }
                case 11: {
                    this.entries.put(new Byte(id), new PSNSensorAmpAtoD(this.dis));
                    break;
                }
                case 12: {
                    this.entries.put(new Byte(id), new PSNPolesAndZeros(this.dis));
                    break;
                }
                default: {
                    this.dis.skip(fieldLength);
                }
            }
            i += fieldLength + 5;
        }
    }

    public boolean hasSensorLocation() {
        return this.entries.containsKey(new Byte(1));
    }

    public String getSensorLocation() {
        return (String)this.entries.get(new Byte(1));
    }

    public boolean hasSensorInformation() {
        return this.entries.containsKey(new Byte(2));
    }

    public String getSensorInformation() {
        return (String)this.entries.get(new Byte(2));
    }

    public boolean hasComment() {
        return this.entries.containsKey(new Byte(3));
    }

    public String getComment() {
        return (String)this.entries.get(new Byte(3));
    }

    public boolean hasEventInfo() {
        return this.entries.containsKey(new Byte(4));
    }

    public PSNEventInfo[] getEventInfo() {
        ArrayList eventInfoList = (ArrayList)this.entries.get(new Byte(4));
        return eventInfoList.toArray(new PSNEventInfo[0]);
    }

    public boolean hasPhasePicks() {
        return this.entries.containsKey(new Byte(5));
    }

    public PSNPhasePick[] getPhasePicks() {
        ArrayList eventInfoList = (ArrayList)this.entries.get(new Byte(5));
        return eventInfoList.toArray(new PSNPhasePick[0]);
    }

    public boolean hasDataLoggerID() {
        return this.entries.containsKey(new Byte(7));
    }

    public String getDataLoggerID() {
        return (String)this.entries.get(new Byte(7));
    }

    public boolean hasSensorAmpAtoD() {
        return this.entries.containsKey(new Byte(11));
    }

    public PSNSensorAmpAtoD getSensorAmpAtoD() {
        return (PSNSensorAmpAtoD)this.entries.get(new Byte(11));
    }

    public boolean hasPolesAndZeros() {
        return this.entries.containsKey(new Byte(12));
    }

    public PSNPolesAndZeros getPolesAndZeros() {
        return (PSNPolesAndZeros)this.entries.get(new Byte(12));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set ks = this.entries.keySet();
        Iterator iter = ks.iterator();
        while (iter.hasNext()) {
            Byte curr = (Byte)iter.next();
            byte id = curr;
            switch (id) {
                case 1: {
                    buf.append("Sensor Location: " + (String)this.entries.get(curr) + '\n');
                    break;
                }
                case 2: {
                    buf.append("Sensor Info: " + (String)this.entries.get(curr) + '\n');
                    break;
                }
                case 3: {
                    buf.append("Comments: " + (String)this.entries.get(curr) + '\n');
                    break;
                }
                case 7: {
                    buf.append("DataLogger ID: " + (String)this.entries.get(curr) + '\n');
                    break;
                }
                case 4: {
                    ArrayList eventInfoList = (ArrayList)this.entries.get(curr);
                    Iterator it = eventInfoList.iterator();
                    while (it.hasNext()) {
                        PSNEventInfo evInf = (PSNEventInfo)it.next();
                        buf.append(evInf.toString());
                    }
                    break;
                }
                case 5: {
                    ArrayList phasePickList = (ArrayList)this.entries.get(curr);
                    Iterator it2 = phasePickList.iterator();
                    while (it2.hasNext()) {
                        PSNEventInfo evInf = (PSNEventInfo)it2.next();
                        buf.append(evInf.toString());
                    }
                    break;
                }
                case 11: {
                    PSNSensorAmpAtoD psnSens = (PSNSensorAmpAtoD)this.entries.get(curr);
                    buf.append(psnSens.toString());
                    break;
                }
                case 12: {
                    PSNPolesAndZeros psnPoles = (PSNPolesAndZeros)this.entries.get(curr);
                    buf.append(psnPoles.toString());
                }
            }
        }
        return buf.toString();
    }
}

