/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.psn;

import edu.sc.seis.seisFile.psn.PSNHeader;
import edu.sc.seis.seisFile.psn.PSNVariableHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.DataInputStream;
import java.io.IOException;

public class PSNEventRecord {
    private DataInputStream dis;
    private PSNHeader fixedHeader;
    private PSNVariableHeader varHeader;
    private boolean isShort = false;
    private boolean isInt = false;
    private boolean isFloat = false;
    private boolean isDouble = false;
    private short[] samplesShort;
    private int[] samplesInt;
    private float[] samplesFloat;
    private double[] samplesDouble;

    public PSNEventRecord(DataInputStream data) throws IOException {
        this(new PSNHeader(data), data);
    }

    public PSNEventRecord(PSNHeader header, DataInputStream data) throws IOException {
        this.dis = data;
        this.fixedHeader = header;
        this.varHeader = new PSNVariableHeader(this.dis, header.getVarHeadLength());
        this.readSampleData();
        if (this.fixedHeader.getFlags() == 1) {
            if (this.dis.readShort() != 0) {
                throw new IOException("CRC-16 check has wrong value!");
            }
        } else {
            this.dis.skipBytes(2);
        }
    }

    private void readSampleData() throws IOException {
        byte dataType = this.fixedHeader.getSampleDataType();
        switch (dataType) {
            case 0: {
                this.isShort = true;
                this.samplesShort = new short[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesShort.length; ++i) {
                    this.samplesShort[i] = SacTimeSeries.swapBytes(this.dis.readShort());
                }
                break;
            }
            case 1: {
                this.isInt = true;
                this.samplesInt = new int[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesInt.length; ++i) {
                    this.samplesInt[i] = SacTimeSeries.swapBytes(this.dis.readInt());
                }
                break;
            }
            case 2: {
                this.isFloat = true;
                this.samplesFloat = new float[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesFloat.length; ++i) {
                    this.samplesFloat[i] = SacTimeSeries.swapBytes(this.dis.readFloat());
                }
                break;
            }
            case 3: {
                this.isDouble = true;
                this.samplesDouble = new double[this.fixedHeader.getSampleCount()];
                for (int i = 0; i < this.samplesDouble.length; ++i) {
                    this.samplesDouble[i] = SacTimeSeries.swapBytes(this.dis.readDouble());
                }
                break;
            }
            default: {
                throw new IOException("data type not supported");
            }
        }
    }

    public PSNHeader getFixedHeader() {
        return this.fixedHeader;
    }

    public PSNVariableHeader getVariableHeader() {
        return this.varHeader;
    }

    public boolean isSampleDataShort() {
        return this.isShort;
    }

    public short[] getSampleDataShort() {
        return this.samplesShort;
    }

    public boolean isSampleDataInt() {
        return this.isInt;
    }

    public int[] getSampleDataInt() {
        return this.samplesInt;
    }

    public boolean isSampleDataFloat() {
        return this.isFloat;
    }

    public float[] getSampleDataFloat() {
        return this.samplesFloat;
    }

    public boolean isSampleDataDouble() {
        return this.isDouble;
    }

    public double[] getSampleDataDouble() {
        return this.samplesDouble;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append(this.fixedHeader.toString());
        buf.append(this.varHeader.toString());
        if (this.isShort) {
            for (i = 0; i < this.samplesShort.length; ++i) {
                buf.append(this.samplesShort[i] + " ");
            }
        }
        if (this.isInt) {
            for (i = 0; i < this.samplesInt.length; ++i) {
                buf.append(this.samplesInt[i] + " ");
            }
        }
        if (this.isFloat) {
            for (i = 0; i < this.samplesFloat.length; ++i) {
                buf.append(this.samplesFloat[i] + " ");
            }
        }
        if (this.isDouble) {
            for (i = 0; i < this.samplesDouble.length; ++i) {
                buf.append(this.samplesDouble[i] + " ");
            }
        }
        buf.append('\n');
        return buf.toString();
    }
}

