/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.Socket;

public class MiniSeedRead {
    protected int numRead = 0;
    protected DataInput inStream;
    protected int recordSize;
    protected boolean readData;

    protected MiniSeedRead() {
    }

    public MiniSeedRead(DataInput inStream) throws IOException {
        this.inStream = inStream;
    }

    public void close() throws IOException {
        this.inStream = null;
    }

    public DataRecord getNextRecord() throws SeedFormatException, IOException {
        ControlHeader header = ControlHeader.read(this.inStream);
        if (header instanceof DataHeader) {
            return this.readDataRecord((DataHeader)header);
        }
        throw new SeedFormatException("Found a control record in miniseed");
    }

    public int getNumRecordsRead() {
        return this.numRead;
    }

    protected DataRecord readDataRecord(DataHeader header) throws IOException, SeedFormatException {
        Blockette[] allBs;
        ++this.numRead;
        if (header.getDataBlocketteOffset() < header.getSize()) {
            if (header.getDataBlocketteOffset() == 0) {
                throw new IllegalArgumentException("Offset to first blockette is zero, this is not valid as miniseed must have a blockette 1000");
            }
            throw new IllegalArgumentException("Offset to first blockette must be larger than the header size");
        }
        byte[] garbage = new byte[header.getDataBlocketteOffset() - header.getSize()];
        DataRecord dataRec = new DataRecord(header);
        if (garbage.length != 0) {
            this.inStream.readFully(garbage);
        }
        int currOffset = header.getDataBlocketteOffset();
        for (int i = 0; i < header.getNumBlockettes(); ++i) {
            byte hibyte = this.inStream.readByte();
            byte lowbyte = this.inStream.readByte();
            int type = Utility.uBytesToInt(hibyte, lowbyte, false);
            hibyte = this.inStream.readByte();
            lowbyte = this.inStream.readByte();
            int nextOffset = Utility.uBytesToInt(hibyte, lowbyte, false);
            byte[] blocketteBytes = nextOffset != 0 ? new byte[nextOffset - currOffset] : (header.getDataOffset() > currOffset ? new byte[header.getDataOffset() - (currOffset += 4)] : new byte[]{});
            this.inStream.readFully(blocketteBytes);
            currOffset = nextOffset != 0 ? nextOffset : (currOffset += blocketteBytes.length);
            byte[] fullBytes = new byte[4 + blocketteBytes.length];
            System.arraycopy(Utility.intToByteArray(type), 2, fullBytes, 0, 2);
            System.arraycopy(blocketteBytes, 0, fullBytes, 4, blocketteBytes.length);
            Blockette b = Blockette.parseBlockette(type, fullBytes);
            dataRec.addBlockette(b);
            if (nextOffset == 0) break;
        }
        if ((allBs = dataRec.getBlockettes(1000)).length == 0) {
            throw new SeedFormatException("no blockette 1000");
        }
        if (allBs.length > 1) {
            throw new SeedFormatException("Multiple blockette 1000s in the volume. " + allBs.length);
        }
        Blockette1000 b1000 = (Blockette1000)allBs[0];
        byte[] timeseries = header.getDataOffset() == 0 ? new byte[b1000.getDataRecordLength() - currOffset] : new byte[b1000.getDataRecordLength() - header.getDataOffset()];
        this.inStream.readFully(timeseries);
        dataRec.setData(timeseries);
        return dataRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block15: {
            FilterInputStream ls = null;
            System.out.println("open socket");
            if (args.length == 0) {
                Socket lissConnect = new Socket("anmo.iu.liss.org", 4000);
                ls = new DataInputStream(new BufferedInputStream(lissConnect.getInputStream(), 1024));
            } else {
                ls = new DataInputStream(new BufferedInputStream(new FileInputStream(args[0])));
            }
            MiniSeedRead rf = new MiniSeedRead((DataInput)((Object)ls));
            for (int i = 0; i < 10; ++i) {
                DataRecord sr = rf.getNextRecord();
                System.out.println(sr);
                if (!(sr instanceof DataRecord)) continue;
                DataRecord dr = sr;
                byte[] data = dr.getData();
                Blockette[] blockettes = dr.getBlockettes(1000);
                Blockette1000 b1000 = (Blockette1000)blockettes[0];
                boolean swapNeeded = false;
                if (b1000.getWordOrder() == 0) {
                    swapNeeded = true;
                }
                if (b1000.getEncodingFormat() != 0) continue;
                String s = new String(data);
                System.out.println(s);
            }
            Object var12_12 = null;
            try {
                if (ls != null) {
                    ls.close();
                }
                break block15;
            }
            catch (Exception ee) {}
            break block15;
            {
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                    Object var12_13 = null;
                    try {
                        if (ls != null) {
                            ls.close();
                        }
                        break block15;
                    }
                    catch (Exception ee) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (ls != null) {
                        ls.close();
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

