/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class DataHeader
extends ControlHeader {
    protected byte[] stationIdentifier = new byte[5];
    protected byte[] locationIdentifier = new byte[2];
    protected byte[] channelIdentifier = new byte[3];
    protected byte[] networkCode = new byte[2];
    protected byte[] startTime = new byte[10];
    protected int numSamples;
    protected int sampleRateFactor;
    protected int sampleRateMultiplier;
    protected byte activityFlags;
    protected byte ioClockFlags;
    protected byte dataQualityFlags;
    protected byte numBlockettes;
    protected byte[] timeCorrection = new byte[4];
    protected int dataOffset;
    protected int dataBlocketteOffset;
    static SimpleDateFormat seedDate = new SimpleDateFormat("yyyy,DDD,HH,mm,ss.");

    public DataHeader(int sequenceNum, char typeCode, boolean continuationCode) {
        super(sequenceNum, typeCode, continuationCode);
    }

    public void writeASCII(Writer out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        this.write(new DataOutputStream(bos));
        byte[] bytes = bos.toByteArray();
        for (int i = 0; i < 20; ++i) {
            char c = (char)bytes[i];
            out.write(c);
        }
        out.write("\n");
        out.write("year=" + Utility.bytesToShort(bytes[20], bytes[21], false));
        out.write("jday=" + Utility.bytesToShort(bytes[22], bytes[23], false));
        out.write("hour=" + bytes[24]);
        out.write("min=" + bytes[25]);
        out.write("sec=" + bytes[26]);
        out.write("unused=" + bytes[27]);
        out.write("tsec=" + Utility.bytesToShort(bytes[28], bytes[29], false));
        out.write("numPTS=" + Utility.bytesToShort(bytes[30], bytes[31], false));
        out.write("sampFac=" + Utility.bytesToShort(bytes[32], bytes[33], false));
        out.write("sampMul=" + Utility.bytesToShort(bytes[34], bytes[35], false));
        boolean zero = false;
        out.write("ac=" + bytes[36]);
        out.write("io=" + bytes[37]);
        out.write("qual=" + bytes[38]);
        out.write("numBlockettes=" + bytes[39]);
        out.write("ac=" + bytes[40]);
        out.write("ac=" + bytes[41]);
        out.write("ac=" + bytes[42]);
        out.write("ac=" + bytes[43]);
        out.write("beginData=" + Utility.bytesToShort(bytes[44], bytes[45], false));
        out.write("firstBlockette=" + Utility.bytesToShort(bytes[46], bytes[47], false));
    }

    void outwrite() {
    }

    public static DataHeader read(DataInput in, int sequenceNum, char typeCode, boolean continuationCode) throws IOException, SeedFormatException {
        byte[] buf = new byte[40];
        in.readFully(buf);
        DataHeader data = new DataHeader(sequenceNum, typeCode, continuationCode);
        data.read(buf, 0);
        return data;
    }

    private boolean flagByteSwap() {
        int year = Utility.uBytesToInt(this.startTime[0], this.startTime[1], false);
        return year < 1960 || year > 2050;
    }

    protected void read(byte[] buf, int offset) {
        System.arraycopy(buf, offset + 0, this.stationIdentifier, 0, this.stationIdentifier.length);
        System.arraycopy(buf, offset + 5, this.locationIdentifier, 0, this.locationIdentifier.length);
        System.arraycopy(buf, offset + 7, this.channelIdentifier, 0, this.channelIdentifier.length);
        System.arraycopy(buf, offset + 10, this.networkCode, 0, this.networkCode.length);
        System.arraycopy(buf, offset + 12, this.startTime, 0, this.startTime.length);
        boolean byteSwapFlag = this.flagByteSwap();
        this.numSamples = Utility.uBytesToInt(buf[offset + 22], buf[offset + 23], byteSwapFlag);
        this.sampleRateFactor = Utility.bytesToInt(buf[offset + 24], buf[offset + 25], byteSwapFlag);
        this.sampleRateMultiplier = Utility.bytesToInt(buf[offset + 26], buf[offset + 27], byteSwapFlag);
        this.activityFlags = buf[offset + 28];
        this.ioClockFlags = buf[offset + 29];
        this.dataQualityFlags = buf[offset + 30];
        this.numBlockettes = buf[offset + 31];
        System.arraycopy(buf, offset + 32, this.timeCorrection, 0, this.timeCorrection.length);
        this.dataOffset = Utility.uBytesToInt(buf[offset + 36], buf[offset + 37], byteSwapFlag);
        this.dataBlocketteOffset = Utility.uBytesToInt(buf[offset + 38], buf[offset + 39], byteSwapFlag);
    }

    protected void write(DataOutput dos) throws IOException {
        super.write(dos);
        dos.write(Utility.pad(this.getStationIdentifier().getBytes("ASCII"), 5, (byte)32));
        dos.write(Utility.pad(this.getLocationIdentifier().getBytes("ASCII"), 2, (byte)32));
        dos.write(Utility.pad(this.getChannelIdentifier().getBytes("ASCII"), 3, (byte)32));
        dos.write(Utility.pad(this.getNetworkCode().getBytes("ASCII"), 2, (byte)32));
        dos.write(this.startTime);
        dos.writeShort((short)this.getNumSamples());
        dos.writeShort((short)this.getSampleRateFactor());
        dos.writeShort((short)this.getSampleRateMultiplier());
        dos.writeByte(this.getActivityFlags());
        dos.writeByte(this.getIOClockFlags());
        dos.writeByte(this.getDataQualityFlags());
        dos.writeByte(this.getNumBlockettes());
        dos.write(this.getTimeCorrection());
        dos.writeShort((short)this.getDataOffset());
        dos.writeShort((short)this.getDataBlocketteOffset());
    }

    public short getSize() {
        return 48;
    }

    public String getStationIdentifier() {
        return new String(this.stationIdentifier);
    }

    public void setStationIdentifier(String v) {
        int requriedBytes = 5;
        try {
            this.stationIdentifier = Utility.pad(v.getBytes("ASCII"), 5, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getLocationIdentifier() {
        return new String(this.locationIdentifier);
    }

    public void setLocationIdentifier(String v) {
        int requiredBytes = 2;
        try {
            this.locationIdentifier = Utility.pad(v.getBytes("ASCII"), requiredBytes, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getChannelIdentifier() {
        return new String(this.channelIdentifier);
    }

    public void setChannelIdentifier(String v) {
        int requiredBytes = 3;
        try {
            this.channelIdentifier = Utility.pad(v.getBytes("ASCII"), requiredBytes, (byte)32);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getNetworkCode() {
        return new String(this.networkCode);
    }

    public void setNetworkCode(String v) {
        int requiredBytes = 2;
        byte paddingByte = 32;
        try {
            this.networkCode = Utility.pad(v.getBytes("ASCII"), requiredBytes, paddingByte);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public Btime getStartBtime() {
        Btime bTime = new Btime();
        boolean byteSwapFlag = this.flagByteSwap();
        bTime.year = Utility.uBytesToInt(this.startTime[0], this.startTime[1], byteSwapFlag);
        bTime.jday = Utility.uBytesToInt(this.startTime[2], this.startTime[3], byteSwapFlag);
        bTime.hour = this.startTime[4] & 0xFF;
        bTime.min = this.startTime[5] & 0xFF;
        bTime.sec = this.startTime[6] & 0xFF;
        bTime.tenthMilli = Utility.uBytesToInt(this.startTime[8], this.startTime[9], byteSwapFlag);
        return bTime;
    }

    public void setStartBtime(Btime btime) {
        this.startTime = btime.getAsBytes();
    }

    public float getSampleRate() {
        double factor = this.getSampleRateFactor();
        double multiplier = this.getSampleRateMultiplier();
        float sampleRate = 10000.0f;
        if (factor * multiplier != 0.0) {
            sampleRate = (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier)));
        }
        return sampleRate;
    }

    private double ttConvert(Btime bTime) {
        double tenThousandths = (double)bTime.jday * 8.64E8;
        tenThousandths += (double)bTime.hour * 3.6E7;
        tenThousandths += (double)bTime.min * 600000.0;
        tenThousandths += (double)bTime.sec * 10000.0;
        return tenThousandths += (double)bTime.tenthMilli;
    }

    private Btime projectTime(Btime bTime, double tenThousandths) {
        boolean is_leap;
        int offset = 0;
        boolean bl = is_leap = bTime.year % 4 == 0 && bTime.year % 100 != 0 || bTime.year % 400 == 0;
        if (is_leap) {
            offset = 1;
        }
        if ((tenThousandths += this.ttConvert(bTime)) >= (double)(366 + offset) * 8.64E8) {
            ++bTime.year;
            tenThousandths -= (double)(365 + offset) * 8.64E8;
        }
        bTime.jday = (int)(tenThousandths / 8.64E8);
        bTime.hour = (int)((tenThousandths -= (double)bTime.jday * 8.64E8) / 3.6E7);
        bTime.min = (int)((tenThousandths -= (double)bTime.hour * 3.6E7) / 600000.0);
        bTime.sec = (int)((tenThousandths -= (double)bTime.min * 600000.0) / 10000.0);
        bTime.tenthMilli = (int)(tenThousandths -= (double)bTime.sec * 10000.0);
        return bTime;
    }

    private Btime getEndBtime() {
        Btime startBtime = this.getStartBtime();
        double numTenThousandths = (double)this.getNumSamples() / (double)this.getSampleRate() * 10000.0;
        return this.projectTime(startBtime, numTenThousandths);
    }

    private Btime getLastSampleBtime() {
        Btime startBtime = this.getStartBtime();
        double numTenThousandths = (double)(this.getNumSamples() - 1) / (double)this.getSampleRate() * 10000.0;
        return this.projectTime(startBtime, numTenThousandths);
    }

    public String getStartTime() {
        Btime startStruct = this.getStartBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(startStruct.year) + "," + threeZero.format(startStruct.jday) + "," + twoZero.format(startStruct.hour) + ":" + twoZero.format(startStruct.min) + ":" + twoZero.format(startStruct.sec) + "." + fourZero.format(startStruct.tenthMilli));
    }

    public String getEndTime() {
        Btime endStruct = this.getEndBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(endStruct.year) + "," + threeZero.format(endStruct.jday) + "," + twoZero.format(endStruct.hour) + ":" + twoZero.format(endStruct.min) + ":" + twoZero.format(endStruct.sec) + "." + fourZero.format(endStruct.tenthMilli));
    }

    public String getLastSampleTime() {
        Btime endStruct = this.getLastSampleBtime();
        DecimalFormat twoZero = new DecimalFormat("00");
        DecimalFormat threeZero = new DecimalFormat("000");
        DecimalFormat fourZero = new DecimalFormat("0000");
        return new String(fourZero.format(endStruct.year) + "," + threeZero.format(endStruct.jday) + "," + twoZero.format(endStruct.hour) + ":" + twoZero.format(endStruct.min) + ":" + twoZero.format(endStruct.sec) + "." + fourZero.format(endStruct.tenthMilli));
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(short v) {
        this.numSamples = v;
    }

    public int getSampleRateFactor() {
        return this.sampleRateFactor;
    }

    public void setSampleRateFactor(short v) {
        this.sampleRateFactor = v;
    }

    public int getSampleRateMultiplier() {
        return this.sampleRateMultiplier;
    }

    public void setSampleRateMultiplier(short v) {
        this.sampleRateMultiplier = v;
    }

    public byte getActivityFlags() {
        return this.activityFlags;
    }

    public void setActivityFlags(byte v) {
        this.activityFlags = v;
    }

    public byte getIOClockFlags() {
        return this.ioClockFlags;
    }

    public void setIOClockFlags(byte v) {
        this.ioClockFlags = v;
    }

    public byte getDataQualityFlags() {
        return this.dataQualityFlags;
    }

    public void setDataQualityFlags(byte v) {
        this.dataQualityFlags = v;
    }

    public byte getNumBlockettes() {
        return this.numBlockettes;
    }

    public void setNumBlockettes(byte v) {
        this.numBlockettes = v;
    }

    public byte[] getTimeCorrection() {
        return this.timeCorrection;
    }

    public void setTimeCorrection(byte[] v) {
        byte[] timeCorrectionBytes = new byte[4];
        if (v.length != 4) {
            timeCorrectionBytes = v.length < 4 ? Utility.pad(v, 4, (byte)0) : Utility.format(v, v.length - 4, v.length);
            this.timeCorrection = timeCorrectionBytes;
        } else {
            this.timeCorrection = v;
        }
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setDataOffset(short v) {
        this.dataOffset = v;
    }

    public int getDataBlocketteOffset() {
        return this.dataBlocketteOffset;
    }

    public void setDataBlocketteOffset(short v) {
        this.dataBlocketteOffset = v;
    }

    public String toString() {
        String s = super.toString() + " ";
        s = s + " " + this.getStationIdentifier() + "." + this.getLocationIdentifier() + "." + this.getChannelIdentifier() + "." + this.getNetworkCode() + "." + this.getStartTime() + "  " + this.getNumBlockettes() + " " + this.getDataOffset() + " " + this.getDataBlocketteOffset();
        return s;
    }
}

