/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.SteimException;
import edu.iris.dmc.seedcodec.SteimFrameBlock;
import edu.iris.dmc.seedcodec.Utility;

public class Steim1 {
    public static int[] decode(byte[] b, int numSamples, boolean swapBytes, int bias) throws SteimException {
        if (b.length % 64 != 0) {
            throw new SteimException("encoded data length is not multiple of 64 bytes (" + b.length + ")");
        }
        int[] samples = new int[numSamples];
        int numFrames = b.length / 64;
        int current = 0;
        int start = 0;
        int end = 0;
        int firstData = 0;
        int lastValue = 0;
        int i = 0;
        while (i < numFrames) {
            int[] tempSamples = Steim1.extractSamples(b, i * 64, swapBytes);
            firstData = 0;
            if (i == 0) {
                lastValue = bias;
                start = tempSamples[1];
                end = tempSamples[2];
                firstData = 3;
                if (bias == 0) {
                    lastValue = start - tempSamples[3];
                }
            }
            int j = firstData;
            while (j < tempSamples.length && current < numSamples) {
                samples[current] = lastValue + tempSamples[j];
                lastValue = samples[current];
                ++current;
                ++j;
            }
            ++i;
        }
        return samples;
    }

    public static int[] decode(byte[] b, int numSamples, boolean swapBytes) throws SteimException {
        return Steim1.decode(b, numSamples, swapBytes, 0);
    }

    public static SteimFrameBlock encode(int[] samples, int frames, int bias) throws SteimException {
        if (samples.length == 0) {
            throw new SteimException("samples array is zero size");
        }
        if (frames <= 0) {
            throw new SteimException("number of frames is not a positive value");
        }
        if (frames > 63) {
            throw new SteimException("cannot encode more than 63 frames, you asked for " + frames);
        }
        SteimFrameBlock frameBlock = new SteimFrameBlock(frames, 1);
        frameBlock.addEncodedWord(samples[0], 0, 0);
        frameBlock.addEncodedWord(samples[samples.length - 1], 0, 0);
        int sampleIndex = 0;
        int[] diff = new int[4];
        int diffCount = 0;
        int maxSize = 0;
        int curSize = 0;
        while (sampleIndex < samples.length) {
            diffCount = 0;
            maxSize = 0;
            int i = 0;
            while (i < 4) {
                if (sampleIndex + i >= samples.length) break;
                if (sampleIndex + i == 0) {
                    diff[0] = samples[0] - bias;
                } else {
                    diff[i] = samples[sampleIndex + i] - samples[sampleIndex + i - 1];
                }
                ++diffCount;
                curSize = diff[i] <= 127 && diff[i] >= -128 ? 1 : (diff[i] <= Short.MAX_VALUE && diff[i] >= Short.MIN_VALUE ? 2 : 4);
                if (curSize > maxSize) {
                    maxSize = curSize;
                }
                if (maxSize * diffCount == 4) break;
                if (maxSize * diffCount > 4) {
                    if (--diffCount != 3) break;
                    --diffCount;
                    break;
                }
                ++i;
            }
            int nibble = 0;
            int word = 0;
            if (diffCount == 1) {
                word = diff[0];
                nibble = 3;
            } else if (diffCount == 2) {
                word = (diff[0] & 0xFFFF) << 16;
                word |= diff[1] & 0xFFFF;
                nibble = 2;
            } else {
                word = (diff[0] & 0xFF) << 24;
                word |= (diff[1] & 0xFF) << 16;
                word |= (diff[2] & 0xFF) << 8;
                word |= diff[3] & 0xFF;
                nibble = 1;
            }
            if (frameBlock.addEncodedWord(word, diffCount, nibble)) {
                frameBlock.setXsubN(samples[sampleIndex + diffCount - 1]);
                break;
            }
            sampleIndex += diffCount;
        }
        return frameBlock;
    }

    public static SteimFrameBlock encode(int[] samples, int frames) throws SteimException {
        return Steim1.encode(samples, frames, 0);
    }

    protected static int[] extractSamples(byte[] bytes, int offset, boolean swapBytes) {
        int nibbles = Utility.bytesToInt(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], swapBytes);
        int currNibble = 0;
        int[] temp = new int[64];
        int currNum = 0;
        int i = 0;
        while (i < 16) {
            currNibble = nibbles >> 30 - i * 2 & 3;
            switch (currNibble) {
                case 0: {
                    if (offset != 0) break;
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    break;
                }
                case 1: {
                    int n = 0;
                    while (n < 4) {
                        temp[currNum] = Utility.bytesToInt(bytes[offset + i * 4 + n]);
                        ++currNum;
                        ++n;
                    }
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < 4) {
                        temp[currNum] = Utility.bytesToInt(bytes[offset + i * 4 + n], bytes[offset + i * 4 + n + 1], swapBytes);
                        ++currNum;
                        n += 2;
                    }
                    break;
                }
                case 3: {
                    temp[currNum++] = Utility.bytesToInt(bytes[offset + i * 4], bytes[offset + i * 4 + 1], bytes[offset + i * 4 + 2], bytes[offset + i * 4 + 3], swapBytes);
                    break;
                }
            }
            ++i;
        }
        int[] out = new int[currNum];
        System.arraycopy(temp, 0, out, 0, currNum);
        return out;
    }

    public static void main(String[] args) throws SteimException {
        byte[] b = new byte[64];
        int i = 0;
        while (i < 64) {
            b[i] = 0;
            ++i;
        }
        b[0] = 1;
        b[1] = -80;
        System.out.println(b[1]);
        b[2] = -1;
        b[3] = -1;
        b[4] = 0;
        b[5] = 0;
        b[6] = 0;
        b[7] = 0;
        b[8] = 0;
        b[9] = 0;
        b[10] = 0;
        b[11] = 0;
        b[12] = 1;
        b[13] = 2;
        b[14] = 3;
        b[15] = 0;
        b[16] = 1;
        b[17] = 1;
        b[18] = 0;
        b[19] = 0;
        b[20] = 0;
        b[21] = 1;
        b[22] = 0;
        b[23] = 0;
        int[] nArray = Steim1.decode(b, 17, false);
    }
}

