/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.security.MessageDigest;
import org.gradle.wrapper.WrapperConfiguration;

public class PathAssembler {
    public static final String GRADLE_USER_HOME_STRING = "GRADLE_USER_HOME";
    public static final String PROJECT_STRING = "PROJECT";
    private File gradleUserHome;

    public PathAssembler() {
    }

    public PathAssembler(File file) {
        this.gradleUserHome = file;
    }

    public LocalDistribution getDistribution(WrapperConfiguration wrapperConfiguration) {
        String string = this.getDistName(wrapperConfiguration.getDistribution());
        String string2 = this.removeExtension(string);
        String string3 = this.rootDirName(string2, wrapperConfiguration);
        File file = new File(this.getBaseDir(wrapperConfiguration.getDistributionBase()), wrapperConfiguration.getDistributionPath() + "/" + string3);
        File file2 = new File(this.getBaseDir(wrapperConfiguration.getZipBase()), wrapperConfiguration.getZipPath() + "/" + string3 + "/" + string);
        return new LocalDistribution(file, file2);
    }

    private String rootDirName(String string, WrapperConfiguration wrapperConfiguration) {
        String string2 = this.getMd5Hash(wrapperConfiguration.getDistribution().toString());
        return String.format("%s/%s", string, string2);
    }

    private String getMd5Hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = string.getBytes();
            messageDigest.update(byArray);
            return new BigInteger(1, messageDigest.digest()).toString(32);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not hash input string.", exception);
        }
    }

    private String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private String getDistName(URI uRI) {
        String string = uRI.getPath();
        int n = string.lastIndexOf("/");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private File getBaseDir(String string) {
        if (string.equals(GRADLE_USER_HOME_STRING)) {
            return this.gradleUserHome;
        }
        if (string.equals(PROJECT_STRING)) {
            return new File(System.getProperty("user.dir"));
        }
        throw new RuntimeException("Base: " + string + " is unknown");
    }

    public class LocalDistribution {
        private final File distZip;
        private final File distDir;

        public LocalDistribution(File file, File file2) {
            this.distDir = file;
            this.distZip = file2;
        }

        public File getDistributionDir() {
            return this.distDir;
        }

        public File getZipFile() {
            return this.distZip;
        }
    }
}

