/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import edu.sc.seis.seisFile.winston.TraceBuf2;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonTable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class WinstonUtil {
    Class driverClass = null;
    Connection conn;
    String databaseURL;
    String username;
    String password;
    String prefix = "W_";
    String driver = "com.mysql.jdbc.Driver";
    static boolean verbose = false;
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final long Y1970_TO_Y2000_SECONDS = 946728000L;

    public WinstonUtil(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, MYSQL_DRIVER);
    }

    public WinstonUtil(String string, String string2, String string3, String string4, String string5) {
        this.driver = string5;
        this.databaseURL = string;
        this.username = string2;
        this.password = string3;
        this.prefix = string4;
    }

    public WinstonSCNL createWinstonSCNL(String string, String string2, String string3, String string4) {
        return new WinstonSCNL(string, string2, string3, string4, this.prefix);
    }

    public WinstonTable createWinstonTable(WinstonSCNL winstonSCNL, int n, int n2, int n3) {
        return new WinstonTable(winstonSCNL, n, n2, n3);
    }

    public List<WinstonSCNL> listChannelDatabases() throws SQLException {
        ArrayList<WinstonSCNL> arrayList = new ArrayList<WinstonSCNL>();
        ResultSet resultSet = this.getConnection().createStatement().executeQuery("SHOW DATABASES");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            if (!string.startsWith(WinstonUtil.prefixTableName(this.getPrefix(), "")) || string.equals(WinstonUtil.prefixTableName(this.getPrefix(), "ROOT"))) continue;
            arrayList.add(new WinstonSCNL(string, this.getPrefix()));
        }
        return arrayList;
    }

    public void useDatabase(WinstonSCNL winstonSCNL) throws SQLException {
        this.getConnection().createStatement().execute("use " + winstonSCNL.getDatabaseName());
    }

    public List<WinstonTable> listDayTables(WinstonSCNL winstonSCNL) throws SQLException {
        ArrayList<WinstonTable> arrayList = new ArrayList<WinstonTable>();
        this.useDatabase(winstonSCNL);
        ResultSet resultSet = this.getConnection().createStatement().executeQuery("SHOW TABLES");
        while (resultSet.next()) {
            String string = resultSet.getString(1);
            if (string.contains("$$H")) continue;
            try {
                arrayList.add(new WinstonTable(winstonSCNL, string));
            }
            catch (ParseException parseException) {}
        }
        return arrayList;
    }

    public List<WinstonTable> listTablesBetweenDates(WinstonSCNL winstonSCNL, int n, int n2, int n3, int n4, int n5, int n6) throws SQLException {
        List<WinstonTable> list = this.listDayTables(winstonSCNL);
        Iterator<WinstonTable> iterator = list.iterator();
        while (iterator.hasNext()) {
            WinstonTable winstonTable = iterator.next();
            if (winstonTable.getYear() < n || winstonTable.getYear() > n4) {
                iterator.remove();
                continue;
            }
            if (winstonTable.getYear() == n && (winstonTable.getMonth() < n2 || winstonTable.getMonth() == n2 && winstonTable.getDay() < n3)) {
                iterator.remove();
                continue;
            }
            if (winstonTable.getYear() != n4 || winstonTable.getMonth() <= n5 && (winstonTable.getMonth() != n5 || winstonTable.getDay() <= n6)) continue;
            iterator.remove();
        }
        return list;
    }

    public SyncFile calculateSyncBetweenDates(WinstonSCNL winstonSCNL, int n, int n2, int n3, int n4, int n5, int n6, String string) throws SQLException {
        SyncFile syncFile = new SyncFile(string);
        List<WinstonTable> list = this.listTablesBetweenDates(winstonSCNL, n, n2, n3, n4, n5, n6);
        for (WinstonTable winstonTable : list) {
            syncFile = syncFile.concatenate(this.calculateSyncForDay(winstonTable));
        }
        return syncFile;
    }

    public void writeSyncBetweenDates(WinstonSCNL winstonSCNL, int n, int n2, int n3, int n4, int n5, int n6, SyncFileWriter syncFileWriter) throws SQLException {
        List<WinstonTable> list = this.listTablesBetweenDates(winstonSCNL, n, n2, n3, n4, n5, n6);
        for (WinstonTable winstonTable : list) {
            if (verbose) {
                System.out.println("Sync for " + winstonTable.getTableName());
            }
            syncFileWriter.appendAll(this.calculateSyncForDay(winstonTable), true);
        }
    }

    public SyncFile calculateSyncForDay(WinstonTable winstonTable) throws SQLException {
        SyncFile syncFile = new SyncFile("Winston " + winstonTable.getTableName());
        this.useDatabase(winstonTable.getDatabase());
        SyncLine syncLine = new SyncLine(winstonTable.getDatabase().getNetwork(), winstonTable.getDatabase().getStation(), winstonTable.getDatabase().getLocId(), winstonTable.getDatabase().getChannel());
        Statement statement = this.getConnection().createStatement(1003, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        ResultSet resultSet = statement.executeQuery("select st, et, sr from " + winstonTable.getTableName() + " order by st");
        while (resultSet.next()) {
            syncFile.addLine(new SyncLine(syncLine, WinstonUtil.j2KSecondsToDate(resultSet.getDouble(1)), WinstonUtil.j2KSecondsToDate(resultSet.getDouble(2)), Float.valueOf(resultSet.getFloat(3))), true);
        }
        resultSet.close();
        statement.close();
        return syncFile;
    }

    public List<TraceBuf2> extractData(WinstonSCNL winstonSCNL, Date date, Date date2) throws SQLException, DataFormatException {
        ArrayList<TraceBuf2> arrayList = new ArrayList<TraceBuf2>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(date);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        gregorianCalendar.setTime(date2);
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(2) + 1;
        int n6 = gregorianCalendar.get(5);
        List<WinstonTable> list = this.listTablesBetweenDates(winstonSCNL, n, n2, n3, n4, n5, n6);
        for (WinstonTable winstonTable : list) {
            arrayList.addAll(this.extractData(winstonTable, date, date2));
        }
        return arrayList;
    }

    public List<TraceBuf2> extractData(WinstonTable winstonTable, Date date, Date date2) throws SQLException, DataFormatException {
        this.useDatabase(winstonTable.getDatabase());
        ArrayList<TraceBuf2> arrayList = new ArrayList<TraceBuf2>();
        Statement statement = this.getConnection().createStatement(1003, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        double d = WinstonUtil.dateToJ2kSeconds(date);
        double d2 = WinstonUtil.dateToJ2kSeconds(date2);
        ResultSet resultSet = statement.executeQuery("select tracebuf from " + winstonTable.getTableName() + " where (" + d + " <= st AND st <= " + d2 + ") OR (" + d + " <=et AND et <= " + d2 + ") order by st");
        while (resultSet.next()) {
            Blob blob = resultSet.getBlob("tracebuf");
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[4096];
            int n = inflater.inflate(byArray2);
            if (!inflater.finished()) {
                throw new RuntimeException("more bytes in Blob than can fit in a TraceBuf2: 4096");
            }
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            arrayList.add(new TraceBuf2(byArray3));
        }
        resultSet.close();
        statement.close();
        return arrayList;
    }

    public static Date j2KSecondsToDate(double d) {
        return new Date((long)(1000.0 * (d + 9.46728E8)));
    }

    public static double dateToJ2kSeconds(Date date) {
        return date.getTime() / 1000L - 946728000L;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static String prefixTableName(String string, String string2) {
        return string + "_" + string2;
    }

    Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.createConnection();
        }
        return this.conn;
    }

    public void createConnection() throws SQLException {
        if (this.driverClass == null) {
            try {
                Class.forName(this.driver).newInstance();
            }
            catch (Exception exception) {
                SQLException sQLException = new SQLException("Cannot create driver: " + this.driver);
                sQLException.initCause(exception);
                throw sQLException;
            }
        }
        this.conn = DriverManager.getConnection(this.getDatabaseURL(), this.getUsername(), this.getPassword());
    }

    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }
}

