/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.winston.WinstonSCNL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class WinstonTable {
    WinstonSCNL database;
    int year;
    int month;
    int day;
    private static final SimpleDateFormat ymdFormat = new SimpleDateFormat("yyyy_MM_dd");

    protected WinstonTable(WinstonSCNL winstonSCNL, String string) throws ParseException {
        this.database = winstonSCNL;
        String[] stringArray = string.split("\\$\\$");
        if (stringArray[1].startsWith("H")) {
            stringArray[1] = stringArray[1].substring(1);
        }
        int[] nArray = this.parseDate(stringArray[1]);
        this.year = nArray[0];
        this.month = nArray[1] + 1;
        this.day = nArray[2];
    }

    protected WinstonTable(WinstonSCNL winstonSCNL, int n, int n2, int n3) {
        this.database = winstonSCNL;
        this.year = n;
        this.month = n2;
        this.day = n3;
    }

    public WinstonSCNL getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.internalGetTableName(false);
    }

    public String getHeliTableName() {
        return this.internalGetTableName(true);
    }

    protected String internalGetTableName(boolean bl) {
        String string = "" + this.getMonth();
        if (this.getMonth() < 10) {
            string = "0" + string;
        }
        String string2 = "" + this.getDay();
        if (this.getDay() < 10) {
            string2 = "0" + string2;
        }
        String string3 = bl ? "H" : "";
        return this.getDatabase().concatSCNL() + "$$" + string3 + this.getYear() + "_" + string + "_" + string2;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] parseDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = ymdFormat;
        synchronized (simpleDateFormat) {
            Date date = ymdFormat.parse(string);
            Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.setTime(date);
            int[] nArray = new int[3];
            nArray[0] = calendar.get(1);
            nArray[1] = calendar.get(2);
            nArray[2] = calendar.get(5);
            return nArray;
        }
    }
}

