/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.winston.WinstonUtil;

public class WinstonSCNL {
    static final String SEP = "$";
    String station;
    String channel;
    String network;
    String locId;
    String prefix;

    protected WinstonSCNL(String string, String string2) {
        this.prefix = string2;
        String string3 = string.substring(string2.length() + 1);
        String[] stringArray = string3.split("\\$");
        if (stringArray.length == 4) {
            this.locId = stringArray[3];
        } else {
            if (stringArray.length != 3) {
                throw new IllegalArgumentException("Invalid Winston database name: '" + string + "', must have 2 or 3 $'s");
            }
            this.locId = null;
        }
        this.station = stringArray[0];
        this.channel = stringArray[1];
        this.network = stringArray[2];
    }

    protected WinstonSCNL(String string, String string2, String string3, String string4, String string5) {
        this.station = string;
        this.channel = string2;
        this.network = string3;
        this.locId = string4;
        this.prefix = string5;
    }

    public String getDatabaseName() {
        return WinstonUtil.prefixTableName(this.prefix, this.concatSCNL());
    }

    public String concatSCNL() {
        return this.station + SEP + this.channel + SEP + this.network + (this.locId != null && this.locId.trim().length() != 0 ? SEP + this.locId : "");
    }

    public String getStation() {
        return this.station;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getLocId() {
        return this.locId;
    }
}

