/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.winston.TraceBuf2;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class WinstonClient {
    QueryParams params;
    Properties winstonConfig = new Properties();
    boolean doSync = false;
    int recordSize = 12;
    boolean doSteim1 = false;

    protected WinstonClient(String[] stringArray) throws SeisFileException, FileNotFoundException, IOException {
        this.params = new QueryParams(stringArray);
        this.winstonConfig.put("winston.driver", "com.mysql.jdbc.Driver");
        this.winstonConfig.put("winston.prefix", "W");
        this.winstonConfig.put("winston.url", "jdbc:mysql://localhost/?user=wwsuser");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--sync")) {
                this.doSync = true;
                continue;
            }
            if (stringArray[i].equals("--steim1")) {
                this.doSteim1 = true;
                continue;
            }
            if (i >= stringArray.length - 1) continue;
            if (stringArray[i].equals("-p")) {
                this.winstonConfig.load(new BufferedReader(new FileReader(stringArray[i + 1])));
                continue;
            }
            if (stringArray[i].equals("-u")) {
                this.winstonConfig.put("winston.url", stringArray[i + 1]);
                continue;
            }
            if (!stringArray[i].equals("--recLen")) continue;
            this.recordSize = Integer.parseInt(stringArray[i + 1]);
        }
        if (!this.doSync && this.params.getOutFile() == null) {
            this.params.setOutFile("output.mseed");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        WinstonClient winstonClient = new WinstonClient(stringArray);
        winstonClient.readData();
    }

    public void readData() throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        if (this.params.isPrintHelp()) {
            System.out.println(this.getHelp());
            return;
        }
        if (this.params.isPrintVersion()) {
            System.out.println("Version: " + BuildVersion.getDetailedVersion());
            return;
        }
        if (this.params.getNetwork() == null || this.params.getStation() == null || this.params.getChannel() == null) {
            System.out.println(BuildVersion.getDetailedVersion() + " one of scnl is null: n=" + this.params.getNetwork() + " s=" + this.params.getStation() + " l=" + this.params.getLocation() + " c=" + this.params.getChannel());
            System.out.println("LocId null is ok for scn, but needed for scnl");
            return;
        }
        if (this.params.isVerbose()) {
            WinstonUtil.setVerbose(true);
        }
        WinstonUtil winstonUtil = new WinstonUtil(this.getDbURL(), this.getUser(), this.getPassword(), this.winstonConfig.getProperty("winston.prefix"));
        List<WinstonSCNL> list = winstonUtil.listChannelDatabases();
        Pattern pattern = Pattern.compile("*".equals(this.params.getStation()) ? ".*" : this.params.getStation());
        Pattern pattern2 = Pattern.compile("*".equals(this.params.getChannel()) ? ".*" : this.params.getChannel());
        Pattern pattern3 = Pattern.compile("*".equals(this.params.getNetwork()) ? ".*" : this.params.getNetwork());
        Pattern pattern4 = Pattern.compile("*".equals(this.params.getLocation()) ? ".*" : this.params.getLocation());
        if (this.doSync) {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.params.getDataOutputStream())));
            SyncFileWriter syncFileWriter = new SyncFileWriter("winston", printWriter);
            for (WinstonSCNL winstonSCNL : list) {
                if (!pattern.matcher(winstonSCNL.getStation()).matches() || !pattern2.matcher(winstonSCNL.getChannel()).matches() || !pattern3.matcher(winstonSCNL.getNetwork()).matches() || !pattern4.matcher(winstonSCNL.getLocId()).matches()) continue;
                this.syncChannel(winstonUtil, winstonSCNL, syncFileWriter);
            }
            syncFileWriter.close();
        } else {
            for (WinstonSCNL winstonSCNL : list) {
                if (!pattern.matcher(winstonSCNL.getStation()).matches() || !pattern2.matcher(winstonSCNL.getChannel()).matches() || !pattern3.matcher(winstonSCNL.getNetwork()).matches() || !pattern4.matcher(winstonSCNL.getLocId()).matches()) continue;
                this.processChannel(winstonUtil, winstonSCNL);
            }
            this.params.getDataOutputStream().close();
        }
        winstonUtil.close();
    }

    void syncChannel(WinstonUtil winstonUtil, WinstonSCNL winstonSCNL, SyncFileWriter syncFileWriter) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(this.params.getBegin());
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        gregorianCalendar.setTime(this.params.getEnd());
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(2) + 1;
        int n6 = gregorianCalendar.get(5);
        winstonUtil.writeSyncBetweenDates(winstonSCNL, n, n2, n3, n4, n5, n6, syncFileWriter);
    }

    void processChannel(WinstonUtil winstonUtil, WinstonSCNL winstonSCNL) throws SeisFileException, SQLException, DataFormatException, FileNotFoundException, IOException, URISyntaxException {
        List<TraceBuf2> list = winstonUtil.extractData(winstonSCNL, this.params.getBegin(), this.params.getEnd());
        for (TraceBuf2 traceBuf2 : list) {
            DataRecord dataRecord = traceBuf2.toMiniSeed(this.recordSize, this.doSteim1);
            dataRecord.write(this.params.getDataOutputStream());
        }
    }

    String getDbURL() {
        return this.winstonConfig.getProperty("winston.url");
    }

    String getUser() throws URISyntaxException, SeisFileException {
        return this.getUrlQueryParam("user");
    }

    String getPassword() throws URISyntaxException, SeisFileException {
        return this.getUrlQueryParam("password");
    }

    String getUrlQueryParam(String string) throws SeisFileException, URISyntaxException {
        String[] stringArray = this.getDbURL().split("\\?")[1].split("\\&");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string + "=")) continue;
            return stringArray[i].substring((string + "=").length());
        }
        throw new SeisFileException("Unable to find '" + string + "' query param in database url: " + this.getDbURL());
    }

    public String getHelp() {
        return "java " + WinstonClient.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-p <winston.config file>][-u databaseURL][--sync][--steim1][--recLen len(8-12)]";
    }
}

