/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.Steim1;
import edu.iris.dmc.seedcodec.SteimException;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TraceBuf2 {
    int pin;
    int numSamples;
    double startTime;
    double endTime;
    double sampleRate;
    String station;
    String network;
    String channel;
    String locId;
    String version;
    String dataType;
    String quality;
    String pad;
    short[] shortData;
    int[] intData;
    float[] floatData;
    double[] doubleData;
    public static final String LOC_NULL_STRING = "--";
    public static final int MAX_TRACEBUF_SIZE = 4096;
    public static final int AMPLIFIER_SATURATED = 1;
    public static final int DIGITIZER_CLIPPED = 2;
    public static final int SPIKES_DETECTED = 4;
    public static final int GLITCHES_DETECTED = 8;
    public static final int MISSING_DATA_PRESENT = 16;
    public static final int TELEMETRY_SYNCH_ERROR = 32;
    public static final int FILTER_CHARGING = 64;
    public static final int TIME_TAG_QUESTIONABLE = 128;
    public static final String SUN_IEEE_SINGLE_PRECISION_REAL = "t4";
    public static final String SUN_IEEE_DOUBLE_PRECISION_REAL = "t8";
    public static final String SUN_IEEE_INTEGER = "s4";
    public static final String SUN_IEEE_SHORT_INTEGER = "s2";
    public static final String INTEL_IEEE_SINGLE_PRECISION_REAL = "f4";
    public static final String INTEL_IEEE_DOUBLE_PRECISION_REAL = "f8";
    public static final String INTEL_IEEE_INTEGER = "i4";
    public static final String INTEL_IEEE_SHORT_INTEGER = "i2";
    public static final String NORESS_GAIN_RANGED = "g2";

    public TraceBuf2(byte[] byArray) {
        this.dataType = TraceBuf2.extractDataType(byArray);
        boolean bl = TraceBuf2.isSwapBytes(this.dataType);
        this.pin = Utility.bytesToInt(byArray, 0, bl);
        this.numSamples = TraceBuf2.extractNumSamples(byArray, bl);
        this.startTime = Utility.bytesToDouble(byArray, 8, bl);
        this.endTime = Utility.bytesToDouble(byArray, 16, bl);
        this.sampleRate = Utility.bytesToDouble(byArray, 24, bl);
        this.station = Utility.extractNullTermString(byArray, 32, 7);
        this.network = Utility.extractNullTermString(byArray, 39, 9);
        this.channel = Utility.extractNullTermString(byArray, 48, 4);
        this.locId = Utility.extractNullTermString(byArray, 52, 3);
        this.version = Utility.extractString(byArray, 55, 2);
        this.dataType = Utility.extractNullTermString(byArray, 57, 3);
        this.quality = Utility.extractString(byArray, 60, 2);
        this.pad = Utility.extractString(byArray, 62, 2);
        int n = 64;
        if (this.isShortData()) {
            this.shortData = new short[this.numSamples];
            for (int i = 0; i < this.shortData.length; ++i) {
                this.shortData[i] = Utility.bytesToShort(byArray[n], byArray[n + 1], bl);
                n += 2;
            }
        } else if (this.isIntData()) {
            this.intData = new int[this.numSamples];
            for (int i = 0; i < this.intData.length; ++i) {
                this.intData[i] = Utility.bytesToInt(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], bl);
                n += 4;
            }
        } else if (this.isFloatData()) {
            this.floatData = new float[this.numSamples];
            for (int i = 0; i < this.floatData.length; ++i) {
                this.floatData[i] = Utility.bytesToFloat(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], bl);
                n += 4;
            }
        } else if (this.isDoubleData()) {
            this.doubleData = new double[this.numSamples];
            for (int i = 0; i < this.doubleData.length; ++i) {
                this.doubleData[i] = Utility.bytesToDouble(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7], bl);
                n += 8;
            }
        } else {
            if (this.dataType.equals(NORESS_GAIN_RANGED)) {
                throw new RuntimeException("NORESS gain-ranged data type not supported: " + this.dataType);
            }
            throw new RuntimeException("Unknown data type: " + this.dataType);
        }
    }

    public static int extractNumSamples(byte[] byArray, boolean bl) {
        return Utility.bytesToInt(byArray, 4, bl);
    }

    public static String extractDataType(byte[] byArray) {
        return Utility.extractNullTermString(byArray, 57, 3);
    }

    public static boolean isSwapBytes(String string) {
        return string.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || string.equals(INTEL_IEEE_INTEGER) || string.equals(INTEL_IEEE_SHORT_INTEGER) || string.equals(INTEL_IEEE_SINGLE_PRECISION_REAL);
    }

    public static int getSampleSize(String string) {
        if (TraceBuf2.isShortData(string)) {
            return 2;
        }
        if (TraceBuf2.isIntData(string) || TraceBuf2.isFloatData(string)) {
            return 4;
        }
        if (TraceBuf2.isDoubleData(string)) {
            return 8;
        }
        throw new RuntimeException("Unknown dataType: '" + string + "'");
    }

    public boolean isShortData() {
        return TraceBuf2.isShortData(this.dataType);
    }

    public boolean isIntData() {
        return TraceBuf2.isIntData(this.dataType);
    }

    public boolean isFloatData() {
        return TraceBuf2.isFloatData(this.dataType);
    }

    public boolean isDoubleData() {
        return TraceBuf2.isDoubleData(this.dataType);
    }

    public static boolean isShortData(String string) {
        return string.equals(INTEL_IEEE_SHORT_INTEGER) || string.equals(SUN_IEEE_SHORT_INTEGER);
    }

    public static boolean isIntData(String string) {
        return string.equals(INTEL_IEEE_INTEGER) || string.equals(SUN_IEEE_INTEGER);
    }

    public static boolean isFloatData(String string) {
        return string.equals(INTEL_IEEE_SINGLE_PRECISION_REAL) || string.equals(SUN_IEEE_SINGLE_PRECISION_REAL);
    }

    public static boolean isDoubleData(String string) {
        return string.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL) || string.equals(SUN_IEEE_DOUBLE_PRECISION_REAL);
    }

    public int getPin() {
        return this.pin;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public Date getStartDate() {
        return new Date(Math.round(this.getStartTime() * 1000.0));
    }

    public Date getEndDate() {
        return new Date(Math.round(this.getEndTime() * 1000.0));
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocId() {
        return this.locId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getPad() {
        return this.pad;
    }

    public short[] getShortData() {
        return this.shortData;
    }

    public int[] getIntData() {
        if (this.isIntData()) {
            return this.intData;
        }
        if (this.isShortData()) {
            int[] nArray = new int[this.shortData.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.shortData[i];
            }
            return nArray;
        }
        return null;
    }

    public float[] getFloatData() {
        if (this.isFloatData()) {
            return this.floatData;
        }
        if (this.isIntData()) {
            float[] fArray = new float[this.intData.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.intData[i];
            }
            return fArray;
        }
        if (this.isShortData()) {
            float[] fArray = new float[this.shortData.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = this.shortData[i];
            }
            return fArray;
        }
        return null;
    }

    public double[] getDoubleData() {
        if (this.isDoubleData()) {
            return this.doubleData;
        }
        if (this.isFloatData()) {
            double[] dArray = new double[this.floatData.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.floatData[i];
            }
            return dArray;
        }
        if (this.isIntData()) {
            double[] dArray = new double[this.intData.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.intData[i];
            }
            return dArray;
        }
        if (this.isShortData()) {
            double[] dArray = new double[this.shortData.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.shortData[i];
            }
            return dArray;
        }
        return null;
    }

    public byte getSeedEncoding() {
        if (this.dataType.equals(SUN_IEEE_INTEGER) || this.dataType.equals(INTEL_IEEE_INTEGER)) {
            return 3;
        }
        if (this.dataType.equals(SUN_IEEE_SHORT_INTEGER) || this.dataType.equals(INTEL_IEEE_SHORT_INTEGER)) {
            return 1;
        }
        if (this.dataType.equals(SUN_IEEE_SINGLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_SINGLE_PRECISION_REAL)) {
            return 4;
        }
        if (this.dataType.equals(SUN_IEEE_DOUBLE_PRECISION_REAL) || this.dataType.equals(INTEL_IEEE_DOUBLE_PRECISION_REAL)) {
            return 5;
        }
        throw new RuntimeException("Unknown dataType: " + this.dataType);
    }

    public DataRecord toMiniSeed() throws SeedFormatException {
        return this.toMiniSeed(12, false);
    }

    public DataRecord toMiniSeed(int n, boolean bl) throws SeedFormatException {
        DataHeader dataHeader = new DataHeader(0, 'D', false);
        dataHeader.setStationIdentifier(this.getStation());
        dataHeader.setChannelIdentifier(this.getChannel());
        dataHeader.setNetworkCode(this.getNetwork());
        String string = this.getLocId();
        if (string == null || string.equals(LOC_NULL_STRING)) {
            string = "  ";
        }
        dataHeader.setLocationIdentifier(string);
        dataHeader.setDataQualityFlags((byte)this.getQuality().charAt(0));
        dataHeader.setNumSamples((short)this.getNumSamples());
        dataHeader.setStartBtime(new Btime(this.getStartDate()));
        dataHeader.setSampleRate(this.getSampleRate());
        DataRecord dataRecord = new DataRecord(dataHeader);
        Blockette1000 blockette1000 = new Blockette1000();
        if (bl) {
            blockette1000.setEncodingFormat((byte)10);
        } else {
            blockette1000.setEncodingFormat(this.getSeedEncoding());
        }
        blockette1000.setDataRecordLength((byte)n);
        blockette1000.setWordOrder((byte)1);
        dataRecord.addBlockette(blockette1000);
        Codec codec = new Codec();
        byte[] byArray = new byte[]{};
        if (bl) {
            try {
                if (!this.isShortData() && !this.isIntData()) {
                    throw new SeedFormatException("Steim1 only applicable to integer data, not float or double: " + this.getDataType());
                }
                byArray = Steim1.encode((int[])this.getIntData(), (int)((1 << n) / 64 - 1)).getEncodedData();
            }
            catch (SteimException steimException) {
                throw new SeedFormatException(steimException);
            }
            catch (IOException iOException) {
                throw new SeedFormatException(iOException);
            }
        } else if (this.isShortData()) {
            byArray = codec.encodeAsBytes(this.getShortData());
        } else if (this.isIntData()) {
            byArray = codec.encodeAsBytes(this.getIntData());
        } else if (this.isFloatData()) {
            byArray = codec.encodeAsBytes(this.getFloatData());
        } else if (this.isDoubleData()) {
            byArray = codec.encodeAsBytes(this.getDoubleData());
        }
        if ((double)(dataHeader.getSize() + blockette1000.getSize() + byArray.length) > Math.pow(2.0, n)) {
            throw new SeedFormatException("Cannot fit data into record lenght of " + n + "(" + Math.pow(2.0, n) + "). header=" + (dataHeader.getSize() + blockette1000.getSize()) + " data=" + byArray.length);
        }
        dataRecord.setData(byArray);
        return dataRecord;
    }

    public int getSize() {
        return 64 + this.getNumSamples() * TraceBuf2.getSampleSize(this.getDataType());
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.getPin() + " " + this.network + "." + this.station + "." + this.locId + "." + this.channel + " " + simpleDateFormat.format(this.getStartDate()) + "(" + this.getStartTime() + ") to " + simpleDateFormat.format(this.getEndDate()) + "(" + this.getEndTime() + ") sr=" + this.getSampleRate() + "  npts=" + this.numSamples + " datetype=" + this.getDataType() + " ver=" + this.getVersion();
    }

    public String toStringWithData() {
        String string = this.toString() + "\n";
        if (this.isShortData() || this.isIntData()) {
            int[] nArray = this.getIntData();
            for (int i = 0; i < nArray.length; ++i) {
                string = string + nArray[i] + " ";
                if (i % 8 != 7) continue;
                string = string + "\n";
            }
        } else {
            double[] dArray = this.getDoubleData();
            for (int i = 0; i < dArray.length; ++i) {
                string = string + dArray[i] + " ";
                if (i % 8 != 7) continue;
                string = string + "\n";
            }
        }
        return string;
    }
}

