/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import edu.sc.seis.seisFile.BuildVersion;
import edu.sc.seis.seisFile.MSeedQueryClient;
import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.waveserver.WaveServer;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class WaveServerClient
extends MSeedQueryClient {
    String host = "eeyore.seis.sc.edu";
    int port = 16022;
    int recordSize = 12;
    boolean doSteim1 = false;
    boolean doMenu = false;

    public WaveServerClient(String[] stringArray) throws SeisFileException {
        super(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--steim1")) {
                this.doSteim1 = true;
                continue;
            }
            if (stringArray[i].equals("--menu")) {
                this.doMenu = true;
                continue;
            }
            if (i >= stringArray.length - 1) continue;
            if (stringArray[i].equals("--recLen")) {
                this.recordSize = Integer.parseInt(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].equals("-h")) {
                this.host = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].equals("-p")) continue;
            this.port = Integer.parseInt(stringArray[i + 1]);
        }
        if (this.params.getOutFile() == null) {
            this.params.setOutFile("output.mseed");
        }
        this.reader = new WaveServer(this.host, this.port);
        ((WaveServer)this.reader).setDoSteim1(this.doSteim1);
        ((WaveServer)this.reader).setRecordSize(this.recordSize);
    }

    public static void main(String[] stringArray) throws Exception {
        WaveServerClient waveServerClient = new WaveServerClient(stringArray);
        waveServerClient.readData();
    }

    @Override
    public void readData() throws IOException, SeisFileException {
        if (!(this.doMenu || this.params.getNetwork() != null && this.params.getStation() != null && this.params.getChannel() != null)) {
            System.out.println(BuildVersion.getDetailedVersion() + " one of scnl is null: n=" + this.params.getNetwork() + " s=" + this.params.getStation() + " l=" + this.params.getLocation() + " c=" + this.params.getChannel());
            System.out.println("LocId null is ok for scn, but needed for scnl");
            return;
        }
        WaveServer waveServer = new WaveServer(this.host, this.port);
        if (this.params.isVerbose()) {
            waveServer.setVerbose(this.params.isVerbose());
        }
        if (this.doMenu) {
            List<MenuItem> list = waveServer.getMenu();
            Date date = new Date();
            for (MenuItem menuItem : list) {
                long l = (date.getTime() - menuItem.getEndDate().getTime()) / 1000L;
                System.out.println(menuItem + "  " + l + " sec");
            }
        } else {
            super.readData();
        }
    }

    @Override
    public String getHelp() {
        return "java " + WaveServerClient.class.getName() + " " + QueryParams.getStandardHelpOptions() + "[-h host][-p port][--menu][--steim1][--recLen len(8-12)]";
    }
}

