/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import edu.sc.seis.seisFile.MSeedQueryReader;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.waveserver.MenuItem;
import edu.sc.seis.seisFile.winston.TraceBuf2;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WaveServer
implements MSeedQueryReader {
    int reqId = 1;
    String host;
    int port;
    int recordSize = 12;
    boolean doSteim1 = false;
    Socket socket;
    PrintWriter out;
    DataInputStream in;
    int timeoutSeconds = 60;
    public static final int DEFAULT_TIMEOUT_SECONDS = 60;
    boolean verbose = false;

    WaveServer(PrintWriter printWriter, DataInputStream dataInputStream) {
        this.out = printWriter;
        this.in = dataInputStream;
    }

    public WaveServer(String string, int n) {
        this(string, n, 60);
    }

    public WaveServer(String string, int n, int n2) {
        this.host = string;
        this.port = n;
        this.timeoutSeconds = n2;
    }

    public List<MenuItem> getMenu() throws IOException {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        String string = this.getNextRequestId();
        PrintWriter printWriter = this.getOut();
        printWriter.println("MENU: " + string + " SCNL");
        String string2 = this.getIn().readLine();
        String[] stringArray = string2.split("  ");
        String string3 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(" +");
            String string4 = stringArray2[0];
            String string5 = stringArray2[1];
            String string6 = stringArray2[2];
            String string7 = stringArray2[3];
            String string8 = "";
            int n = 0;
            if (stringArray2.length == 8) {
                string8 = stringArray2[4];
                n = 1;
            }
            String string9 = stringArray2[n + 4];
            String string10 = stringArray2[n + 5];
            String string11 = stringArray2[n + 6];
            MenuItem menuItem = new MenuItem(string7, string5, string8, string6, Double.parseDouble(string9), Double.parseDouble(string10), Integer.parseInt(string4), string11);
            arrayList.add(menuItem);
        }
        return arrayList;
    }

    public List<TraceBuf2> getTraceBuf(String string, String string2, String string3, String string4, Date date, Date date2) throws IOException {
        ArrayList<TraceBuf2> arrayList = new ArrayList<TraceBuf2>();
        String string5 = this.getNextRequestId();
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        String string6 = "GETSCNLRAW: " + string5 + " " + string2 + " " + string4 + " " + string + " " + (string3 == null ? "--" : string3) + " " + decimalFormat.format((double)date.getTime() / 1000.0) + " " + decimalFormat.format((double)date2.getTime() / 1000.0);
        if (this.isVerbose()) {
            System.out.println("send cmd: " + string6);
        }
        PrintWriter printWriter = this.getOut();
        printWriter.println(string6);
        printWriter.flush();
        this.getIn().mark(64);
        DataInputStream dataInputStream = this.getIn();
        for (int i = 0; dataInputStream.available() > 0 && i < 64; ++i) {
            System.out.print((char)dataInputStream.read());
        }
        this.in.reset();
        String string7 = dataInputStream.readLine();
        if (this.isVerbose()) {
            System.out.println("response: " + string7);
        }
        String[] stringArray = string7.split(" ");
        int n = 10;
        if ("F".equals(stringArray[6])) {
            int n2 = Integer.parseInt(stringArray[n]);
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if (this.verbose) {
                    System.out.println("Read next traceBuf2: " + n4 + "<" + n2);
                }
                byte[] byArray = new byte[64];
                this.in.readFully(byArray);
                String string8 = TraceBuf2.extractDataType(byArray);
                boolean bl = TraceBuf2.isSwapBytes(string8);
                int n5 = TraceBuf2.extractNumSamples(byArray, bl);
                n3 += n5;
                int n6 = TraceBuf2.getSampleSize(string8);
                byte[] byArray2 = new byte[n5 * n6];
                dataInputStream.readFully(byArray2);
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                TraceBuf2 traceBuf2 = new TraceBuf2(byArray3);
                n4 += traceBuf2.getSize();
                if (this.isVerbose()) {
                    System.out.println("TraceBuf received: " + traceBuf2);
                }
                arrayList.add(traceBuf2);
            }
        }
        return arrayList;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected Socket getSocket() throws IOException {
        if (this.socket == null && this.host != null) {
            this.socket = new Socket(this.getHost(), this.getPort());
            this.socket.setSoTimeout(this.timeoutSeconds * 1000);
        }
        return this.socket;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public void setRecordSize(int n) {
        this.recordSize = n;
    }

    public boolean isDoSteim1() {
        return this.doSteim1;
    }

    public void setDoSteim1(boolean bl) {
        this.doSteim1 = bl;
    }

    public PrintWriter getOut() throws IOException {
        if (this.out == null && this.getSocket() != null) {
            this.out = new PrintWriter(this.getSocket().getOutputStream(), true);
        }
        return this.out;
    }

    public DataInputStream getIn() throws IOException {
        if (this.in == null && this.getSocket() != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.getSocket().getInputStream()));
        }
        return this.in;
    }

    public static int getDefaultTimeoutSeconds() {
        return 60;
    }

    @Override
    public List<DataRecord> read(String string, String string2, String string3, String string4, Date date, Date date2) throws IOException, DataSelectException, SeedFormatException {
        ArrayList<DataRecord> arrayList = new ArrayList<DataRecord>();
        List<TraceBuf2> list = this.getTraceBuf(string, string2, string3, string4, date, date2);
        for (TraceBuf2 traceBuf2 : list) {
            if (this.verbose) {
                System.out.println("tracebuf2 " + traceBuf2.getNetwork() + "." + traceBuf2.getStation() + "." + traceBuf2.getLocId() + "." + traceBuf2.getChannel() + " " + traceBuf2.getStartDate() + " " + traceBuf2.getNumSamples());
            }
            DataRecord dataRecord = traceBuf2.toMiniSeed(this.recordSize, this.doSteim1);
            arrayList.add(dataRecord);
        }
        return arrayList;
    }

    String getNextRequestId() {
        return "" + this.reqId++;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }
}

