/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MenuItem {
    String station;
    String network;
    String channel;
    String location;
    double start;
    double end;
    int pin;
    String dataType;

    public MenuItem(String string, String string2, String string3, String string4, double d, double d2, int n, String string5) {
        this.station = string2;
        this.network = string;
        this.channel = string4;
        this.location = string3;
        if ("--".equals(string3)) {
            this.location = "  ";
        }
        this.start = d;
        this.end = d2;
        this.pin = n;
        this.dataType = string5;
    }

    public String toString() {
        return this.network + " " + this.station + " " + this.location + " " + this.channel + " " + MenuItem.formatDate(MenuItem.toDate(this.start)) + " " + MenuItem.formatDate(MenuItem.toDate(this.end));
    }

    public static Date toDate(double d) {
        return new Date(Math.round(1000.0 * d));
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocation() {
        return this.location;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public Date getStartDate() {
        return MenuItem.toDate(this.start);
    }

    public Date getEndDate() {
        return MenuItem.toDate(this.end);
    }

    public int getPin() {
        return this.pin;
    }

    public String getDataType() {
        return this.dataType;
    }
}

