/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.usgsCWB;

import edu.sc.seis.seisFile.StringMSeedQueryReader;
import edu.sc.seis.seisFile.dataSelectWS.DataSelectException;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class CWBReader
extends StringMSeedQueryReader {
    private String host;
    private int port;
    public static final String DEFAULT_HOST = "cwb-pub.cr.usgs.gov";
    public static final int DEFAULT_PORT = 2061;

    public CWBReader() {
        this(DEFAULT_HOST);
    }

    public CWBReader(String string) {
        this(string, 2061);
    }

    public CWBReader(String string, int n) {
        this.host = string;
        this.port = n;
    }

    protected String createQuery(String string, String string2, String string3, String string4) throws IOException, DataSelectException, SeedFormatException {
        String string5 = this.leftPad(string.trim(), 2);
        string5 = string5 + this.leftPad(string2.trim(), 5);
        string5 = string5 + this.leftPad(string4.trim(), 3);
        string5 = string5 + this.leftPad(string3.trim(), 2);
        return string5;
    }

    @Override
    public String createQuery(String string, String string2, String string3, String string4, Date date, Date date2) throws IOException, DataSelectException, SeedFormatException {
        String string5 = "'-s' '" + this.createQuery(string, string2, string3, string4) + "' ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        string5 = string5 + "'-b' '" + simpleDateFormat.format(date) + "' ";
        string5 = string5 + "'-d' '" + (int)Math.ceil((float)(date2.getTime() - date.getTime()) / 1000.0f) + "' ";
        string5 = string5 + "'-t' 'ms'";
        string5 = string5 + "\t";
        return string5;
    }

    @Override
    public List<DataRecord> read(String string) throws IOException, DataSelectException, SeedFormatException {
        Socket socket = new Socket(this.host, this.port);
        socket.setReceiveBufferSize(512000);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(string.getBytes());
        outputStream.flush();
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(socket.getInputStream()), 1);
        DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
        ArrayList<DataRecord> arrayList = new ArrayList<DataRecord>();
        try {
            int n;
            while ((n = pushbackInputStream.read()) != 60) {
                pushbackInputStream.unread(n);
                SeedRecord seedRecord = SeedRecord.read(dataInputStream);
                if (seedRecord instanceof DataRecord) {
                    arrayList.add((DataRecord)seedRecord);
                    continue;
                }
                System.err.println("None data record found, skipping...");
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dataInputStream.close();
        outputStream.close();
        socket.close();
        return arrayList;
    }

    protected String leftPad(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        return this.leftPad(string + "-", n);
    }
}

