/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SyncLine
implements Comparable<SyncLine> {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy,DDD,HH:mm:ss");
    private static final DateFormat dateFormatFracSeconds = new SimpleDateFormat("yyyy,DDD,HH:mm:ss.SSS");
    private static final DateFormat dayOnlyDateFormat = new SimpleDateFormat("yyyy,DDD");
    String net;
    String sta;
    String loc;
    String chan;
    Date startTime;
    Date endTime;
    Float maxClockDrift;
    Float samplesPerSecond;
    String channelFlag;
    String stationVolume;
    String dccTapeNumber;
    String dmcTabpNumber;
    String comment;
    Date lineModByDMC;
    Date lineModByDCC;

    public static SyncLine parse(String string) throws SeisFileException {
        try {
            String[] stringArray = string.split("\\|", -1);
            SyncLine syncLine = new SyncLine(stringArray[0], stringArray[1], stringArray[2], stringArray[3], SyncLine.stringToDate(stringArray[4]), SyncLine.stringToDate(stringArray[5]), SyncLine.stringToFloat(stringArray[6]), SyncLine.stringToFloat(stringArray[7]), stringArray[8], stringArray[9], stringArray[10], stringArray[11], stringArray[12], SyncLine.stringToDate(stringArray[13]), SyncLine.stringToDate(stringArray[14]));
            if (syncLine.getStartTime().after(syncLine.getEndTime())) {
                throw new SeisFileException("Start is after End: " + stringArray[4] + " " + stringArray[5]);
            }
            return syncLine;
        }
        catch (Exception exception) {
            throw new SeisFileException("Trouble parsing line: " + string, exception);
        }
    }

    public SyncLine(SyncLine syncLine, Date date, Date date2, Float f) {
        this(syncLine, date, date2);
        this.samplesPerSecond = f;
    }

    public SyncLine(SyncLine syncLine, Date date, Date date2) {
        this(syncLine.net, syncLine.sta, syncLine.loc, syncLine.chan, date, date2, syncLine.maxClockDrift, syncLine.samplesPerSecond, syncLine.channelFlag, syncLine.stationVolume, syncLine.dccTapeNumber, syncLine.dmcTabpNumber, syncLine.comment, syncLine.lineModByDMC, syncLine.lineModByDCC);
    }

    public SyncLine(String string, String string2, String string3, String string4, Date date, Date date2, Float f, Float f2) {
        this(string, string2, string3, string4, date, date2, f, f2, "", "", "", "", "", null, null);
    }

    public SyncLine(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null, null, null, null);
    }

    public SyncLine(String string, String string2, String string3, String string4, Date date, Date date2, Float f, Float f2, String string5, String string6, String string7, String string8, String string9, Date date3, Date date4) {
        this.net = string;
        this.sta = string2;
        this.loc = string3;
        this.chan = string4;
        this.startTime = date;
        this.endTime = date2;
        this.maxClockDrift = f;
        this.samplesPerSecond = f2;
        this.channelFlag = string5;
        this.stationVolume = string6;
        this.dccTapeNumber = string7;
        this.dmcTabpNumber = string8;
        this.comment = string9;
        this.lineModByDMC = date3;
        this.lineModByDCC = date4;
    }

    public String toString() {
        return this.formatLine();
    }

    public String formatLine() {
        return SyncLine.concatWithSeparator(new String[]{this.net, this.sta, this.loc, this.chan, SyncLine.dateToString(this.startTime), SyncLine.dateToString(this.endTime), this.maxClockDrift == null ? "" : "" + this.maxClockDrift, this.samplesPerSecond == null ? "" : "" + this.samplesPerSecond, this.channelFlag, this.stationVolume, this.dccTapeNumber, this.dmcTabpNumber, this.comment, SyncLine.dateToString(this.lineModByDMC), SyncLine.dateToString(this.lineModByDCC)}, "|");
    }

    public boolean isContiguous(SyncLine syncLine, float f) {
        return this.net.equals(syncLine.net) && this.sta.equals(syncLine.sta) && (this.loc == null && syncLine.loc == null || this.loc != null && this.loc.equals(syncLine.loc)) && this.chan.equals(syncLine.chan) && Math.abs((double)(syncLine.startTime.getTime() - this.endTime.getTime()) / 1000.0) <= (double)f;
    }

    public SyncLine concat(SyncLine syncLine) {
        return new SyncLine(this, this.startTime, syncLine.endTime);
    }

    @Override
    public int compareTo(SyncLine syncLine) {
        int n = this.getNet().compareToIgnoreCase(syncLine.getNet());
        if (n != 0) {
            return n;
        }
        n = this.getSta().compareToIgnoreCase(syncLine.getSta());
        if (n != 0) {
            return n;
        }
        n = this.getLoc().compareToIgnoreCase(syncLine.getLoc());
        if (n != 0) {
            return n;
        }
        n = this.getChan().compareToIgnoreCase(syncLine.getChan());
        if (n != 0) {
            return n;
        }
        n = this.getStartTime().compareTo(syncLine.getStartTime());
        if (n != 0) {
            return n;
        }
        return this.getEndTime().compareTo(syncLine.getEndTime());
    }

    public SyncLine[] split(Date date) {
        if (date.before(this.getStartTime()) || date.after(this.getEndTime())) {
            return new SyncLine[]{this};
        }
        return new SyncLine[]{new SyncLine(this, this.getStartTime(), date), new SyncLine(this, date, this.getEndTime())};
    }

    public static String concatWithSeparator(String[] stringArray, String string) {
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + string;
            if (stringArray[i] == null) continue;
            string2 = string2 + stringArray[i].trim();
        }
        return string2;
    }

    public static Float stringToFloat(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.length() == 8) {
            DateFormat dateFormat = dayOnlyDateFormat;
            synchronized (dateFormat) {
                return dayOnlyDateFormat.parse(string);
            }
        }
        if (string.length() > 17) {
            DateFormat dateFormat = dateFormatFracSeconds;
            synchronized (dateFormat) {
                return dateFormatFracSeconds.parse(string);
            }
        }
        DateFormat dateFormat = SyncLine.dateFormat;
        synchronized (dateFormat) {
            return SyncLine.dateFormat.parse(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        DateFormat dateFormat = dateFormatFracSeconds;
        synchronized (dateFormat) {
            return dateFormatFracSeconds.format(date);
        }
    }

    public String getNet() {
        return this.net;
    }

    public String getSta() {
        return this.sta;
    }

    public String getLoc() {
        return this.loc;
    }

    public String getChan() {
        return this.chan;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Float getMaxClockDrift() {
        return this.maxClockDrift;
    }

    public Float getSamplesPerSecond() {
        return this.samplesPerSecond;
    }

    public String getChannelFlag() {
        return this.channelFlag;
    }

    public String getStationVolume() {
        return this.stationVolume;
    }

    public String getDccTapeNumber() {
        return this.dccTapeNumber;
    }

    public String getDmcTabpNumber() {
        return this.dmcTabpNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getLineModByDMC() {
        return this.lineModByDMC;
    }

    public Date getLineModByDCC() {
        return this.lineModByDCC;
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormatFracSeconds.setTimeZone(TimeZone.getTimeZone("GMT"));
        dayOnlyDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

