/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;

public class SyncFileWriter {
    SyncLine previous = null;
    String dccName;
    String dateModified;
    String[] extraHeaders;
    protected PrintWriter writer;

    public SyncFileWriter(String string, String string2) throws IOException {
        this(string, new PrintWriter(new BufferedWriter(new FileWriter(string2))));
    }

    public SyncFileWriter(String string, PrintWriter printWriter) {
        this(string, SyncLine.dateToString(new Date()), new String[0], printWriter);
    }

    public SyncFileWriter(String string, String string2, PrintWriter printWriter) {
        this(string, string2, new String[0], printWriter);
    }

    public SyncFileWriter(String string, String string2, String[] stringArray, PrintWriter printWriter) {
        this.dccName = string;
        this.dateModified = string2;
        this.extraHeaders = stringArray;
        this.writer = printWriter;
        printWriter.println(new SyncFile(string, string2, stringArray).getHeaderLine());
    }

    public void appendAll(SyncFile syncFile) {
        this.appendAll(syncFile, true);
    }

    public void appendAll(SyncFile syncFile, boolean bl) {
        for (SyncLine syncLine : syncFile.getSyncLines()) {
            this.appendLine(syncLine, bl);
        }
    }

    public void appendLine(SyncLine syncLine) {
        this.appendLine(syncLine, true);
    }

    public void appendLine(SyncLine syncLine, boolean bl) {
        if (bl) {
            if (this.previous == null) {
                this.previous = syncLine;
            } else if (this.previous.isContiguous(syncLine, 0.01f)) {
                this.previous = this.previous.concat(syncLine);
            } else {
                this.writer.println(this.previous.formatLine());
                this.previous = syncLine;
            }
        } else {
            this.writer.println(syncLine.formatLine());
        }
    }

    public void close() {
        if (this.writer != null) {
            this.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    public void flush() {
        if (this.writer != null) {
            if (this.previous != null) {
                this.writer.println(this.previous.formatLine());
                this.previous = null;
            }
            this.writer.flush();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

