/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.SeisFileRuntimeException;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SyncFileReader
implements Iterator<SyncLine> {
    BufferedReader in;
    String header;
    SyncLine nextLine;

    public SyncFileReader(String string) throws IOException {
        this(new File(string));
    }

    public SyncFileReader(File file) throws IOException {
        this(new BufferedReader(new FileReader(file)));
    }

    public SyncFileReader(BufferedReader bufferedReader) throws IOException {
        this.in = bufferedReader;
        this.header = bufferedReader.readLine();
    }

    void loadNext() throws SeisFileRuntimeException {
        block6: {
            try {
                if (this.nextLine != null || this.in == null) break block6;
                String string = this.in.readLine();
                if (string != null) {
                    this.nextLine = SyncLine.parse(string);
                    break block6;
                }
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.in = null;
            }
            catch (SeisFileException seisFileException) {
                throw new SeisFileRuntimeException(seisFileException);
            }
            catch (IOException iOException) {
                throw new SeisFileRuntimeException("Unable to read next line.", iOException);
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this.nextLine == null;
    }

    @Override
    public SyncLine next() {
        if (this.hasNext()) {
            SyncLine syncLine = this.nextLine;
            this.nextLine = null;
            return syncLine;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }
}

