/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.syncFile.GMTSyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SyncFileCompare {
    Date earliest;
    Date latest;
    SyncFile a;
    SyncFile b;
    SyncFile inAinB;
    SyncFile notAinB;
    SyncFile inAnotB;
    boolean verbose = false;

    public SyncFileCompare(SyncFile syncFile, SyncFile syncFile2) {
        this.a = syncFile;
        this.b = syncFile2;
        this.process();
    }

    void process() {
        Object object;
        String string = SyncLine.dateToString(new Date());
        if (!this.a.isEmpty()) {
            this.earliest = this.a.getEarliest();
            this.latest = this.a.getLatest();
        }
        if (!this.b.isEmpty()) {
            object = this.b.getEarliest();
            if (this.earliest == null || ((Date)object).before(this.earliest)) {
                this.earliest = object;
            }
            object = this.b.getLatest();
            if (this.latest == null || ((Date)object).after(this.latest)) {
                this.latest = object;
            }
        }
        this.inAinB = new SyncFile(this.a.dccName + " " + this.b.getDccName(), string, new String[]{"sync compare inAinB"});
        this.notAinB = new SyncFile("not " + this.a.dccName + " in " + this.b.getDccName(), string, new String[]{"sync compare notAinB"});
        this.inAnotB = new SyncFile("in " + this.a.dccName + " not " + this.b.getDccName(), string, new String[]{"sync compare inAnotB"});
        object = this.a.getSyncLines();
        Collections.sort(object);
        List<SyncLine> list = this.b.getSyncLines();
        Collections.sort(list);
        Iterator<SyncLine> iterator = list.iterator();
        Iterator iterator2 = object.iterator();
        SyncLine[] syncLineArray = new SyncLine[]{null, null};
        while (syncLineArray[0] != null || syncLineArray[1] != null || iterator2.hasNext() || iterator.hasNext()) {
            if (syncLineArray[0] == null && iterator2.hasNext()) {
                syncLineArray[0] = (SyncLine)iterator2.next();
            }
            if (syncLineArray[1] == null && iterator.hasNext()) {
                syncLineArray[1] = iterator.next();
            }
            syncLineArray = SyncFileCompare.processItem(syncLineArray[0], syncLineArray[1], this.inAinB, this.notAinB, this.inAnotB);
        }
    }

    static SyncLine[] processItem(SyncLine syncLine, SyncLine syncLine2, SyncFile syncFile, SyncFile syncFile2, SyncFile syncFile3) {
        if (syncLine != null && syncLine2 != null) {
            if (syncLine.getEndTime().before(syncLine2.getStartTime())) {
                syncFile3.addLine(syncLine, true);
                syncLine = null;
            } else if (syncLine2.getEndTime().before(syncLine.getStartTime())) {
                syncFile2.addLine(syncLine2, true);
                syncLine2 = null;
            } else if (syncLine.getStartTime().equals(syncLine2.getStartTime()) && syncLine.getEndTime().equals(syncLine2.getEndTime())) {
                syncFile.addLine(syncLine);
                syncLine = null;
                syncLine2 = null;
            } else if (syncLine.getStartTime().equals(syncLine2.getStartTime())) {
                if (syncLine.getEndTime().before(syncLine2.getEndTime())) {
                    syncFile.addLine(syncLine);
                    syncLine2 = syncLine2.split(syncLine.getEndTime())[1];
                    syncLine = null;
                } else {
                    syncFile.addLine(syncLine2);
                    syncLine = syncLine.split(syncLine2.getEndTime())[1];
                    syncLine2 = null;
                }
            } else if (syncLine.getStartTime().before(syncLine2.getStartTime())) {
                SyncLine[] syncLineArray = syncLine.split(syncLine2.getStartTime());
                syncFile3.addLine(syncLineArray[0]);
                if (syncLineArray.length != 1) {
                    return SyncFileCompare.processItem(syncLineArray[1], syncLine2, syncFile, syncFile2, syncFile3);
                }
            } else if (syncLine2.getStartTime().before(syncLine.getStartTime())) {
                SyncLine[] syncLineArray = syncLine2.split(syncLine.getStartTime());
                syncFile2.addLine(syncLineArray[0]);
                if (syncLineArray.length != 1) {
                    return SyncFileCompare.processItem(syncLine, syncLineArray[1], syncFile, syncFile2, syncFile3);
                }
            }
        } else if (syncLine != null) {
            syncFile3.addLine(syncLine);
            syncLine = null;
        } else if (syncLine2 != null) {
            syncFile2.addLine(syncLine2);
            syncLine2 = null;
        }
        return new SyncLine[]{syncLine, syncLine2};
    }

    public SyncFile getA() {
        return this.a;
    }

    public SyncFile getB() {
        return this.b;
    }

    public SyncFile getInAinB() {
        return this.inAinB;
    }

    public SyncFile getNotAinB() {
        return this.notAinB;
    }

    public SyncFile getInAnotB() {
        return this.inAnotB;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public Date getEarliest() {
        return this.earliest;
    }

    public Date getLatest() {
        return this.latest;
    }

    static void printUsage() {
        System.err.println("Usage: syncFileCompare [--gmt] -a file1.sync -b file2.sync");
    }

    static String trimDotSync(String string) {
        String string2 = new File(string).getAbsoluteFile().getName();
        if (string2.endsWith(".sync")) {
            string2 = string2.substring(0, string2.lastIndexOf(".sync"));
        }
        return string2;
    }

    static Date earliest(Date date, SyncFile syncFile) {
        if (!syncFile.isEmpty()) {
            Date date2 = syncFile.getEarliest();
            if (date == null || date2.before(date)) {
                date = date2;
            }
        }
        return date;
    }

    static Date latest(Date date, SyncFile syncFile) {
        if (!syncFile.isEmpty()) {
            Date date2 = syncFile.getLatest();
            if (date == null || date2.after(date)) {
                date = date2;
            }
        }
        return date;
    }

    public static Date[] range(Collection<SyncFile> collection) {
        Date date = null;
        Date date2 = null;
        for (SyncFile syncFile : collection) {
            date = SyncFileCompare.earliest(date, syncFile);
            date2 = SyncFileCompare.latest(date2, syncFile);
        }
        return new Date[]{date, date2};
    }

    public static void main(String[] stringArray) throws IOException, SeisFileException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        String string = "";
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if ("--help".equals(stringArray[i])) {
                SyncFileCompare.printUsage();
                return;
            }
            if ("--gmt".equals(stringArray[i])) {
                bl = true;
                continue;
            }
            if ("-a".equals(stringArray[i])) {
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-b".equals(stringArray[i])) {
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            System.err.println("I don't understand '" + stringArray[i] + "'");
            SyncFileCompare.printUsage();
            return;
        }
        if (string.length() == 0 || string2.length() == 0) {
            System.err.println("Both a and b filenames are required: '" + string + "' '" + string2 + "'");
            SyncFileCompare.printUsage();
            return;
        }
        String string3 = SyncFileCompare.trimDotSync(string);
        String string4 = SyncFileCompare.trimDotSync(string2);
        SyncFile syncFile = SyncFile.load(new File(string));
        SyncFile syncFile2 = SyncFile.load(new File(string2));
        HashMap<String, SyncFile> hashMap = syncFile.splitByChannel();
        HashMap<String, SyncFile> hashMap2 = syncFile2.splitByChannel();
        HashSet<String> hashSet = new HashSet<String>(hashMap.keySet());
        hashSet.addAll(hashMap2.keySet());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        Date[] dateArray = SyncFileCompare.range(hashMap.values());
        Date[] dateArray2 = SyncFileCompare.range(hashMap2.values());
        Date date = dateArray[0].before(dateArray2[0]) ? dateArray[0] : dateArray2[0];
        Date date2 = dateArray[1].after(dateArray2[1]) ? dateArray[1] : dateArray2[1];
        for (String string5 : arrayList) {
            object4 = "";
            if (hashSet.size() != 1) {
                object4 = string5 + "_";
            }
            if ((object3 = hashMap.get(string5)) == null) {
                object3 = new SyncFile(syncFile.dccName);
            }
            if ((object2 = hashMap2.get(string5)) == null) {
                object2 = new SyncFile(syncFile2.dccName);
            }
            date = SyncFileCompare.earliest(date, (SyncFile)object3);
            date = SyncFileCompare.earliest(date, (SyncFile)object2);
            date2 = SyncFileCompare.latest(date2, (SyncFile)object3);
            date2 = SyncFileCompare.latest(date2, (SyncFile)object2);
            object = new SyncFileCompare((SyncFile)object3, (SyncFile)object2);
            hashMap3.put(string5, object);
            ((SyncFileCompare)object).getInAinB().saveToFile((String)object4 + "in_" + string3 + "_in_" + string4 + ".sync");
            ((SyncFileCompare)object).getNotAinB().saveToFile((String)object4 + "not_" + string3 + "_in_" + string4 + ".sync");
            ((SyncFileCompare)object).getInAnotB().saveToFile((String)object4 + "in_" + string3 + "_not_" + string4 + ".sync");
            if (!((SyncFileCompare)object).isVerbose()) continue;
            System.out.println("Done: " + (String)object4 + "A: " + ((SyncFile)object3).getSyncLines().size() + " B: " + ((SyncFile)object2).getSyncLines().size() + " inAinB: " + ((SyncFileCompare)object).getInAinB().getSyncLines().size() + " notAinB: " + ((SyncFileCompare)object).getNotAinB().getSyncLines().size() + " inAnotB: " + ((SyncFileCompare)object).getInAnotB().getSyncLines().size());
        }
        if (bl) {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("syncCompare.gmt")));
            int n = arrayList.size();
            object4 = new GMTSyncFile(n + 2, date, date2, printWriter);
            object3 = new Color(51, 255, 102);
            object2 = new Color(51, 102, 255);
            object = new Color(255, 51, 102);
            ((GMTSyncFile)object4).gmtHeader();
            ((GMTSyncFile)object4).setTextColor((Color)object3);
            ((GMTSyncFile)object4).setJustify("CM");
            ((GMTSyncFile)object4).label(new Date((date.getTime() + date2.getTime()) / 2L), n + 1, "Both");
            ((GMTSyncFile)object4).setTextColor((Color)object2);
            ((GMTSyncFile)object4).setJustify("LM");
            ((GMTSyncFile)object4).label(date, n + 1, "Only " + string3);
            ((GMTSyncFile)object4).setTextColor((Color)object);
            ((GMTSyncFile)object4).setJustify("RM");
            ((GMTSyncFile)object4).label(date2, n + 1, "Only " + string4);
            int n2 = 0;
            Collections.reverse(arrayList);
            for (String string6 : arrayList) {
                SyncFileCompare syncFileCompare = (SyncFileCompare)hashMap3.get(string6);
                ((GMTSyncFile)object4).setLineColor((Color)object3);
                ((GMTSyncFile)object4).plot(syncFileCompare.getInAinB(), ++n2);
                ((GMTSyncFile)object4).setLineColor((Color)object2);
                ((GMTSyncFile)object4).plot(syncFileCompare.getInAnotB(), n2);
                ((GMTSyncFile)object4).setLineColor((Color)object);
                ((GMTSyncFile)object4).plot(syncFileCompare.getNotAinB(), n2);
                ((GMTSyncFile)object4).setJustify("LB");
                ((GMTSyncFile)object4).setTextColor(Color.BLACK);
                ((GMTSyncFile)object4).label(date, n2, string6);
            }
            ((GMTSyncFile)object4).gmtTrailer();
            printWriter.close();
        }
    }
}

