/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.SeisFileRuntimeException;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SyncFile
implements Iterable<SyncLine> {
    String dccName;
    String dateModified;
    String[] extraHeaders;
    List<SyncLine> syncLines = new ArrayList<SyncLine>();
    private float tolerence = 0.01f;
    public static final float DEFAULT_TOLERENCE = 0.01f;
    public static final String SEPARATOR = "|";

    public static SyncFile load(File file) throws IOException, SeisFileException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            return SyncFile.load(bufferedReader);
        }
        catch (IOException iOException) {
            throw new IOException("Problem loading from file " + file, iOException);
        }
    }

    public static SyncFile load(BufferedReader bufferedReader) throws IOException, SeisFileException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("empty Sync file.");
        }
        String[] stringArray = string.split("\\|");
        String[] stringArray2 = new String[]{};
        if (stringArray.length > 2) {
            stringArray2 = new String[stringArray.length - 2];
            System.arraycopy(stringArray, 2, stringArray2, 0, stringArray2.length);
        }
        SyncFile syncFile = new SyncFile(stringArray[0], stringArray[1], stringArray2);
        while ((string = bufferedReader.readLine()) != null) {
            syncFile.addLine(SyncLine.parse(string));
        }
        bufferedReader.close();
        return syncFile;
    }

    public SyncFile(String string) {
        this(string, SyncLine.dateToString(new Date()));
    }

    public SyncFile(String string, String string2) {
        this(string, string2, new String[0]);
    }

    public SyncFile(String string, String string2, String[] stringArray) {
        this.dccName = string;
        this.dateModified = string2;
        this.extraHeaders = stringArray;
    }

    public SyncFile(String string, String string2, String[] stringArray, List<SyncLine> list) {
        this(string, string2, stringArray);
        this.syncLines = list;
    }

    public HashMap<String, SyncFile> splitByChannel() {
        HashMap<String, SyncFile> hashMap = new HashMap<String, SyncFile>();
        for (SyncLine syncLine : this) {
            String string = syncLine.net + "." + syncLine.sta + "." + syncLine.loc + "." + syncLine.chan;
            if (!hashMap.containsKey(string)) {
                SyncFile syncFile = new SyncFile(this.getDccName() + " " + string);
                hashMap.put(string, syncFile);
            }
            hashMap.get(string).addLine(syncLine);
        }
        return hashMap;
    }

    public SyncFile concatenate(SyncFile syncFile) {
        SyncLine syncLine;
        SyncLine syncLine2;
        SyncFile syncFile2 = new SyncFile(this.getDccName());
        syncFile2.syncLines.addAll(this.getSyncLines());
        ArrayList<SyncLine> arrayList = new ArrayList<SyncLine>();
        arrayList.addAll(syncFile.getSyncLines());
        if (syncFile2.getSyncLines().size() != 0 && syncFile.getSyncLines().size() != 0 && (syncLine2 = syncFile2.getSyncLines().get(this.getSyncLines().size() - 1)).isContiguous(syncLine = (SyncLine)arrayList.get(0), this.tolerence)) {
            syncFile2.getSyncLines().remove(syncFile2.getSyncLines().size() - 1);
            syncLine2 = syncLine2.concat(syncLine);
            syncFile2.addLine(syncLine2, true);
            arrayList.remove(0);
        }
        syncFile2.syncLines.addAll(arrayList);
        return syncFile2;
    }

    public void sort() {
        Collections.sort(this.syncLines);
    }

    public void addLine(SyncLine syncLine) {
        this.addLine(syncLine, false);
    }

    public void addLine(SyncLine syncLine, boolean bl) {
        SyncLine syncLine2;
        if (bl && this.syncLines.size() != 0 && (syncLine2 = this.syncLines.get(this.syncLines.size() - 1)).isContiguous(syncLine, this.tolerence)) {
            this.syncLines.remove(this.syncLines.size() - 1);
            syncLine = syncLine2.concat(syncLine);
        }
        this.syncLines.add(syncLine);
    }

    public void saveToFile(String string) throws IOException {
        this.saveToFile(new File(string));
    }

    public void saveToFile(File file) throws IOException {
        if (this.syncLines.size() != 0) {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            this.appendToWriter(printWriter, true);
            printWriter.close();
        }
    }

    public void appendToWriter(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println(this.getHeaderLine());
        }
        for (SyncLine syncLine : this.syncLines) {
            printWriter.println(syncLine.formatLine());
        }
        printWriter.flush();
    }

    public String getHeaderLine() {
        String string = "";
        for (int i = 0; i < this.extraHeaders.length; ++i) {
            string = string + SEPARATOR + this.extraHeaders[i];
        }
        return this.dccName + SEPARATOR + this.dateModified + string;
    }

    public String getDccName() {
        return this.dccName;
    }

    public void setDccName(String string) {
        this.dccName = string;
    }

    public String getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(String string) {
        this.dateModified = string;
    }

    public String[] getExtraHeaders() {
        return this.extraHeaders;
    }

    public void setExtraHeaders(String[] stringArray) {
        this.extraHeaders = stringArray;
    }

    public List<SyncLine> getSyncLines() {
        return this.syncLines;
    }

    public boolean isEmpty() {
        return this.getSyncLines().isEmpty();
    }

    public int size() {
        return this.getSyncLines().size();
    }

    public Date getEarliest() {
        List<SyncLine> list = this.getSyncLines();
        if (list.size() != 0) {
            SyncLine syncLine = list.get(0);
            return syncLine.getStartTime();
        }
        throw new SeisFileRuntimeException("SyncFile is empty");
    }

    public Date getLatest() {
        List<SyncLine> list = this.getSyncLines();
        if (list.size() != 0) {
            SyncLine syncLine = list.get(list.size() - 1);
            return syncLine.getEndTime();
        }
        throw new SeisFileRuntimeException("SyncFile is empty");
    }

    @Override
    public Iterator<SyncLine> iterator() {
        return this.getSyncLines().iterator();
    }
}

