/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileCompare;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class GMTSyncFile {
    Color lineColor = new Color(51, 102, 255);
    int lineWidth = 18;
    Color textColor = Color.BLACK;
    int textSize = 10;
    int textAngle = 0;
    int font = 1;
    String justify = "LM";
    int plotWidth = 10;
    int plotHeight = 6;
    String plotSizeUnit = "i";
    int numChannels;
    Date start;
    Date end;
    String baseFilename = "syncPlot";
    PrintWriter out;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public GMTSyncFile(int n, Date date, Date date2, PrintWriter printWriter) {
        this.start = date;
        this.end = date2;
        this.numChannels = n;
        this.out = printWriter;
    }

    public void gmtHeader() {
        this.out.println("BASE=\"" + this.baseFilename + "\"");
        this.out.println("PS=${BASE}.ps");
        this.out.println();
        String string = "-Bpa3of1o -Bsa1YS";
        if (this.end.getTime() - this.start.getTime() < 31622400000L) {
            string = "-Bpa1of1o -Bsa1YS";
        }
        if (this.end.getTime() - this.start.getTime() < 15552000000L) {
            string = "-Bpa7Rf1d -Bsa1OS";
        }
        if (this.end.getTime() - this.start.getTime() < 2592000000L) {
            string = "-Bpa1Rf6h -Bsa1OS";
        }
        if (this.end.getTime() - this.start.getTime() < 432000000L) {
            this.out.println("gmtset PLOT_CLOCK_FORMAT hh:mm");
            string = "-Bpa6Hf1h -Bsa1DS";
        }
        if (this.end.getTime() - this.start.getTime() < 86400000L) {
            string = "-Bpa15mf5m -Bsa1HS";
        }
        this.out.println("psbasemap -R" + this.sdf.format(this.start) + "/" + this.sdf.format(this.end) + "/0/" + this.numChannels + " -JX" + this.plotWidth + this.plotSizeUnit + "/" + this.plotHeight + this.plotSizeUnit + " " + string + " -K > $PS");
    }

    public void gmtTrailer() {
    }

    public void plot(SyncFile syncFile, int n) {
        this.out.println("psxy -R -JX -W" + this.getLineWidth() + "," + GMTSyncFile.colorToGMTRGB(this.lineColor) + " -m -O -K >> $PS <<END");
        for (SyncLine syncLine : syncFile) {
            this.out.println("> ");
            this.out.println(this.sdf.format(syncLine.getStartTime()) + " " + n);
            this.out.println(this.sdf.format(syncLine.getEndTime()) + " " + n);
        }
        this.out.println("END");
    }

    public void label(Date date, int n, String string) {
        this.out.println("pstext -R -JX -G" + GMTSyncFile.colorToGMTRGB(this.textColor) + " -O -K >> $PS <<END");
        this.out.println(this.sdf.format(date) + " " + n + " " + this.textSize + " " + this.textAngle + " " + this.font + " " + this.justify + " " + string);
        this.out.println("END");
    }

    public static String colorToGMTRGB(Color color) {
        return color.getRed() + "/" + color.getGreen() + "/" + color.getBlue();
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int n) {
        this.textSize = n;
    }

    public int getTextAngle() {
        return this.textAngle;
    }

    public void setTextAngle(int n) {
        this.textAngle = n;
    }

    public int getFont() {
        return this.font;
    }

    public void setFont(int n) {
        this.font = n;
    }

    public String getJustify() {
        return this.justify;
    }

    public void setJustify(String string) {
        this.justify = string;
    }

    public int getPlotWidth() {
        return this.plotWidth;
    }

    public void setPlotWidth(int n) {
        this.plotWidth = n;
    }

    public int getPlotHeight() {
        return this.plotHeight;
    }

    public void setPlotHeight(int n) {
        this.plotHeight = n;
    }

    public String getPlotSizeUnit() {
        return this.plotSizeUnit;
    }

    public void setPlotSizeUnit(String string) {
        this.plotSizeUnit = string;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(int n) {
        this.numChannels = n;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date date) {
        this.start = date;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date date) {
        this.end = date;
    }

    public String getBaseFilename() {
        return this.baseFilename;
    }

    public void setBaseFilename(String string) {
        this.baseFilename = string;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        SyncFile syncFile = SyncFile.load(new File(string));
        syncFile.sort();
        HashMap<String, SyncFile> hashMap = syncFile.splitByChannel();
        String string2 = SyncFileCompare.trimDotSync(string);
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string2 + ".gmt")));
        HashSet<String> hashSet = new HashSet<String>(hashMap.keySet());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        int n = arrayList.size();
        Date[] dateArray = SyncFileCompare.range(hashMap.values());
        Date date = dateArray[0];
        Date date2 = dateArray[1];
        GMTSyncFile gMTSyncFile = new GMTSyncFile(n + 1, date, date2, printWriter);
        gMTSyncFile.setBaseFilename(string2);
        gMTSyncFile.gmtHeader();
        int n2 = 0;
        for (String string3 : arrayList) {
            gMTSyncFile.plot(hashMap.get(string3), ++n2);
            gMTSyncFile.setJustify("LB");
            gMTSyncFile.setTextColor(Color.BLACK);
            gMTSyncFile.label(date, n2, string3);
        }
        gMTSyncFile.gmtTrailer();
        printWriter.close();
    }
}

