/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.StationXMLException;
import java.util.Iterator;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxUtil {
    public static StartElement expectStartElement(String string, XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().getLocalPart().equals(string)) {
            return xMLEventReader.nextEvent().asStartElement();
        }
        Location location = xMLEvent.getLocation();
        throw new StationXMLException("Expected a start <" + string + "> element at line " + location.getLineNumber() + ", " + location.getColumnNumber() + ": " + (xMLEvent.isStartElement() ? xMLEvent.asStartElement().getName().getLocalPart() : Integer.valueOf(xMLEvent.getEventType())));
    }

    public static String pullText(XMLEventReader xMLEventReader, String string) throws XMLStreamException, StationXMLException {
        String string2 = "";
        XMLEvent xMLEvent = xMLEventReader.nextEvent();
        if (xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().getLocalPart().equals(string)) {
            while (xMLEventReader.hasNext()) {
                XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
                if (xMLEvent2.isCharacters()) {
                    string2 = string2 + xMLEvent2.asCharacters().getData();
                    continue;
                }
                if (!xMLEvent2.isEndElement()) continue;
                return string2;
            }
            throw new StationXMLException("Ran out of XMLEvents before end of text element");
        }
        throw new StationXMLException("Expected START_ELEMENT of type " + string);
    }

    public static int pullInt(XMLEventReader xMLEventReader, String string) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Integer.parseInt(StaxUtil.pullText(xMLEventReader, string));
    }

    public static float pullFloat(XMLEventReader xMLEventReader, String string) throws NumberFormatException, XMLStreamException, StationXMLException {
        return Float.parseFloat(StaxUtil.pullText(xMLEventReader, string));
    }

    public static void skipToStartElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (!xMLEventReader.hasNext()) {
            return;
        }
        while (xMLEventReader.hasNext() && !xMLEventReader.peek().isStartElement()) {
            xMLEventReader.nextEvent();
        }
    }

    public static void skipToMatchingEnd(XMLEventReader xMLEventReader) throws XMLStreamException {
        int n = 0;
        XMLEvent xMLEvent = xMLEventReader.peek();
        if (xMLEvent.isStartElement() && xMLEventReader.hasNext()) {
            ++n;
            xMLEventReader.nextEvent();
        }
        while (n > 0 && xMLEventReader.hasNext()) {
            xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                ++n;
            } else if (xMLEvent.isEndElement()) {
                --n;
            }
            xMLEventReader.nextEvent();
        }
    }

    public static void skipToStartOrEndElement(XMLEventReader xMLEventReader) throws XMLStreamException {
        if (!xMLEventReader.hasNext()) {
            return;
        }
        while (xMLEventReader.hasNext() && !xMLEventReader.peek().isStartElement() && !xMLEventReader.peek().isEndElement()) {
            xMLEventReader.nextEvent();
        }
    }

    public static boolean hasNext(XMLEventReader xMLEventReader, String string, String string2) throws XMLStreamException {
        while (xMLEventReader.hasNext()) {
            if (xMLEventReader.peek().isStartElement()) {
                if (xMLEventReader.peek().asStartElement().getName().getLocalPart().equals(string)) {
                    return true;
                }
                xMLEventReader.next();
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEventReader.peek().isEndElement() && xMLEventReader.peek().asEndElement().getName().getLocalPart().equals(string2)) {
                return false;
            }
            xMLEventReader.next();
        }
        return false;
    }

    public static String pullAttribute(StartElement startElement, String string) throws StationXMLException {
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            if (!attribute.getName().getLocalPart().equals(string)) continue;
            return attribute.getValue();
        }
        throw new StationXMLException(string + " not found as an attribute");
    }

    public static Integer pullIntAttribute(StartElement startElement, String string) throws StationXMLException {
        return Integer.parseInt(StaxUtil.pullAttribute(startElement, string));
    }
}

