/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Channel;
import edu.sc.seis.seisFile.stationxml.Epoch;
import edu.sc.seis.seisFile.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.stationxml.IrisComment;
import edu.sc.seis.seisFile.stationxml.Network;
import edu.sc.seis.seisFile.stationxml.NetworkIterator;
import edu.sc.seis.seisFile.stationxml.Response;
import edu.sc.seis.seisFile.stationxml.StaMessage;
import edu.sc.seis.seisFile.stationxml.Station;
import edu.sc.seis.seisFile.stationxml.StationEpoch;
import edu.sc.seis.seisFile.stationxml.StationIterator;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class StationXMLClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws XMLStreamException, StationXMLException, IOException {
        Object object;
        if (stringArray.length != 2 || !stringArray[0].equals("-u")) {
            System.out.println("Usage: stationxmlclient -u url");
            System.out.println("       stationxmlclient -u http://www.iris.edu/ws/station/query?net=IU&sta=SNZO&chan=BHZ&level=chan");
            return;
        }
        URL uRL = new URL(stringArray[1]);
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode() != 200) {
            String string = "";
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader(((HttpURLConnection)object).getErrorStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string + string2 + "\n";
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    ((HttpURLConnection)object).disconnect();
                }
            }
            System.err.println("Error in connection with url: " + uRL);
            System.err.println(string);
            return;
        }
        object = XMLInputFactory.newInstance();
        XMLEventReader xMLEventReader = ((XMLInputFactory)object).createXMLEventReader(uRL.toString(), uRLConnection.getInputStream());
        XMLEvent xMLEvent = xMLEventReader.peek();
        while (!xMLEvent.isStartElement()) {
            xMLEvent = xMLEventReader.nextEvent();
            xMLEvent = xMLEventReader.peek();
        }
        System.out.println("StaMessage");
        StaMessage staMessage = new StaMessage(xMLEventReader);
        if (!staMessage.checkSchemaVersion()) {
            System.out.println("");
            System.out.println("WARNING: XmlSchema of this document does not match this code, results may be incorrect.");
            System.out.println("XmlSchema (code): http://www.data.scec.org/xml/station/20120307/");
            System.out.println("");
        }
        System.out.println("XmlSchema: " + staMessage.getXmlSchemaLocation());
        System.out.println("Source: " + staMessage.getSource());
        System.out.println("Sender: " + staMessage.getSender());
        System.out.println("Module: " + staMessage.getModule());
        System.out.println("SentDate: " + staMessage.getSentDate());
        NetworkIterator networkIterator = staMessage.getNetworks();
        while (networkIterator.hasNext()) {
            Network network = networkIterator.next();
            System.out.println("Network: " + network.getNetCode() + " " + network.getDescription() + " " + network.getStartDate() + " " + network.getEndDate());
            StationIterator stationIterator = network.getStations();
            while (stationIterator.hasNext()) {
                Station station = stationIterator.next();
                if (!network.getNetCode().equals(station.getNetCode())) {
                    throw new StationXMLException("Station in wrong network: " + network.getNetCode() + " != " + station.getNetCode() + "  " + xMLEventReader.peek().getLocation());
                }
                System.out.println("  Station: " + station.getNetCode() + "." + station.getStaCode() + " " + station.getStationEpochs().size());
                List<StationEpoch> list = station.getStationEpochs();
                for (StationEpoch stationEpoch : list) {
                    System.out.println("    Station Epoch: " + station.getNetCode() + "." + station.getStaCode() + "  " + stationEpoch.getStartDate() + " to " + stationEpoch.getEndDate());
                    for (IrisComment irisComment : stationEpoch.getIrisStationComments().getList()) {
                        System.out.println("          " + irisComment.getStartDate() + " " + irisComment.getEndDate() + " " + irisComment.getCommentClass() + " " + irisComment.getText());
                    }
                    List<Channel> list2 = stationEpoch.getChannelList();
                    Iterator object22 = list2.iterator();
                    while (object22.hasNext()) {
                        Channel channel = (Channel)object22.next();
                        List<Epoch> list3 = channel.getChanEpochList();
                        for (Epoch epoch : list3) {
                            System.out.println("      Channel Epoch: " + channel.getLocCode() + "." + channel.getChanCode() + "  " + epoch.getStartDate() + " to " + epoch.getEndDate());
                            for (IrisComment irisComment : epoch.getIrisChannelComments().getList()) {
                                System.out.println("          " + irisComment.getStartDate() + " " + irisComment.getEndDate() + " " + irisComment.getCommentClass() + " " + irisComment.getText());
                            }
                            if (epoch.getResponseList().size() == 0) continue;
                            float f = 1.0f;
                            for (Response response : epoch.getResponseList()) {
                                System.out.print("          Resp " + response.getStage());
                                if (response.getResponseItem() != null) {
                                    System.out.print(" " + response.getResponseItem().getInputUnits() + " " + response.getResponseItem().getOutputUnits());
                                }
                                if (response.getStageSensitivity() != null) {
                                    System.out.print(" " + response.getStageSensitivity().getSensitivityValue());
                                    if (response.getStage() != 0) {
                                        f *= response.getStageSensitivity().getSensitivityValue();
                                    }
                                }
                                System.out.println();
                            }
                            InstrumentSensitivity instrumentSensitivity = epoch.getInstrumentSensitivity();
                            System.out.println("          Overall Gain: " + f + "  Inst Sense: " + instrumentSensitivity.getSensitivityValue() + " " + instrumentSensitivity.getSensitivityUnits());
                        }
                    }
                }
            }
        }
        staMessage.closeReader();
    }
}

