/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.stationxml;

import edu.sc.seis.seisFile.stationxml.Channel;
import edu.sc.seis.seisFile.stationxml.IrisCommentList;
import edu.sc.seis.seisFile.stationxml.Site;
import edu.sc.seis.seisFile.stationxml.StationXMLException;
import edu.sc.seis.seisFile.stationxml.StaxUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StationEpoch {
    String startDate;
    String endDate;
    String creationDate;
    float lat;
    float lon;
    float elevation;
    String name;
    Site site;
    int totalNumChannels;
    int selectedNumChannels;
    List<Channel> channelList = new ArrayList<Channel>();
    IrisCommentList irisStationComments = new IrisCommentList("StationComments");

    public StationEpoch(XMLEventReader xMLEventReader) throws XMLStreamException, StationXMLException {
        StartElement startElement = StaxUtil.expectStartElement("StationEpoch", xMLEventReader);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.peek();
            if (xMLEvent.isStartElement()) {
                String string = xMLEvent.asStartElement().getName().getLocalPart();
                if (string.equals("StartDate")) {
                    this.startDate = StaxUtil.pullText(xMLEventReader, "StartDate");
                    continue;
                }
                if (string.equals("EndDate")) {
                    this.endDate = StaxUtil.pullText(xMLEventReader, "EndDate");
                    continue;
                }
                if (string.equals("Lat")) {
                    this.lat = StaxUtil.pullFloat(xMLEventReader, "Lat");
                    continue;
                }
                if (string.equals("Lon")) {
                    this.lon = StaxUtil.pullFloat(xMLEventReader, "Lon");
                    continue;
                }
                if (string.equals("Elevation")) {
                    this.elevation = StaxUtil.pullFloat(xMLEventReader, "Elevation");
                    continue;
                }
                if (string.equals("Site")) {
                    this.site = new Site(xMLEventReader);
                    continue;
                }
                if (string.equals("Name")) {
                    this.name = StaxUtil.pullText(xMLEventReader, "Name");
                    continue;
                }
                if (string.equals("CreationDate")) {
                    this.creationDate = StaxUtil.pullText(xMLEventReader, "CreationDate");
                    continue;
                }
                if (string.equals("TotalNumberChannels")) {
                    this.totalNumChannels = StaxUtil.pullInt(xMLEventReader, "TotalNumberChannels");
                    continue;
                }
                if (string.equals("SelectedNumberChannels")) {
                    this.selectedNumChannels = StaxUtil.pullInt(xMLEventReader, "SelectedNumberChannels");
                    continue;
                }
                if (string.equals("StationComments")) {
                    this.irisStationComments = new IrisCommentList(xMLEventReader, "StationComments");
                    continue;
                }
                if (string.equals("Channel")) {
                    this.channelList.add(new Channel(xMLEventReader));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(xMLEventReader);
                continue;
            }
            if (xMLEvent.isEndElement()) {
                xMLEventReader.nextEvent();
                return;
            }
            xMLEvent = xMLEventReader.nextEvent();
        }
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public float getLat() {
        return this.lat;
    }

    public float getLon() {
        return this.lon;
    }

    public float getElevation() {
        return this.elevation;
    }

    public String getName() {
        return this.name;
    }

    public Site getSite() {
        return this.site;
    }

    public int getTotalNumChannels() {
        return this.totalNumChannels;
    }

    public int getSelectedNumChannels() {
        return this.selectedNumChannels;
    }

    public List<Channel> getChannelList() {
        return this.channelList;
    }

    public IrisCommentList getIrisStationComments() {
        return this.irisStationComments;
    }
}

